/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.utils.TreeAsNode;
import org.rascalmpl.values.parsetrees.ITree;

public class VariableBecomesPattern
extends AbstractMatchingResult {
    private IMatchingResult pat;
    private IMatchingResult var;
    private boolean firstTime;

    public VariableBecomesPattern(IEvaluatorContext ctx, Expression x, IMatchingResult var, IMatchingResult pat) {
        super(ctx, x);
        this.pat = pat;
        this.var = var;
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        super.initMatch(subject);
        if (subject.getValue() instanceof TreeAsNode) {
            ITree tree = ((TreeAsNode)subject.getValue()).getTree();
            subject = ResultFactory.makeResult(tree.getType(), tree, this.ctx);
        }
        this.var.initMatch(subject);
        if (this.var.hasNext()) {
            this.pat.initMatch(subject);
            this.hasNext = this.pat.hasNext();
        } else {
            this.hasNext = false;
        }
    }

    @Override
    public void init() {
        super.init();
        this.firstTime = true;
    }

    @Override
    public List<IVarPattern> getVariables() {
        List<IVarPattern> first = this.var.getVariables();
        List<IVarPattern> second = this.pat.getVariables();
        ArrayList<IVarPattern> vars = new ArrayList<IVarPattern>(first.size() + second.size());
        vars.addAll(first);
        vars.addAll(second);
        return vars;
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        return this.pat.getType(env, patternVars);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext && this.pat.hasNext();
    }

    @Override
    public boolean next() {
        if (this.hasNext && this.pat.hasNext() && this.pat.next()) {
            if (this.firstTime) {
                if (this.var.hasNext() && this.var.next()) {
                    this.firstTime = false;
                    return true;
                }
                this.hasNext = false;
                return false;
            }
            return true;
        }
        this.hasNext = false;
        return false;
    }
}

