/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.rascalmpl.ast.Name;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.ListRelationResult;
import org.rascalmpl.interpreter.result.RelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.SyntaxError;
import org.rascalmpl.interpreter.staticErrors.UndeclaredField;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedOperation;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;

public class SourceLocationResult
extends ElementResult<ISourceLocation> {
    private static final Type intTuple = TypeFactory.getInstance().tupleType(TypeFactory.getInstance().integerType(), "line", TypeFactory.getInstance().integerType(), "column");

    public SourceLocationResult(Type type, ISourceLocation loc, IEvaluatorContext ctx) {
        super(type, loc, ctx);
    }

    @Override
    public Result<IValue> call(Type[] argTypes, IValue[] actuals, Map<String, IValue> keyArgValues) {
        if (actuals.length >= 2) {
            if (!argTypes[0].isSubtypeOf(this.getTypeFactory().integerType())) {
                throw new UnexpectedType(this.getTypeFactory().integerType(), argTypes[0], this.ctx.getCurrentAST());
            }
            if (!argTypes[1].isSubtypeOf(this.getTypeFactory().integerType())) {
                throw new UnexpectedType(this.getTypeFactory().integerType(), argTypes[1], this.ctx.getCurrentAST());
            }
            if (actuals.length == 4) {
                if (!argTypes[2].isSubtypeOf(intTuple)) {
                    throw new UnexpectedType(intTuple, argTypes[2], this.ctx.getCurrentAST());
                }
                if (!argTypes[3].isSubtypeOf(intTuple)) {
                    throw new UnexpectedType(intTuple, argTypes[3], this.ctx.getCurrentAST());
                }
            } else if (actuals.length != 2) {
                throw new SyntaxError("location constructor", this.ctx.getCurrentAST().getLocation());
            }
        } else {
            throw new SyntaxError("location constructor", this.ctx.getCurrentAST().getLocation());
        }
        int iLength = Integer.parseInt(actuals[1].toString());
        int iOffset = Integer.parseInt(actuals[0].toString());
        if (iLength < 0) {
            throw RuntimeExceptionFactory.illegalArgument(actuals[1], this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        if (iOffset < 0) {
            throw RuntimeExceptionFactory.illegalArgument(actuals[0], this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        if (actuals.length == 4) {
            int iBeginLine = Integer.parseInt(((ITuple)actuals[2]).get(0).toString());
            int iBeginColumn = Integer.parseInt(((ITuple)actuals[2]).get(1).toString());
            int iEndLine = Integer.parseInt(((ITuple)actuals[3]).get(0).toString());
            int iEndColumn = Integer.parseInt(((ITuple)actuals[3]).get(1).toString());
            if (iBeginLine < 0) {
                throw RuntimeExceptionFactory.illegalArgument(((ITuple)actuals[2]).get(0), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
            if (iBeginColumn < 0) {
                throw RuntimeExceptionFactory.illegalArgument(((ITuple)actuals[2]).get(1), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
            if (iEndLine < 0) {
                throw RuntimeExceptionFactory.illegalArgument(((ITuple)actuals[3]).get(0), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
            if (iEndColumn < 0) {
                throw RuntimeExceptionFactory.illegalArgument(((ITuple)actuals[3]).get(1), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
            return ResultFactory.makeResult(this.getTypeFactory().sourceLocationType(), this.getValueFactory().sourceLocation((ISourceLocation)this.getValue(), iOffset, iLength, iBeginLine, iEndLine, iBeginColumn, iEndColumn), this.ctx);
        }
        return ResultFactory.makeResult(this.getTypeFactory().sourceLocationType(), this.getValueFactory().sourceLocation((ISourceLocation)this.getValue(), iOffset, iLength), this.ctx);
    }

    @Override
    public Result<IBool> isDefined(Name name) {
        IValueFactory vf = this.getValueFactory();
        TypeFactory tf = this.getTypeFactory();
        String path = ((ISourceLocation)this.value).hasPath() ? ((ISourceLocation)this.value).getPath() : "";
        ISourceLocation value = (ISourceLocation)this.getValue();
        switch (Names.name(name)) {
            case "host": 
            case "user": 
            case "port": {
                if (!URIResolverRegistry.getInstance().supportsHost(value)) {
                    return ResultFactory.makeResult(tf.boolType(), vf.bool(false), this.ctx);
                }
            }
            case "path": 
            case "scheme": 
            case "authority": 
            case "query": 
            case "fragment": 
            case "uri": 
            case "top": 
            case "params": 
            case "extension": {
                return ResultFactory.makeResult(tf.boolType(), vf.bool(true), this.ctx);
            }
            case "length": 
            case "offset": {
                return ResultFactory.makeResult(tf.boolType(), vf.bool(value.hasOffsetLength()), this.ctx);
            }
            case "begin": 
            case "end": {
                return ResultFactory.makeResult(tf.boolType(), vf.bool(value.hasLineColumn()), this.ctx);
            }
            case "parent": {
                return ResultFactory.makeResult(tf.boolType(), vf.bool(!path.equals("") && !path.equals("/")), this.ctx);
            }
            case "file": {
                return ResultFactory.makeResult(tf.boolType(), vf.bool(!path.equals("") && !path.equals("/")), this.ctx);
            }
            case "ls": {
                return ResultFactory.makeResult(tf.boolType(), vf.bool(URIResolverRegistry.getInstance().exists(value) && URIResolverRegistry.getInstance().isDirectory(value)), this.ctx);
            }
        }
        return ResultFactory.makeResult(tf.boolType(), vf.bool(false), this.ctx);
    }

    @Override
    public <U extends IValue> Result<U> fieldAccess(String name, TypeStore store) {
        IValueFactory vf = this.getValueFactory();
        TypeFactory tf = this.getTypeFactory();
        ISourceLocation value = (ISourceLocation)this.getValue();
        String stringResult = null;
        Integer intResult = null;
        Integer tupleA = null;
        Integer tupleB = null;
        switch (name) {
            case "scheme": {
                stringResult = value.getScheme();
                break;
            }
            case "authority": {
                stringResult = value.hasAuthority() ? value.getAuthority() : "";
                break;
            }
            case "host": 
            case "user": 
            case "port": {
                URI uri = value.getURI();
                if (!URIResolverRegistry.getInstance().supportsHost(value)) {
                    throw new UndeclaredField(name, "The scheme " + uri.getScheme() + " does not support the " + name + " field, use authority instead.", tf.sourceLocationType(), this.ctx.getCurrentAST());
                }
                if (name.equals("host")) {
                    stringResult = uri.getHost();
                } else if (name.equals("user")) {
                    stringResult = uri.getUserInfo();
                } else {
                    intResult = uri.getPort();
                }
                if (stringResult != null || intResult != null) break;
                stringResult = "";
                break;
            }
            case "path": {
                stringResult = value.hasPath() ? value.getPath() : "/";
                break;
            }
            case "query": {
                stringResult = value.hasQuery() ? value.getQuery() : "";
                break;
            }
            case "fragment": {
                stringResult = value.hasFragment() ? value.getFragment() : "";
                break;
            }
            case "length": {
                if (value.hasOffsetLength()) {
                    intResult = value.getLength();
                    break;
                }
                throw RuntimeExceptionFactory.unavailableInformation(this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
            case "offset": {
                if (value.hasOffsetLength()) {
                    intResult = value.getOffset();
                    break;
                }
                throw RuntimeExceptionFactory.unavailableInformation(this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
            case "begin": {
                if (value.hasLineColumn()) {
                    tupleA = value.getBeginLine();
                    tupleB = value.getBeginColumn();
                    break;
                }
                throw RuntimeExceptionFactory.unavailableInformation(this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
            case "end": {
                if (value.hasLineColumn()) {
                    tupleA = value.getEndLine();
                    tupleB = value.getEndColumn();
                    break;
                }
                throw RuntimeExceptionFactory.unavailableInformation(this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
            case "uri": {
                stringResult = value.getURI().toString();
                break;
            }
            case "top": {
                return ResultFactory.makeResult(tf.sourceLocationType(), value.top(), this.ctx);
            }
            case "parent": {
                int i;
                Object path;
                Object object = path = value.hasPath() ? value.getPath() : "";
                if (((String)path).equals("") || ((String)path).equals("/")) {
                    throw RuntimeExceptionFactory.noParent((ISourceLocation)this.getValue(), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
                }
                if (((String)path).endsWith("/")) {
                    path = ((String)path).substring(0, ((String)path).length() - 1);
                }
                if ((i = ((String)path).lastIndexOf(47)) != -1) {
                    path = ((String)path).substring(0, i);
                    if (value.getScheme().equalsIgnoreCase("file") && ((String)path).lastIndexOf(47) == 0 && ((String)path).endsWith(":")) {
                        path = (String)path + "/";
                    }
                    return this.fieldUpdate("path", ResultFactory.makeResult(tf.stringType(), vf.string((String)path), this.ctx), store);
                }
                throw RuntimeExceptionFactory.noParent((ISourceLocation)this.getValue(), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
            case "file": {
                int i;
                String path;
                String string = path = value.hasPath() ? value.getPath() : "";
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if ((i = path.lastIndexOf(47)) != -1) {
                    stringResult = path.substring(i + 1);
                    break;
                }
                stringResult = path;
                break;
            }
            case "ls": {
                try {
                    if (!URIResolverRegistry.getInstance().exists(value)) {
                        throw RuntimeExceptionFactory.io(vf.string("You can only access ls on an existing location."), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
                    }
                    if (!URIResolverRegistry.getInstance().isDirectory(value)) {
                        throw RuntimeExceptionFactory.io(vf.string("You can only access ls on a directory, or a container."), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
                    }
                    IListWriter w = this.ctx.getValueFactory().listWriter();
                    for (ISourceLocation elem : URIResolverRegistry.getInstance().list(value)) {
                        w.append(elem);
                    }
                    IList result = (IList)w.done();
                    return ResultFactory.makeResult(result.getType(), result, this.ctx);
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io(vf.string(e.getMessage()), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
                }
            }
            case "extension": {
                int slashIndex;
                String path;
                String string = path = value.hasPath() ? value.getPath() : "";
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if ((slashIndex = path.lastIndexOf("/")) == -1) {
                    stringResult = "";
                    break;
                }
                int i = path.substring(slashIndex).lastIndexOf(46);
                if (i != -1) {
                    stringResult = path.substring(slashIndex + i + 1);
                    break;
                }
                stringResult = "";
                break;
            }
            case "params": {
                String query = value.hasQuery() ? value.getQuery() : "";
                IMapWriter res = vf.mapWriter();
                if (query != null && query.length() > 0) {
                    String[] params;
                    for (String param : params = query.split("&")) {
                        String[] keyValue = param.split("=");
                        res.put(vf.string(keyValue[0]), vf.string(keyValue[1]));
                    }
                }
                IMap map = (IMap)res.done();
                return ResultFactory.makeResult(map.getType(), map, this.ctx);
            }
            default: {
                throw new UndeclaredField(name, this.getTypeFactory().sourceLocationType(), this.ctx.getCurrentAST());
            }
        }
        if (stringResult != null) {
            return ResultFactory.makeResult(tf.stringType(), vf.string(stringResult), this.ctx);
        }
        if (intResult != null) {
            return ResultFactory.makeResult(tf.integerType(), vf.integer(intResult), this.ctx);
        }
        if (tupleA != null && tupleB != null) {
            return ResultFactory.makeResult(intTuple, vf.tuple(vf.integer(tupleA), vf.integer(tupleB)), this.ctx);
        }
        throw new RuntimeException("A case not handled? " + name);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> fieldUpdate(String name, Result<V> repl, TypeStore store) {
        ISourceLocation loc = (ISourceLocation)this.getValue();
        int iLength = loc.hasOffsetLength() ? loc.getLength() : -1;
        int iOffset = loc.hasOffsetLength() ? loc.getOffset() : -1;
        int iBeginLine = loc.hasLineColumn() ? loc.getBeginLine() : -1;
        int iBeginColumn = loc.hasLineColumn() ? loc.getBeginColumn() : -1;
        int iEndLine = loc.hasLineColumn() ? loc.getEndLine() : -1;
        int iEndColumn = loc.hasLineColumn() ? loc.getEndColumn() : -1;
        boolean uriPartChanged = false;
        String scheme = loc.getScheme();
        String authority = loc.hasAuthority() ? loc.getAuthority() : null;
        Object path = loc.hasPath() ? loc.getPath() : null;
        String query = loc.hasQuery() ? loc.getQuery() : null;
        String fragment = loc.hasFragment() ? loc.getFragment() : null;
        Type replType = repl.getStaticType();
        V replValue = repl.getValue();
        try {
            String newStringValue = null;
            if (replType.isString()) {
                newStringValue = ((IString)replValue).getValue();
            }
            if (name.equals("uri")) {
                if (!replType.isString()) {
                    throw new UnexpectedType(this.getTypeFactory().stringType(), replType, this.ctx.getCurrentAST());
                }
                URI uri = URIUtil.createFromEncoded(newStringValue);
                scheme = uri.getScheme();
                authority = uri.getAuthority();
                path = uri.getPath();
                query = uri.getQuery();
                fragment = uri.getFragment();
                uriPartChanged = true;
            } else if (name.equals("scheme")) {
                if (!replType.isString()) {
                    throw new UnexpectedType(this.getTypeFactory().stringType(), replType, this.ctx.getCurrentAST());
                }
                scheme = newStringValue;
                uriPartChanged = true;
            } else if (name.equals("authority")) {
                if (!replType.isString()) {
                    throw new UnexpectedType(this.getTypeFactory().stringType(), replType, this.ctx.getCurrentAST());
                }
                authority = newStringValue;
                uriPartChanged = true;
            } else if (name.equals("host")) {
                URI uri = ((ISourceLocation)this.value).getURI();
                if (!replType.isString()) {
                    throw new UnexpectedType(this.getTypeFactory().stringType(), replType, this.ctx.getCurrentAST());
                }
                if (!URIResolverRegistry.getInstance().supportsHost((ISourceLocation)this.value)) {
                    throw new UndeclaredField(name, "The scheme " + uri.getScheme() + " does not support the host field, use authority instead.", this.getTypeFactory().sourceLocationType(), this.ctx.getCurrentAST());
                }
                uri = URIUtil.changeHost(uri, newStringValue);
                authority = uri.getAuthority();
                uriPartChanged = true;
            } else if (name.equals("path")) {
                if (!replType.isString()) {
                    throw new UnexpectedType(this.getTypeFactory().stringType(), replType, this.ctx.getCurrentAST());
                }
                path = newStringValue;
                uriPartChanged = true;
            } else if (name.equals("file")) {
                if (!replType.isString()) {
                    throw new UnexpectedType(this.getTypeFactory().stringType(), replType, this.ctx.getCurrentAST());
                }
                boolean endsWithSlash = ((String)path).endsWith("/");
                path = endsWithSlash ? ((String)path).substring(0, ((String)path).length() - 1) : path;
                int i = ((String)path).lastIndexOf("/");
                path = i != -1 ? ((String)path).substring(0, i) + "/" + newStringValue : (String)path + "/" + newStringValue;
                if (endsWithSlash) {
                    path = (String)path + "/";
                }
                uriPartChanged = true;
            } else if (name.equals("parent")) {
                if (!replType.isString()) {
                    throw new UnexpectedType(this.getTypeFactory().stringType(), replType, this.ctx.getCurrentAST());
                }
                int i = ((String)path).lastIndexOf("/");
                Object parent = newStringValue;
                if (!((String)parent).startsWith("/")) {
                    parent = "/" + (String)parent;
                }
                path = i != -1 ? (String)parent + ((String)path).substring(i) : parent;
                uriPartChanged = true;
            } else {
                if (name.equals("ls")) {
                    throw new UnsupportedOperation("can not update the children of a location", this.ctx.getCurrentAST());
                }
                if (name.equals("extension")) {
                    if (!replType.isString()) {
                        throw new UnexpectedType(this.getTypeFactory().stringType(), replType, this.ctx.getCurrentAST());
                    }
                    path = URIUtil.changeExtension(loc, newStringValue).getPath();
                    uriPartChanged = true;
                } else if (name.equals("top")) {
                    if (replType.isString()) {
                        URI uri = URIUtil.assumeCorrect(newStringValue);
                        scheme = uri.getScheme();
                        authority = uri.getAuthority();
                        path = uri.getPath();
                        query = uri.getQuery();
                        fragment = uri.getFragment();
                    } else if (replType.isSourceLocation()) {
                        ISourceLocation rep = (ISourceLocation)repl.getValue();
                        scheme = rep.getScheme();
                        authority = rep.hasAuthority() ? rep.getAuthority() : null;
                        path = rep.hasPath() ? rep.getPath() : null;
                        query = rep.hasQuery() ? rep.getQuery() : null;
                        fragment = rep.hasFragment() ? rep.getFragment() : null;
                    } else {
                        throw new UnexpectedType(this.getTypeFactory().stringType(), replType, this.ctx.getCurrentAST());
                    }
                    uriPartChanged = true;
                } else if (name.equals("fragment")) {
                    if (!replType.isString()) {
                        throw new UnexpectedType(this.getTypeFactory().stringType(), replType, this.ctx.getCurrentAST());
                    }
                    fragment = newStringValue;
                    uriPartChanged = true;
                } else if (name.equals("query")) {
                    if (!replType.isString()) {
                        throw new UnexpectedType(this.getTypeFactory().stringType(), replType, this.ctx.getCurrentAST());
                    }
                    query = newStringValue;
                    uriPartChanged = true;
                } else if (name.equals("user")) {
                    if (!replType.isString()) {
                        throw new UnexpectedType(this.getTypeFactory().stringType(), replType, this.ctx.getCurrentAST());
                    }
                    URI uri = loc.getURI();
                    if (!URIResolverRegistry.getInstance().supportsHost((ISourceLocation)this.value)) {
                        throw new UndeclaredField(name, "The scheme " + uri.getScheme() + " does not support the user field, use authority instead.", this.getTypeFactory().sourceLocationType(), this.ctx.getCurrentAST());
                    }
                    if (uri.getHost() != null) {
                        uri = URIUtil.changeUserInformation(uri, newStringValue);
                    }
                    authority = uri.getAuthority();
                    uriPartChanged = true;
                } else if (name.equals("port")) {
                    if (!replType.isInteger()) {
                        throw new UnexpectedType(this.getTypeFactory().stringType(), replType, this.ctx.getCurrentAST());
                    }
                    URI uri = loc.getURI();
                    if (!URIResolverRegistry.getInstance().supportsHost((ISourceLocation)this.value)) {
                        throw new UndeclaredField(name, "The scheme " + uri.getScheme() + " does not support the port field, use authority instead.", this.getTypeFactory().sourceLocationType(), this.ctx.getCurrentAST());
                    }
                    if (uri.getHost() != null) {
                        int port = Integer.parseInt(((IInteger)repl.getValue()).getStringRepresentation());
                        uri = URIUtil.changePort(uri, port);
                    }
                    authority = uri.getAuthority();
                    uriPartChanged = true;
                } else if (name.equals("length")) {
                    if (!replType.isInteger()) {
                        throw new UnexpectedType(this.getTypeFactory().integerType(), replType, this.ctx.getCurrentAST());
                    }
                    iLength = ((IInteger)replValue).intValue();
                    if (iLength < 0) {
                        throw RuntimeExceptionFactory.illegalArgument(replValue, this.ctx.getCurrentAST(), this.ctx.getStackTrace());
                    }
                } else if (name.equals("offset")) {
                    if (!replType.isInteger()) {
                        throw new UnexpectedType(this.getTypeFactory().integerType(), replType, this.ctx.getCurrentAST());
                    }
                    iOffset = ((IInteger)replValue).intValue();
                    if (iOffset < 0) {
                        RuntimeExceptionFactory.illegalArgument(replValue, this.ctx.getCurrentAST(), this.ctx.getStackTrace());
                    }
                } else if (name.equals("begin")) {
                    if (!replType.isSubtypeOf(intTuple)) {
                        throw new UnexpectedType(intTuple, replType, this.ctx.getCurrentAST());
                    }
                    iBeginLine = ((IInteger)((ITuple)replValue).get(0)).intValue();
                    iBeginColumn = ((IInteger)((ITuple)replValue).get(1)).intValue();
                    if (iBeginColumn < 0 || iBeginLine < 0) {
                        throw RuntimeExceptionFactory.illegalArgument(replValue, this.ctx.getCurrentAST(), this.ctx.getStackTrace());
                    }
                } else if (name.equals("end")) {
                    if (!replType.isSubtypeOf(intTuple)) {
                        throw new UnexpectedType(intTuple, replType, this.ctx.getCurrentAST());
                    }
                    iEndLine = ((IInteger)((ITuple)replValue).get(0)).intValue();
                    iEndColumn = ((IInteger)((ITuple)replValue).get(1)).intValue();
                    if (iEndLine < 0 || iEndColumn < 0) {
                        throw RuntimeExceptionFactory.illegalArgument(replValue, this.ctx.getCurrentAST(), this.ctx.getStackTrace());
                    }
                } else {
                    throw new UndeclaredField(name, this.getTypeFactory().sourceLocationType(), this.ctx.getCurrentAST());
                }
            }
            ISourceLocation newLoc = loc;
            if (uriPartChanged) {
                newLoc = this.getValueFactory().sourceLocation(scheme, authority, (String)path, query, fragment);
            }
            if (loc.hasLineColumn()) {
                return ResultFactory.makeResult(this.getStaticType(), this.getValueFactory().sourceLocation(newLoc, iOffset, iLength, iBeginLine, iEndLine, iBeginColumn, iEndColumn), this.ctx);
            }
            if (loc.hasOffsetLength()) {
                if (iBeginLine != -1 || iBeginColumn != -1) {
                    iEndLine = iBeginLine;
                    iEndColumn = iBeginColumn;
                    return ResultFactory.makeResult(this.getStaticType(), this.getValueFactory().sourceLocation(newLoc, iOffset, iLength, iBeginLine, iEndLine, iBeginColumn, iEndColumn), this.ctx);
                }
                if (iEndLine != -1 || iEndColumn != -1) {
                    iBeginLine = iEndLine;
                    iBeginColumn = iEndColumn;
                    return ResultFactory.makeResult(this.getStaticType(), this.getValueFactory().sourceLocation(newLoc, iOffset, iLength, iBeginLine, iEndLine, iBeginColumn, iEndColumn), this.ctx);
                }
                return ResultFactory.makeResult(this.getStaticType(), this.getValueFactory().sourceLocation(newLoc, iOffset, iLength), this.ctx);
            }
            if (iBeginColumn != -1 || iEndColumn != -1 || iBeginLine != -1 || iBeginColumn != -1) {
                throw RuntimeExceptionFactory.invalidUseOfLocation("Can not add line/column information without offset/length", this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
            if (iOffset != -1 && iLength == -1) {
                iLength = 0;
            }
            if (iLength != -1 && iOffset == -1) {
                iOffset = 0;
            }
            if (iOffset != -1 || iLength != -1) {
                return ResultFactory.makeResult(this.getStaticType(), this.getValueFactory().sourceLocation(newLoc, iOffset, iLength), this.ctx);
            }
            return ResultFactory.makeResult(this.getStaticType(), newLoc, this.ctx);
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument(this.getValue(), "can not update field " + name + ": " + e.getMessage(), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        catch (URISyntaxException e) {
            throw RuntimeExceptionFactory.parseError(this.ctx.getCurrentAST().getLocation(), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToSourceLocation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToSourceLocation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> that) {
        return that.lessThanSourceLocation(this);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> that) {
        return that.lessThanOrEqualSourceLocation(this);
    }

    @Override
    protected Result<IBool> lessThanSourceLocation(SourceLocationResult that) {
        LessThanOrEqualResult loe = this.lessThanOrEqualSourceLocation(that);
        return ResultFactory.bool(loe.isLess().getValue().getValue() && !loe.isEqual().isTrue(), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanSourceLocation(SourceLocationResult that) {
        return that.lessThanSourceLocation(this);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualSourceLocation(SourceLocationResult that) {
        return that.lessThanSourceLocation(this);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualSourceLocation(SourceLocationResult that) {
        ISourceLocation left = (ISourceLocation)that.getValue();
        ISourceLocation right = (ISourceLocation)this.getValue();
        int compare = left.top().toString().compareTo(right.top().toString());
        if (compare < 0) {
            return new LessThanOrEqualResult(true, false, this.ctx);
        }
        if (compare > 0) {
            return new LessThanOrEqualResult(false, false, this.ctx);
        }
        if (left.hasOffsetLength()) {
            if (!right.hasOffsetLength()) {
                return new LessThanOrEqualResult(false, false, this.ctx);
            }
            int roffset = right.getOffset();
            int rlen = right.getLength();
            int loffset = left.getOffset();
            int llen = left.getLength();
            if (loffset == roffset) {
                return new LessThanOrEqualResult(llen < rlen, llen == rlen, this.ctx);
            }
            return new LessThanOrEqualResult(roffset < loffset && roffset + rlen >= loffset + llen, false, this.ctx);
        }
        if (compare == 0) {
            return new LessThanOrEqualResult(false, true, this.ctx);
        }
        if (!right.hasOffsetLength()) {
            throw new ImplementationError("assertion failed");
        }
        return new LessThanOrEqualResult(false, false, this.ctx);
    }

    @Override
    protected Result<IBool> equalToSourceLocation(SourceLocationResult that) {
        return that.equalityBoolean(this);
    }

    @Override
    protected Result<IBool> nonEqualToSourceLocation(SourceLocationResult that) {
        return that.nonEqualityBoolean(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> that) {
        return that.addSourceLocation(this);
    }

    @Override
    protected <U extends IValue> Result<U> addListRelation(ListRelationResult that) {
        return that.addSourceLocation(this);
    }

    @Override
    protected <U extends IValue> Result<U> addRelation(RelationResult that) {
        return that.addSourceLocation(this);
    }
}

