/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.FunctionDeclaration;
import org.rascalmpl.ast.KeywordFormal;
import org.rascalmpl.ast.Parameters;
import org.rascalmpl.ast.Tag;
import org.rascalmpl.ast.TagString;
import org.rascalmpl.ast.Tags;
import org.rascalmpl.ast.Type;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.JavaCompilation;
import org.rascalmpl.exceptions.JavaMethodLink;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.ideservices.BasicIDEServices;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.Configuration;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.NonAbstractJavaFunction;
import org.rascalmpl.interpreter.staticErrors.UndeclaredJavaMethod;
import org.rascalmpl.interpreter.utils.IResourceLocationProvider;
import org.rascalmpl.interpreter.utils.JavaCompiler;
import org.rascalmpl.interpreter.utils.JavaCompilerException;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.types.DefaultRascalTypeVisitor;
import org.rascalmpl.types.RascalType;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.util.ListClassLoader;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;

public class JavaBridge {
    private static final String JAVA_CLASS_TAG = "javaClass";
    private final List<ClassLoader> loaders;
    private static final JavaClasses javaClasses = new JavaClasses();
    private final IValueFactory vf;
    private final Map<Class<?>, Object> instanceCache;

    public JavaBridge(List<ClassLoader> classLoaders, IValueFactory valueFactory, Configuration config) {
        this.loaders = classLoaders;
        this.vf = valueFactory;
        this.instanceCache = new HashMap();
        if (ToolProvider.getSystemJavaCompiler() == null) {
            throw new ImplementationError("Could not find an installed System Java Compiler, please provide a Java Runtime that includes the Java Development Tools (JDK 1.6 or higher).");
        }
    }

    public <T> Class<T> compileJava(ISourceLocation loc, String className, String source) {
        return this.compileJava(loc, className, Evaluator.class, source);
    }

    public void compileJava(ISourceLocation loc, String className, String source, OutputStream classBytes) {
        this.compileJava(loc, className, Evaluator.class, source, classBytes);
    }

    public <T> Class<T> compileJava(ISourceLocation loc, String className, Class<?> parent, String source) {
        try {
            List<String> commandline = Arrays.asList("-proc:none", "--release", "11");
            JavaCompiler javaCompiler = new JavaCompiler(parent.getClassLoader(), null, commandline);
            Class result = javaCompiler.compile(className, (CharSequence)source, null, Object.class);
            return result;
        }
        catch (ClassCastException e) {
            throw new JavaCompilation(e.getMessage(), 1L, 0L, source, e);
        }
        catch (JavaCompilerException e) {
            if (!e.getDiagnostics().getDiagnostics().isEmpty()) {
                Diagnostic<JavaFileObject> msg = e.getDiagnostics().getDiagnostics().iterator().next();
                throw new JavaCompilation(msg.getMessage(null), msg.getLineNumber(), msg.getColumnNumber(), source, e);
            }
            throw new JavaCompilation(e.getMessage(), 1L, 0L, source, e);
        }
    }

    public Class<?> loadClass(InputStream in) throws IOException, ClassNotFoundException, URISyntaxException {
        List<String> commandline = Arrays.asList("-proc:none");
        JavaCompiler javaCompiler = new JavaCompiler(this.getClass().getClassLoader(), null, commandline);
        return javaCompiler.load(in);
    }

    public <T> void compileJava(ISourceLocation loc, String className, Class<?> parent, String source, OutputStream classBytes) {
        try {
            List<String> commandline = Arrays.asList("-proc:none");
            JavaCompiler javaCompiler = new JavaCompiler(parent.getClassLoader(), null, commandline);
            javaCompiler.compile(classBytes, className, source, null);
        }
        catch (ClassCastException e) {
            throw new JavaCompilation(e.getMessage(), 1L, 0L, source, e);
        }
        catch (JavaCompilerException e) {
            if (!e.getDiagnostics().getDiagnostics().isEmpty()) {
                Diagnostic<JavaFileObject> msg = e.getDiagnostics().getDiagnostics().iterator().next();
                throw new JavaCompilation(msg.getMessage(null), msg.getLineNumber(), msg.getColumnNumber(), source, e);
            }
            throw new JavaCompilation(e.getMessage(), 1L, 0L, source, e);
        }
    }

    private String getClassName(FunctionDeclaration declaration) {
        Tags tags = declaration.getTags();
        if (tags.hasTags()) {
            for (Tag tag : tags.getTags()) {
                if (!Names.name(tag.getName()).equals(JAVA_CLASS_TAG) || !tag.hasContents()) continue;
                String contents = ((TagString.Lexical)tag.getContents()).getString();
                if (contents.length() > 2 && contents.startsWith("{")) {
                    contents = contents.substring(1, contents.length() - 1);
                }
                return contents;
            }
        }
        return "";
    }

    private Class<?>[] getJavaTypes(Parameters parameters, Environment env, boolean hasReflectiveAccess) {
        Class clazz;
        List<Expression> formals = parameters.getFormals().getFormals();
        int arity = formals.size();
        int kwArity = 0;
        List<KeywordFormal> keywordFormals = null;
        if (parameters.getKeywordFormals().isDefault()) {
            keywordFormals = parameters.getKeywordFormals().getKeywordFormalList();
            kwArity = keywordFormals.size();
        }
        Class[] classes = new Class[arity + kwArity + (hasReflectiveAccess ? 1 : 0)];
        int i = 0;
        while (i < arity) {
            clazz = i == arity - 1 && parameters.isVarArgs() ? IList.class : this.toJavaClass(formals.get(i), env);
            if (clazz == null) continue;
            classes[i++] = clazz;
        }
        while (i < arity + kwArity) {
            clazz = this.toJavaClass(keywordFormals.get(i - arity).getType(), env);
            if (clazz == null) continue;
            classes[i++] = clazz;
        }
        if (hasReflectiveAccess) {
            classes[arity + kwArity] = IEvaluatorContext.class;
        }
        return classes;
    }

    private Class<?> toJavaClass(Expression formal, Environment env) {
        return this.toJavaClass(this.toValueType(formal, env));
    }

    private Class<?> toJavaClass(Type tp, Environment env) {
        return this.toJavaClass(tp.typeOf(env, null, false));
    }

    private Class<?> toJavaClass(io.usethesource.vallang.type.Type type) {
        return (Class)type.accept(javaClasses);
    }

    private io.usethesource.vallang.type.Type toValueType(Expression formal, Environment env) {
        return formal.typeOf(env, null, false);
    }

    public synchronized Object getJavaClassInstance(FunctionDeclaration func, IRascalMonitor monitor, TypeStore store, PrintWriter out, PrintWriter err, Reader in, final IEvaluatorContext ctx) {
        String className = this.getClassName(func);
        PrintWriter[] outputs = new PrintWriter[]{out, err};
        int writers = 0;
        try {
            for (ClassLoader loader : this.loaders) {
                try {
                    Class<?> clazz = loader.loadClass(className);
                    Object instance = this.instanceCache.get(clazz);
                    if (instance != null) {
                        return instance;
                    }
                    if (clazz.getConstructors().length > 1) {
                        throw new IllegalArgumentException("Rascal JavaBridge can only deal with one constructor. This class has multiple: " + clazz);
                    }
                    Constructor<?>[] constructors = clazz.getConstructors();
                    if (constructors.length < 1) {
                        throw new JavaMethodLink(className, "no public constructors found", new IllegalArgumentException(className));
                    }
                    if (constructors.length != 1) {
                        throw new JavaMethodLink(className, "more than one public constructor found", new IllegalArgumentException(className));
                    }
                    Constructor<?> constructor = constructors[0];
                    Object[] args = new Object[constructor.getParameterCount()];
                    Class<?>[] formals = constructor.getParameterTypes();
                    for (int i = 0; i < constructor.getParameterCount(); ++i) {
                        if (formals[i].isAssignableFrom(IValueFactory.class)) {
                            args[i] = this.vf;
                            continue;
                        }
                        if (formals[i].isAssignableFrom(TypeStore.class)) {
                            args[i] = store;
                            continue;
                        }
                        if (formals[i].isAssignableFrom(TypeFactory.class)) {
                            args[i] = TypeFactory.getInstance();
                            continue;
                        }
                        if (formals[i].isAssignableFrom(PrintWriter.class)) {
                            args[i] = outputs[writers++ % 2];
                            continue;
                        }
                        if (formals[i].isAssignableFrom(Reader.class)) {
                            args[i] = in;
                            continue;
                        }
                        if (formals[i].isAssignableFrom(IRascalMonitor.class)) {
                            args[i] = monitor;
                            continue;
                        }
                        if (formals[i].isAssignableFrom(ClassLoader.class)) {
                            args[i] = new ListClassLoader(this.loaders, this.getClass().getClassLoader());
                            continue;
                        }
                        if (formals[i].isAssignableFrom(IRascalValueFactory.class)) {
                            args[i] = ctx.getFunctionValueFactory();
                            continue;
                        }
                        if (formals[i].isAssignableFrom(IDEServices.class)) {
                            if (monitor instanceof IDEServices) {
                                args[i] = (IDEServices)monitor;
                                continue;
                            }
                            args[i] = new BasicIDEServices(err, monitor, null);
                            continue;
                        }
                        if (formals[i].isAssignableFrom(IResourceLocationProvider.class)) {
                            args[i] = new IResourceLocationProvider(){

                                @Override
                                public Set<ISourceLocation> findResources(String fileName) {
                                    HashSet<ISourceLocation> result = new HashSet<ISourceLocation>();
                                    URIResolverRegistry reg = URIResolverRegistry.getInstance();
                                    for (ISourceLocation dir : ctx.getEvaluator().getRascalResolver().collect()) {
                                        ISourceLocation full = URIUtil.getChildLocation(dir, fileName);
                                        if (!reg.exists(full)) continue;
                                        result.add(full);
                                    }
                                    return result;
                                }
                            };
                            continue;
                        }
                        throw new IllegalArgumentException(constructor + " has unknown kinds of arguments.");
                    }
                    instance = constructor.newInstance(args);
                    this.instanceCache.put(clazz, instance);
                    return instance;
                }
                catch (ClassNotFoundException e) {
                }
            }
        }
        catch (NoClassDefFoundError e) {
            throw new JavaMethodLink(className, e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new JavaMethodLink(className, e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new JavaMethodLink(className, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new JavaMethodLink(className, e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new JavaMethodLink(className, e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new JavaMethodLink(className, e.getMessage(), e);
        }
        throw new JavaMethodLink(className, "class not found", null);
    }

    public Method lookupJavaMethod(IEvaluator<Result<IValue>> eval, FunctionDeclaration func, Environment env, boolean hasReflectiveAccess) {
        if (!func.isAbstract()) {
            throw new NonAbstractJavaFunction(func);
        }
        String className = this.getClassName(func);
        String name = Names.name(func.getSignature().getName());
        for (ClassLoader loader : this.loaders) {
            try {
                Class<?> clazz = loader.loadClass(className);
                Parameters parameters = func.getSignature().getParameters();
                Class<?>[] javaTypes = this.getJavaTypes(parameters, env, hasReflectiveAccess);
                try {
                    Method m4 = javaTypes.length > 0 ? clazz.getMethod(name, javaTypes) : clazz.getMethod(name, new Class[0]);
                    return m4;
                }
                catch (SecurityException e) {
                    throw RuntimeExceptionFactory.permissionDenied(this.vf.string(e.getMessage()), eval.getCurrentAST(), eval.getStackTrace());
                }
                catch (NoSuchMethodException e) {
                    throw new UndeclaredJavaMethod(e.getMessage(), func);
                }
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new UndeclaredJavaMethod(className + "." + name, func);
    }

    private static class JavaClasses
    extends DefaultRascalTypeVisitor<Class<?>, RuntimeException> {
        public JavaClasses() {
            super(IValue.class);
        }

        @Override
        public Class<?> visitBool(io.usethesource.vallang.type.Type boolType) {
            return IBool.class;
        }

        @Override
        public Class<?> visitReal(io.usethesource.vallang.type.Type type) {
            return IReal.class;
        }

        @Override
        public Class<?> visitInteger(io.usethesource.vallang.type.Type type) {
            return IInteger.class;
        }

        @Override
        public Class<?> visitRational(io.usethesource.vallang.type.Type type) {
            return IRational.class;
        }

        @Override
        public Class<?> visitNumber(io.usethesource.vallang.type.Type type) {
            return INumber.class;
        }

        @Override
        public Class<?> visitList(io.usethesource.vallang.type.Type type) {
            return IList.class;
        }

        @Override
        public Class<?> visitMap(io.usethesource.vallang.type.Type type) {
            return IMap.class;
        }

        @Override
        public Class<?> visitAlias(io.usethesource.vallang.type.Type type) {
            return (Class)type.getAliased().accept(this);
        }

        @Override
        public Class<?> visitAbstractData(io.usethesource.vallang.type.Type type) {
            return IConstructor.class;
        }

        @Override
        public Class<?> visitSet(io.usethesource.vallang.type.Type type) {
            return ISet.class;
        }

        @Override
        public Class<?> visitSourceLocation(io.usethesource.vallang.type.Type type) {
            return ISourceLocation.class;
        }

        @Override
        public Class<?> visitString(io.usethesource.vallang.type.Type type) {
            return IString.class;
        }

        @Override
        public Class<?> visitNode(io.usethesource.vallang.type.Type type) {
            return INode.class;
        }

        @Override
        public Class<?> visitConstructor(io.usethesource.vallang.type.Type type) {
            return IConstructor.class;
        }

        @Override
        public Class<?> visitTuple(io.usethesource.vallang.type.Type type) {
            return ITuple.class;
        }

        @Override
        public Class<?> visitValue(io.usethesource.vallang.type.Type type) {
            return IValue.class;
        }

        @Override
        public Class<?> visitVoid(io.usethesource.vallang.type.Type type) {
            return null;
        }

        @Override
        public Class<?> visitParameter(io.usethesource.vallang.type.Type parameterType) {
            return (Class)parameterType.getBound().accept(this);
        }

        @Override
        public Class<?> visitDateTime(io.usethesource.vallang.type.Type type) {
            return IDateTime.class;
        }

        @Override
        public Class<?> visitNonTerminal(RascalType type) throws RuntimeException {
            return ITree.class;
        }

        @Override
        public Class<?> visitFunction(io.usethesource.vallang.type.Type type) throws RuntimeException {
            return IFunction.class;
        }
    }
}

