/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.rascalmpl.interpreter.utils.ClassLoaderImpl;
import org.rascalmpl.interpreter.utils.FileManagerImpl;
import org.rascalmpl.interpreter.utils.JavaCompilerException;
import org.rascalmpl.interpreter.utils.JavaFileObjectImpl;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;

public class JavaCompiler<T> {
    static final String JAVA_EXTENSION = ".java";
    private final ClassLoaderImpl classLoader;
    private final javax.tools.JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final List<String> options;
    private DiagnosticCollector<JavaFileObject> diagnostics;
    private final FileManagerImpl javaFileManager;

    public JavaCompiler(ClassLoader loader, JavaFileManager parentFileManager, Iterable<String> options) {
        if (this.compiler == null) {
            throw new IllegalStateException("Cannot find the system Java compiler. Check that your class path includes tools.jar");
        }
        this.classLoader = new ClassLoaderImpl(loader);
        this.diagnostics = new DiagnosticCollector();
        JavaFileManager fileManager = parentFileManager == null ? this.compiler.getStandardFileManager(this.diagnostics, null, null) : parentFileManager;
        this.javaFileManager = new FileManagerImpl(fileManager, this.classLoader);
        this.options = new ArrayList<String>();
        if (options != null) {
            for (String option : options) {
                this.options.add(option);
            }
        }
    }

    public synchronized Class<T> compile(String qualifiedClassName, CharSequence javaSource, DiagnosticCollector<JavaFileObject> diagnosticsList, Class<?> ... types) throws JavaCompilerException, ClassCastException {
        this.diagnostics = diagnosticsList != null ? diagnosticsList : new DiagnosticCollector();
        HashMap<String, CharSequence> classes = new HashMap<String, CharSequence>(1);
        classes.put(qualifiedClassName, javaSource);
        Map<String, Class<?>> compiled = this.compile(classes, this.diagnostics);
        Class<?> newClass = compiled.get(qualifiedClassName);
        return this.castable(newClass, types);
    }

    public synchronized Map<String, Class<?>> compile(Map<String, CharSequence> classes, DiagnosticCollector<JavaFileObject> diagnostics) throws JavaCompilerException {
        if (diagnostics == null) {
            diagnostics = new DiagnosticCollector();
        }
        try {
            List<JavaFileObject> sources = this.registerSourceFiles(classes);
            JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.javaFileManager, diagnostics, this.options, null, sources);
            Boolean result = task.call();
            if (result == null || !result.booleanValue()) {
                throw new JavaCompilerException("Compilation failed.", classes.keySet(), diagnostics);
            }
            HashMap compiled = new HashMap();
            for (String qualifiedClassName : classes.keySet()) {
                Class<T> newClass = this.loadClass(qualifiedClassName);
                compiled.put(qualifiedClassName, newClass);
            }
            return compiled;
        }
        catch (ClassNotFoundException e) {
            throw new JavaCompilerException(classes.keySet(), e, diagnostics);
        }
        catch (IllegalArgumentException e) {
            throw new JavaCompilerException(classes.keySet(), e, diagnostics);
        }
        catch (SecurityException e) {
            throw new JavaCompilerException(classes.keySet(), e, diagnostics);
        }
        catch (URISyntaxException e) {
            throw new JavaCompilerException(classes.keySet(), e, diagnostics);
        }
    }

    public synchronized void compileTo(ISet classes, ClassLoader loader, ISourceLocation target, DiagnosticCollector<JavaFileObject> diagnostics) throws JavaCompilerException, URISyntaxException {
        if (diagnostics == null) {
            diagnostics = new DiagnosticCollector();
        }
        List<JavaFileObject> sources = this.registerSourceFiles(classes);
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.javaFileManager, diagnostics, this.options, null, sources);
        task.call();
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        for (Map.Entry<JavaFileObjectImpl, byte[]> e : this.javaFileManager.getAllClassBytes().entrySet()) {
            ISourceLocation output = URIUtil.getChildLocation(target, e.getKey().toUri().getPath().replaceAll("\\.", "/"));
            output = URIUtil.changeExtension(output, "class");
            try {
                OutputStream out = reg.getOutputStream(output, false);
                try {
                    out.write(e.getValue());
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
            catch (IOException x) {
                throw new JavaCompilerException(Set.of(e.getKey().toUri().getPath()), x, diagnostics);
            }
        }
    }

    private List<JavaFileObject> registerSourceFiles(ISet classes) throws URISyntaxException {
        ArrayList<JavaFileObject> sources = new ArrayList<JavaFileObject>();
        for (IValue entry : classes) {
            ISourceLocation sloc = (ISourceLocation)((ITuple)entry).get(0);
            String qname = ((IString)((ITuple)entry).get(1)).getValue();
            String javaSource = ((IString)((ITuple)entry).get(2)).getValue();
            if (javaSource == null) continue;
            JavaFileObjectImpl source = new JavaFileObjectImpl(sloc, qname.replaceAll("\\.", "/"), javaSource);
            sources.add(source);
            int dotPos = qname.lastIndexOf(46);
            String className = dotPos == -1 ? qname : qname.substring(dotPos + 1);
            String packageName = dotPos == -1 ? "" : qname.substring(0, dotPos);
            this.javaFileManager.putFileForInput(StandardLocation.SOURCE_PATH, packageName, className + JAVA_EXTENSION, source);
        }
        return sources;
    }

    private List<JavaFileObject> registerSourceFiles(Map<String, CharSequence> classes) throws URISyntaxException {
        ArrayList<JavaFileObject> sources = new ArrayList<JavaFileObject>();
        for (Map.Entry<String, CharSequence> entry : classes.entrySet()) {
            String qualifiedClassName = entry.getKey();
            CharSequence javaSource = entry.getValue();
            if (javaSource == null) continue;
            int dotPos = qualifiedClassName.lastIndexOf(46);
            String className = dotPos == -1 ? qualifiedClassName : qualifiedClassName.substring(dotPos + 1);
            String packageName = dotPos == -1 ? "" : qualifiedClassName.substring(0, dotPos);
            JavaFileObjectImpl source = new JavaFileObjectImpl(className, javaSource);
            sources.add(source);
            this.javaFileManager.putFileForInput(StandardLocation.SOURCE_PATH, packageName, className + JAVA_EXTENSION, source);
        }
        return sources;
    }

    public void compile(OutputStream classBytes, String qualifiedClassName, CharSequence classSource, DiagnosticCollector<JavaFileObject> diagnostics) throws JavaCompilerException {
        HashMap<String, CharSequence> fileMap = new HashMap<String, CharSequence>();
        try {
            fileMap.put(qualifiedClassName, classSource);
            this.compile(fileMap, diagnostics);
            this.classLoader.outputClassesToJar(qualifiedClassName, classBytes);
        }
        catch (IOException e) {
            throw new JavaCompilerException(fileMap.keySet(), e, diagnostics);
        }
    }

    public Class<?> load(InputStream file) throws IOException, ClassNotFoundException, URISyntaxException {
        return this.classLoader.inputClassesFromJar(file);
    }

    public Class<T> loadClass(String qualifiedClassName) throws ClassNotFoundException {
        return this.classLoader.loadClass(qualifiedClassName);
    }

    private Class<T> castable(Class<T> newClass, Class<?> ... types) throws ClassCastException {
        for (Class<T> clazz : types) {
            if (clazz.isAssignableFrom(newClass)) continue;
            throw new ClassCastException(clazz.getName());
        }
        return newClass;
    }

    static URI toURI(String name) {
        try {
            return URIUtil.createFromEncoded(name);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static URI toURI(ISourceLocation loc) {
        return loc.getURI();
    }

    public ClassLoader getClassLoader() {
        return this.javaFileManager.getClassLoader();
    }

    public JavaFileManager getFileManager() {
        return this.javaFileManager;
    }
}

