/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValueFactory;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.utils.Count;
import org.rascalmpl.values.ValueFactoryFactory;

public class Profiler
extends Thread {
    private Evaluator eval;
    private volatile boolean running;
    private long resolution = 1L;
    private final Map<ISourceLocation, Count> ast;
    private final Map<ISourceLocation, Count> frame;
    private final Map<ISourceLocation, String> names;

    public Profiler(Evaluator ev) {
        super("Rascal-Sampling-Profiler");
        this.eval = ev;
        this.ast = new HashMap<ISourceLocation, Count>();
        this.frame = new HashMap<ISourceLocation, Count>();
        this.names = new HashMap<ISourceLocation, String>();
        this.running = true;
    }

    @Override
    public void run() {
        while (this.running) {
            AbstractAST current = this.eval.getCurrentAST();
            Environment env = this.eval.getCurrentEnvt();
            String name = env.getName();
            if (current != null) {
                Count currentCount;
                ISourceLocation stat = current.getLocation();
                if (stat != null) {
                    currentCount = this.ast.get(stat);
                    if (currentCount == null) {
                        this.ast.put(stat, new Count());
                        this.names.put(stat, name);
                    } else {
                        currentCount.increment();
                    }
                }
                while (env.getParent() != null && !env.getParent().isRootScope() && !env.isFunctionFrame()) {
                    env = env.getParent();
                }
                if (env != null) {
                    currentCount = this.frame.get(env.getLocation());
                    if (currentCount == null) {
                        this.frame.put(env.getLocation(), new Count());
                        this.names.put(env.getLocation(), env.getName());
                    } else {
                        currentCount.increment();
                    }
                }
            }
            try {
                Profiler.sleep(this.resolution);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void pleaseStop() {
        this.running = false;
    }

    private List<Map.Entry<ISourceLocation, Count>> sortData(Map<ISourceLocation, Count> data) {
        Vector<Map.Entry<ISourceLocation, Count>> sortedData = new Vector<Map.Entry<ISourceLocation, Count>>(data.entrySet());
        Collections.sort(sortedData, new Comparator<Map.Entry<ISourceLocation, Count>>(){

            @Override
            public int compare(Map.Entry<ISourceLocation, Count> entry1, Map.Entry<ISourceLocation, Count> entry2) {
                return entry1.getValue().getTicks() == entry2.getValue().getTicks() ? 0 : (entry1.getValue().getTicks() < entry2.getValue().getTicks() ? 1 : -1);
            }
        });
        return sortedData;
    }

    public IList getProfileData() {
        IValueFactory VF = ValueFactoryFactory.getValueFactory();
        IListWriter w = VF.listWriter();
        for (Map.Entry<ISourceLocation, Count> e : this.sortData(this.ast)) {
            w.insert(VF.tuple(e.getKey(), VF.integer(e.getValue().getTicks())));
        }
        return (IList)w.done();
    }

    public void report() {
        this.report("FRAMES", this.frame);
        this.eval.getOutPrinter().println();
        this.report("ASTS", this.ast);
    }

    private void report(String title, Map<ISourceLocation, Count> data) {
        List<Map.Entry<ISourceLocation, Count>> sortedData = this.sortData(data);
        int maxName = 1;
        long nTicks = 0L;
        for (Map.Entry<ISourceLocation, Count> e : sortedData) {
            int sz = this.names.get(e.getKey()).length();
            if (sz > maxName) {
                maxName = sz;
            }
            nTicks += (long)e.getValue().getTicks();
        }
        PrintWriter out = this.eval.getOutPrinter();
        String nameFormat = "%" + maxName + "s";
        out.printf(title + " PROFILE: %d data points, %d ticks, tick = %d milliSecs\n", this.ast.size(), nTicks, this.resolution);
        out.printf(nameFormat + "%8s%9s  %s\n", " Scope", "Ticks", "%", "Source");
        for (Map.Entry<ISourceLocation, Count> e : sortedData) {
            String L = e.getKey().toString();
            String name = this.names.get(e.getKey());
            int ticks = e.getValue().getTicks();
            double perc = (double)ticks * 100.0 / (double)nTicks;
            if (perc < 1.0) break;
            String source = String.format("%s", L);
            out.printf(nameFormat + "%8d%8.1f%%  %s\n", name, ticks, perc, source);
        }
        out.flush();
    }
}

