/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.analysis.formalconcepts;

import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;

public class FCA {
    private final IValueFactory vf;

    public FCA(IValueFactory vf) {
        this.vf = vf;
    }

    public ISet sigma(ISet fc, ISet objects) {
        IRelation<ISet> fcRelation = fc.asRelation();
        if (objects.isEmpty()) {
            return fcRelation.range();
        }
        ISetWriter result = this.vf.setWriter();
        for (IValue attr : fcRelation.range()) {
            boolean all = true;
            for (IValue obj : objects) {
                if (all &= fc.contains(this.vf.tuple(obj, attr))) continue;
                break;
            }
            if (!all) continue;
            result.insert(attr);
        }
        return (ISet)result.done();
    }

    public ISet tau(ISet fc, ISet attributes) {
        IRelation<ISet> fcRelation = fc.asRelation();
        if (attributes.isEmpty()) {
            return fcRelation.domain();
        }
        ISetWriter result = this.vf.setWriter();
        for (IValue obj : fcRelation.domain()) {
            boolean all = true;
            for (IValue attr : attributes) {
                if (all &= fc.contains(this.vf.tuple(obj, attr))) continue;
                break;
            }
            if (!all) continue;
            result.insert(obj);
        }
        return (ISet)result.done();
    }
}

