/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.analysis.statistics;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import org.apache.commons.math.MathException;
import org.apache.commons.math.stat.regression.SimpleRegression;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;

public class SimpleRegressions {
    private final IValueFactory values;

    public SimpleRegressions(IValueFactory values) {
        this.values = values;
    }

    SimpleRegression make(IList dataValues) {
        if (dataValues.length() <= 2) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "SimpleRegression data should have more than 2 elements");
        }
        SimpleRegression simple = new SimpleRegression();
        for (IValue v : dataValues) {
            ITuple t2 = (ITuple)v;
            INumber x = (INumber)t2.get(0);
            INumber y = (INumber)t2.get(1);
            simple.addData(x.toReal(this.values.getPrecision()).doubleValue(), y.toReal(this.values.getPrecision()).doubleValue());
        }
        return simple;
    }

    public IValue intercept(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getIntercept());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue interceptStdErr(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getInterceptStdErr());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue meanSquareError(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getMeanSquareError());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue R(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getR());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue RSquare(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getRSquare());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue regressionSumSquares(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getRegressionSumSquares());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue significance(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getSignificance());
        }
        catch (MathException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, e.getMessage());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue slope(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getSlope());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue slopeConfidenceInterval(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getSlopeConfidenceInterval());
        }
        catch (MathException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, e.getMessage());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue slopeConfidenceInterval(IList dataValues, INumber alpha) {
        try {
            return this.values.real(this.make(dataValues).getSlopeConfidenceInterval(alpha.toReal(this.values.getPrecision()).doubleValue()));
        }
        catch (MathException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, e.getMessage());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue slopeStdErr(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getSlopeStdErr());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue sumOfCrossProducts(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getSumOfCrossProducts());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue sumSquaredErrors(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getSumSquaredErrors());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue totalSumSquares(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getTotalSumSquares());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue XSumSquares(IList dataValues) {
        try {
            return this.values.real(this.make(dataValues).getXSumSquares());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }

    public IValue predict(IList dataValues, INumber x) {
        try {
            return this.values.real(this.make(dataValues).predict(x.toReal(this.values.getPrecision()).doubleValue()));
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Not enough variation in x values");
        }
    }
}

