/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.lang.aterm;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.ATermReader;
import io.usethesource.vallang.io.ATermWriter;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeStore;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.types.TypeReifier;
import org.rascalmpl.uri.URIResolverRegistry;

public class IO {
    private final IValueFactory values;

    public IO(IValueFactory values) {
        this.values = values;
    }

    public IValue readTextATermFile(IValue type, ISourceLocation loc) {
        IValue iValue;
        block8: {
            TypeStore store = new TypeStore(new TypeStore[0]);
            Type start = new TypeReifier(this.values).valueToType((IConstructor)type, store);
            InputStream in = URIResolverRegistry.getInstance().getInputStream(loc);
            try {
                iValue = new ATermReader().read(this.values, store, start, in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
                }
            }
            in.close();
        }
        return iValue;
    }

    public IValue readATermFromFile(IString fileName) {
        IValue iValue;
        FileInputStream stream = new FileInputStream(fileName.getValue());
        try {
            iValue = new ATermReader().read(this.values, stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FactTypeUseException e) {
                throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
            }
        }
        stream.close();
        return iValue;
    }

    public void writeTextATermFile(ISourceLocation loc, IValue value) {
        try (OutputStream out = URIResolverRegistry.getInstance().getOutputStream(loc, false);){
            new ATermWriter().write(value, new OutputStreamWriter(out, "UTF8"));
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
        }
    }
}

