/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import com.google.gson.stream.JsonWriter;
import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.jline.reader.EndOfFileException;
import org.jline.terminal.Terminal;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.library.lang.json.internal.JsonValueWriter;
import org.rascalmpl.repl.BaseREPL;
import org.rascalmpl.repl.http.REPLContentServer;
import org.rascalmpl.repl.http.REPLContentServerManager;
import org.rascalmpl.repl.output.ICommandOutput;
import org.rascalmpl.repl.output.IErrorCommandOutput;
import org.rascalmpl.repl.output.INotebookOutput;
import org.rascalmpl.repl.output.IOutputPrinter;
import org.rascalmpl.repl.output.ISourceLocationCommandOutput;
import org.rascalmpl.repl.output.IWebContentOutput;
import org.rascalmpl.repl.output.impl.AsciiStringOutputPrinter;
import org.rascalmpl.repl.parametric.ILanguageProtocol;
import org.rascalmpl.repl.parametric.ParametricReplService;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.functions.IFunction;

public class TermREPL {
    private final IRascalValueFactory vf;
    private final IDEServices service;
    private final PrintWriter err;
    private ILanguageProtocol lang;

    public TermREPL(IRascalValueFactory vf, IDEServices service, PrintWriter _ignoredOut, PrintWriter err) {
        this.vf = vf;
        this.service = service;
        this.err = err;
    }

    private Path resolveHistoryFile(ISourceLocation historyFile) {
        try {
            ISourceLocation result = URIResolverRegistry.getInstance().logicalToPhysical(historyFile);
            if (result == null || !result.getScheme().equals("file")) {
                this.err.println("Cannot resolve history file to file on disk");
                return null;
            }
            return Path.of(result.getPath(), new String[0]);
        }
        catch (IOException e) {
            return null;
        }
    }

    public ITuple newREPL(IConstructor repl, IString title, IString welcome, IString prompt, IString quit, ISourceLocation history, IFunction handler, IFunction completor, IFunction stacktrace, IEvaluatorContext eval) {
        BaseREPL baseRepl;
        Terminal term = this.service.activeTerminal();
        if (term == null) {
            throw RuntimeExceptionFactory.io("No terminal found in IDE service, we cannot allocate a REPL");
        }
        this.lang = new TheREPL(this.vf, title, welcome, prompt, quit, history, handler, completor, stacktrace);
        try {
            baseRepl = new BaseREPL(new ParametricReplService(this.lang, this.service, this.resolveHistoryFile(history)), term);
        }
        catch (Throwable e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
        TypeFactory tf = TypeFactory.getInstance();
        IFunction run = this.vf.function(tf.functionType(tf.voidType(), tf.tupleEmpty(), tf.tupleEmpty()), (args, kwargs) -> {
            try {
                baseRepl.run();
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.io(e.getMessage());
            }
            return this.vf.tuple();
        });
        IFunction send = this.vf.function(tf.functionType(tf.voidType(), tf.tupleType(tf.stringType()), tf.tupleEmpty()), (args, kwargs) -> {
            baseRepl.queueCommand(((IString)args[0]).getValue());
            return this.vf.tuple();
        });
        return this.vf.tuple(run, send);
    }

    public static class TheREPL
    implements ILanguageProtocol {
        private final REPLContentServerManager contentManager = new REPLContentServerManager();
        private final TypeFactory tf = TypeFactory.getInstance();
        private PrintWriter stdout;
        private PrintWriter stderr;
        private Reader input;
        private final String currentPrompt;
        private String quit;
        private final AbstractFunction handler;
        private final AbstractFunction completor;
        private final IValueFactory vf;
        private final AbstractFunction stacktrace;

        public TheREPL(IValueFactory vf, IString title, IString welcome, IString prompt, IString quit, ISourceLocation history, IFunction handler, IFunction completor, IValue stacktrace) {
            this.vf = vf;
            this.handler = (AbstractFunction)handler;
            this.completor = (AbstractFunction)completor;
            this.stacktrace = (AbstractFunction)stacktrace;
            this.currentPrompt = prompt.getValue();
            this.quit = quit.getValue();
        }

        @Override
        public void initialize(Reader input, PrintWriter stdout, PrintWriter stderr, IDEServices services) {
            this.input = input;
            this.stdout = stdout;
            this.stderr = stdout;
        }

        @Override
        public void cancelRunningCommandRequested() {
            this.handler.getEval().interrupt();
        }

        @Override
        public String getPrompt() {
            return this.currentPrompt;
        }

        @Override
        public ICommandOutput handleInput(String line) throws InterruptedException {
            if (line.trim().equals(this.quit)) {
                throw new EndOfFileException();
            }
            try {
                this.handler.getEval().__setInterrupt(false);
                IConstructor content = (IConstructor)this.call(this.handler, new Type[]{this.tf.stringType()}, new IValue[]{this.vf.string(line)});
                if (content.has("id")) {
                    return this.handleInteractiveContent(content);
                }
                IConstructor response = (IConstructor)content.get("response");
                switch (response.getName()) {
                    case "response": {
                        return this.handlePlainTextResponse(response);
                    }
                    case "fileResponse": {
                        return this.handleFileResponse(response);
                    }
                    case "jsonResponse": {
                        return this.handleJSONResponse(response);
                    }
                }
                return this.errorResponse("Unexpected constructor: " + response.getName());
            }
            catch (IOException e) {
                return this.errorResponse(e.getMessage());
            }
            catch (Throwable e) {
                return this.errorResponse(e.getMessage());
            }
        }

        private ICommandOutput errorResponse(final String message) {
            return new IErrorCommandOutput(){

                @Override
                public ICommandOutput getError() {
                    return () -> new AsciiStringOutputPrinter(message);
                }

                @Override
                public IOutputPrinter asPlain() {
                    return new AsciiStringOutputPrinter(message);
                }
            };
        }

        private ICommandOutput handleInteractiveContent(IConstructor content) throws IOException, UnsupportedEncodingException {
            String id = ((IString)content.get("id")).getValue();
            Function<IValue, IValue> callback = this.liftProviderFunction(content.get("callback"));
            REPLContentServer server = this.contentManager.addServer(id, callback);
            return this.produceHTMLResponse(id, URIUtil.assumeCorrect("http", "localhost:" + server.getListeningPort(), ""));
        }

        private ICommandOutput produceHTMLResponse(final String id, final URI URL2) throws UnsupportedEncodingException {
            return new NotebookWebContentOutput(){

                @Override
                public IOutputPrinter asNotebook() {
                    return new IOutputPrinter(){

                        @Override
                        public void write(PrintWriter target, boolean unicodeSupported) {
                            target.println("<script>");
                            target.println("  var " + id + " = new Salix('" + id + "', '" + URL2 + "');");
                            target.println("  google.charts.load('current', {'packages':['corechart']});");
                            target.println("  google.charts.setOnLoadCallback(function () { ");
                            target.println("    registerCharts(" + id + ");");
                            target.println("    registerDagre(" + id + ");");
                            target.println("    registerTreeView(" + id + ");");
                            target.println("    " + id + ".start();");
                            target.println("  });");
                            target.println("<script>");
                            target.println("<div id = \"" + id + "\"> </div>");
                        }

                        @Override
                        public String mimeType() {
                            return "text/html";
                        }
                    };
                }

                @Override
                public IOutputPrinter asHtml() {
                    return new AsciiStringOutputPrinter("<iframe class=\"rascal-content-frame\" src=\"" + URL2 + "\"></iframe>", "text/html");
                }

                @Override
                public IOutputPrinter asPlain() {
                    return new AsciiStringOutputPrinter("Serving visual content at |" + URL2 + "|", "text/plain");
                }

                @Override
                public URI webUri() {
                    return URL2;
                }

                @Override
                public String webTitle() {
                    return id;
                }

                @Override
                public int webviewColumn() {
                    return 1;
                }
            };
        }

        private Function<IValue, IValue> liftProviderFunction(IValue callback) {
            IFunction func = (IFunction)callback;
            return t2 -> func.call((IValue)t2);
        }

        private ICommandOutput handleJSONResponse(IConstructor response) {
            final IValue data = response.get("val");
            IWithKeywordParameters<? extends IConstructor> kws = response.asWithKeywordParameters();
            IValue dtf = kws.getParameter("dateTimeFormat");
            IValue dai = kws.getParameter("dateTimeAsInt");
            IValue formatters = kws.getParameter("formatter");
            IValue ecn = kws.getParameter("explicitConstructorNames");
            IValue edt = kws.getParameter("explicitDataTypes");
            final JsonValueWriter writer = new JsonValueWriter().setCalendarFormat(dtf != null ? ((IString)dtf).getValue() : "yyyy-MM-dd'T'HH:mm:ss'Z'").setFormatters((IFunction)formatters).setDatesAsInt(dai != null ? ((IBool)dai).getValue() : true).setExplicitConstructorNames(ecn != null ? ((IBool)ecn).getValue() : false).setExplicitDataTypes(edt != null ? ((IBool)edt).getValue() : false);
            return new ICommandOutput(){

                @Override
                public IOutputPrinter asPlain() {
                    return new IOutputPrinter(){

                        @Override
                        public void write(PrintWriter target, boolean unicodeSupported) {
                            try (JsonWriter json = new JsonWriter(target);){
                                writer.write(json, data);
                            }
                            catch (IOException ex) {
                                target.println("Unexpected IO exception: " + ex);
                            }
                        }

                        @Override
                        public String mimeType() {
                            return "application/json";
                        }
                    };
                }
            };
        }

        private ICommandOutput handleFileResponse(IConstructor response) throws UnsupportedEncodingException {
            final IString fileMimetype = (IString)response.get("mimeType");
            final ISourceLocation file = (ISourceLocation)response.get("file");
            return new ISourceLocationCommandOutput(){

                @Override
                public ISourceLocation asLocation() {
                    return file;
                }

                @Override
                public String locationMimeType() {
                    return fileMimetype.getValue();
                }

                @Override
                public IOutputPrinter asPlain() {
                    return new AsciiStringOutputPrinter("Direct file returned, REPL doesn't support file results", "text/plain");
                }
            };
        }

        private ICommandOutput handlePlainTextResponse(IConstructor response) throws UnsupportedEncodingException {
            String content = ((IString)response.get("content")).getValue();
            String contentMimetype = ((IString)response.get("mimeType")).getValue();
            return () -> new AsciiStringOutputPrinter(content, contentMimetype);
        }

        @Override
        public boolean supportsCompletion() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IValue call(IFunction f, Type[] types, IValue[] args) {
            if (f instanceof AbstractFunction) {
                Evaluator eval;
                Evaluator evaluator = eval = (Evaluator)((AbstractFunction)f).getEval();
                synchronized (evaluator) {
                    Object t2;
                    try {
                        eval.overrideDefaultWriters(this.input, this.stdout, this.stderr);
                        t2 = f.call(args);
                        this.stdout.flush();
                        this.stderr.flush();
                        eval.revertToDefaultWriters();
                    }
                    catch (Throwable throwable) {
                        this.stdout.flush();
                        this.stderr.flush();
                        eval.revertToDefaultWriters();
                        throw throwable;
                    }
                    return t2;
                }
            }
            throw RuntimeExceptionFactory.illegalArgument((IValue)f, "term repl only works with interpreter for now");
        }

        @Override
        public Map<String, String> completeFragment(String line, String word) {
            IMap result = (IMap)this.call(this.completor, new Type[]{this.tf.stringType(), this.tf.stringType()}, new IValue[]{this.vf.string(line), this.vf.string(word)});
            HashMap<String, String> resultMap = new HashMap<String, String>();
            Iterator<Map.Entry<IValue, IValue>> it = result.entryIterator();
            while (it.hasNext()) {
                Map.Entry<IValue, IValue> c = it.next();
                resultMap.put(((IString)c.getKey()).getValue(), ((IString)c.getValue()).getValue());
            }
            return resultMap;
        }

        abstract class NotebookWebContentOutput
        implements INotebookOutput,
        IWebContentOutput {
            NotebookWebContentOutput() {
            }
        }
    }
}

