/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack;

import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.LiteralNode;
import org.rascalmpl.parser.gtd.stack.AbstractMatchableStackNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.StackNodeVisitor;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;

public final class CaseInsensitiveLiteralStackNode<P>
extends AbstractMatchableStackNode<P> {
    private final Object production;
    private final int[][] ciLiteral;
    private final AbstractNode result;

    public CaseInsensitiveLiteralStackNode(int id, int dot, Object production, int[] ciLiteral) {
        super(id, dot);
        this.production = production;
        this.ciLiteral = CaseInsensitiveLiteralStackNode.fill(ciLiteral);
        this.result = null;
    }

    public CaseInsensitiveLiteralStackNode(int id, int dot, P production, int[] ciLiteral, IEnterFilter[] enterFilters, ICompletionFilter[] completionFilters) {
        super(id, dot, enterFilters, completionFilters);
        this.production = production;
        this.ciLiteral = CaseInsensitiveLiteralStackNode.fill(ciLiteral);
        this.result = null;
    }

    private CaseInsensitiveLiteralStackNode(CaseInsensitiveLiteralStackNode<P> original, int startLocation) {
        super(original, startLocation);
        this.production = original.production;
        this.ciLiteral = original.ciLiteral;
        this.result = null;
    }

    private CaseInsensitiveLiteralStackNode(CaseInsensitiveLiteralStackNode<P> original, int startLocation, AbstractNode result) {
        super(original, startLocation);
        this.production = original.production;
        this.ciLiteral = original.ciLiteral;
        this.result = result;
    }

    private static int[][] fill(int[] ciLiteral) {
        int nrOfCharacters = ciLiteral.length;
        int[][] ciLiteralResult = new int[nrOfCharacters][];
        for (int i = nrOfCharacters - 1; i >= 0; --i) {
            int character = ciLiteral[i];
            ciLiteralResult[i] = Character.isLowerCase(character) ? new int[]{character, Character.toUpperCase(character)} : (Character.isUpperCase(character) ? new int[]{character, Character.toLowerCase(character)} : new int[]{character});
        }
        return ciLiteralResult;
    }

    @Override
    public boolean isEmptyLeafNode() {
        return false;
    }

    @Override
    public AbstractNode match(int[] input, int location) {
        int literalLength = this.ciLiteral.length;
        int[] resultLiteral = new int[literalLength];
        for (int i = literalLength - 1; i >= 0; --i) {
            int character;
            block3: {
                int[] ciLiteralPart = this.ciLiteral[i];
                for (int j = ciLiteralPart.length - 1; j >= 0; --j) {
                    character = ciLiteralPart[j];
                    if (character != input[location + i]) {
                        continue;
                    }
                    break block3;
                }
                return null;
            }
            resultLiteral[i] = character;
        }
        return new LiteralNode(this.production, resultLiteral);
    }

    @Override
    public AbstractStackNode<P> getCleanCopy(int startLocation) {
        return new CaseInsensitiveLiteralStackNode<P>(this, startLocation);
    }

    @Override
    public AbstractStackNode<P> getCleanCopyWithResult(int startLocation, AbstractNode result) {
        return new CaseInsensitiveLiteralStackNode<P>(this, startLocation, result);
    }

    @Override
    public int getLength() {
        return this.ciLiteral.length;
    }

    @Override
    public AbstractNode getResult() {
        return this.result;
    }

    public int[][] getLiteral() {
        return this.ciLiteral;
    }

    @Override
    public String toShortString() {
        int[] codePoints = new int[this.ciLiteral.length];
        for (int i = 0; i < this.ciLiteral.length; ++i) {
            codePoints[i] = this.ciLiteral[i][0];
        }
        return new String(codePoints, 0, codePoints.length);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.ciLiteral.length; ++i) {
            sb.append(this.ciLiteral[i][0]);
        }
        sb.append(this.getId());
        sb.append('(');
        sb.append(this.startLocation);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return this.production.hashCode();
    }

    @Override
    public boolean equals(Object peer) {
        return super.equals(peer);
    }

    @Override
    public boolean isEqual(AbstractStackNode<P> stackNode) {
        if (!(stackNode instanceof CaseInsensitiveLiteralStackNode)) {
            return false;
        }
        CaseInsensitiveLiteralStackNode otherNode = (CaseInsensitiveLiteralStackNode)stackNode;
        if (!this.production.equals(otherNode.production)) {
            return false;
        }
        return this.hasEqualFilters(stackNode);
    }

    @Override
    public <R> R accept(StackNodeVisitor<P, R> visitor) {
        return visitor.visit(this);
    }
}

