/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack.filter.follow;

import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;

public class CharFollowRestriction
implements ICompletionFilter {
    private final int[][] ranges;

    public CharFollowRestriction(int[][] ranges) {
        this.ranges = ranges;
    }

    @Override
    public boolean isFiltered(int[] input, int start, int end, PositionStore positionStore) {
        if (end >= input.length) {
            return false;
        }
        int next = input[end];
        for (int i = this.ranges.length - 1; i >= 0; --i) {
            int[] range = this.ranges[i];
            if (next < range[0] || next > range[1]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEqual(ICompletionFilter otherCompletionFilter) {
        if (!(otherCompletionFilter instanceof CharFollowRestriction)) {
            return false;
        }
        CharFollowRestriction otherCharFollowFilter = (CharFollowRestriction)otherCompletionFilter;
        int[][] otherRanges = otherCharFollowFilter.ranges;
        block0: for (int i = this.ranges.length - 1; i >= 0; --i) {
            int[] range = this.ranges[i];
            for (int j = otherRanges.length - 1; j >= 0; --j) {
                int[] otherRange = otherRanges[j];
                if (range[0] == otherRange[0] && range[1] == otherRange[1]) continue block0;
            }
            return false;
        }
        return true;
    }
}

