/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack.filter.follow;

import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;

public class StringFollowRestriction
implements ICompletionFilter {
    private final int[] string;

    public StringFollowRestriction(int[] string) {
        this.string = string;
    }

    @Override
    public boolean isFiltered(int[] input, int start, int end, PositionStore positionStore) {
        if (end + this.string.length - 1 >= input.length) {
            return false;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (input[end + i] == this.string[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(ICompletionFilter otherCompletionFilter) {
        if (!(otherCompletionFilter instanceof StringFollowRestriction)) {
            return false;
        }
        StringFollowRestriction otherStringFollowFilter = (StringFollowRestriction)otherCompletionFilter;
        int[] otherString = otherStringFollowFilter.string;
        if (this.string.length != otherString.length) {
            return false;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (this.string[i] == otherString[i]) continue;
            return false;
        }
        return true;
    }
}

