/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack.filter.precede;

import java.util.Arrays;
import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;
import org.rascalmpl.parser.gtd.stack.filter.precede.StringPrecedeRestriction;

public class CaseInsensitiveStringPrecedeRestriction
implements IEnterFilter {
    private final int[][] string;

    public CaseInsensitiveStringPrecedeRestriction(int[][] string) {
        this.string = string;
        assert (Arrays.stream(string).noneMatch(letter -> ((int[])letter).length != 2));
    }

    @Override
    public boolean isFiltered(int[] input, int start, PositionStore positionStore) {
        int startLocation = start - this.string.length;
        if (startLocation < 0) {
            return false;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (input[startLocation + i] == this.string[i][0] || input[startLocation + i] == this.string[i][1]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(IEnterFilter otherEnterFilter) {
        if (!(otherEnterFilter instanceof StringPrecedeRestriction)) {
            return false;
        }
        CaseInsensitiveStringPrecedeRestriction otherStringPrecedeFilter = (CaseInsensitiveStringPrecedeRestriction)otherEnterFilter;
        int[][] otherString = otherStringPrecedeFilter.string;
        if (this.string.length != otherString.length) {
            return false;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (this.string[i][0] == otherString[i][0] && this.string[i][1] == otherString[i][1]) continue;
            return false;
        }
        return true;
    }
}

