/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

public class SortedIntegerObjectList<V> {
    private static final int DEFAULT_SIZE = 8;
    private int[] keys = new int[8];
    private V[] values = new Object[8];
    private int size;

    public void enlarge() {
        int[] oldKeys = this.keys;
        this.keys = new int[this.size << 1];
        System.arraycopy(oldKeys, 0, this.keys, 0, this.size);
        V[] oldValues = this.values;
        this.values = new Object[this.size << 1];
        System.arraycopy(oldValues, 0, this.values, 0, this.size);
    }

    public void add(int key, V value) {
        while (this.size >= this.keys.length) {
            this.enlarge();
        }
        if (this.size == 0 || this.keys[this.size - 1] < key) {
            this.keys[this.size] = key;
            this.values[this.size++] = value;
            return;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.keys[i] >= key) continue;
            System.arraycopy(this.keys, i + 1, this.keys, i + 2, this.size - i - 1);
            System.arraycopy(this.values, i + 1, this.values, i + 2, this.size++ - i - 1);
            this.keys[i + 1] = key;
            this.values[i + 1] = value;
            return;
        }
        System.arraycopy(this.keys, 0, this.keys, 1, this.size);
        System.arraycopy(this.values, 0, this.values, 1, this.size++);
        this.keys[0] = key;
        this.values[0] = value;
    }

    public int getKey(int index) {
        return this.keys[index];
    }

    public V getValue(int index) {
        return this.values[index];
    }

    public int findKey(int key) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.keys[i] != key) continue;
            return i;
        }
        return -1;
    }

    public V findValue(int key) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.keys[i] != key) continue;
            return this.values[i];
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.keys.length;
    }

    public void clear() {
        int length = this.keys.length;
        this.keys = new int[length];
        this.values = new Object[length];
        this.size = 0;
    }

    public void dirtyClear() {
        this.size = 0;
    }
}

