/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.output.impl;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import org.rascalmpl.repl.output.IOutputPrinter;

public class AsciiStringOutputPrinter
implements IOutputPrinter {
    private final String body;
    private final String mimeType;

    public AsciiStringOutputPrinter(String body) {
        this(body, "text/plain");
    }

    public AsciiStringOutputPrinter(String body, String mimeType) {
        this.body = body;
        this.mimeType = mimeType;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public void write(PrintWriter target, boolean unicodeSupported) {
        target.println(this.body);
    }

    @Override
    public Reader asReader(boolean unicodeSupported) {
        return new StringReader(this.body + System.lineSeparator());
    }
}

