/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.rascal;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jline.terminal.Terminal;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.StackTrace;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.ideservices.BasicIDEServices;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.NullRascalMonitor;
import org.rascalmpl.interpreter.control_exceptions.InterruptException;
import org.rascalmpl.interpreter.control_exceptions.QuitException;
import org.rascalmpl.interpreter.env.GlobalEnvironment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.load.StandardLibraryContributor;
import org.rascalmpl.interpreter.staticErrors.StaticError;
import org.rascalmpl.interpreter.utils.ReadEvalPrintDialogMessages;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.repl.StopREPLException;
import org.rascalmpl.repl.output.ICommandOutput;
import org.rascalmpl.repl.rascal.IRascalLanguageProtocol;
import org.rascalmpl.repl.rascal.RascalValuePrinter;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;

public class RascalInterpreterREPL
implements IRascalLanguageProtocol {
    protected IDEServices services;
    protected Evaluator eval;
    private final RascalValuePrinter printer = new RascalValuePrinter(){

        @Override
        protected Function<IValue, IValue> liftProviderFunction(IFunction func) {
            return v -> {
                Objects.requireNonNull(RascalInterpreterREPL.this.eval, "Not initialized yet");
                Evaluator evaluator = RascalInterpreterREPL.this.eval;
                synchronized (evaluator) {
                    return func.call((IValue)v);
                }
            };
        }
    };
    private static final ISourceLocation PROMPT_LOCATION = URIUtil.rootLocation("prompt");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITree parseCommand(String command) {
        Objects.requireNonNull(this.eval, "Not initialized yet");
        Evaluator evaluator = this.eval;
        synchronized (evaluator) {
            return this.eval.parseCommand(new NullRascalMonitor(), command, PROMPT_LOCATION);
        }
    }

    @Override
    public ISourceLocation promptRootLocation() {
        return PROMPT_LOCATION;
    }

    protected IDEServices buildIDEService(PrintWriter err, IRascalMonitor monitor, Terminal term) {
        return new BasicIDEServices(err, monitor, term);
    }

    protected Evaluator buildEvaluator(Reader input, PrintWriter stdout, PrintWriter stderr, IDEServices services) {
        GlobalEnvironment heap = new GlobalEnvironment();
        ModuleEnvironment root = heap.addModule(new ModuleEnvironment("$shell$", heap));
        IValueFactory vf = ValueFactoryFactory.getValueFactory();
        Evaluator evaluator = new Evaluator(vf, input, stderr, stdout, root, heap, services);
        evaluator.addRascalSearchPathContributor(StandardLibraryContributor.getInstance());
        return evaluator;
    }

    @Override
    public IDEServices initialize(Reader input, PrintWriter stdout, PrintWriter stderr, IRascalMonitor monitor, Terminal term) {
        this.services = this.buildIDEService(stderr, monitor, term);
        if (this.eval != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.eval = this.buildEvaluator(input, stdout, stderr, this.services);
        return this.services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommandOutput handleInput(String command) throws InterruptedException, ParseError, StopREPLException {
        Objects.requireNonNull(this.eval, "Not initialized yet");
        Evaluator evaluator = this.eval;
        synchronized (evaluator) {
            try {
                return this.printer.outputResult(this.eval.eval(this.eval.getMonitor(), command, PROMPT_LOCATION));
            }
            catch (InterruptException ex) {
                return this.printer.outputError((w, sw, u) -> {
                    w.println((u ? "\u00bb\u00bb " : ">> ") + "Interrupted");
                    ex.getRascalStackTrace().prettyPrintedString(w, sw);
                });
            }
            catch (StaticError e) {
                return this.printer.outputError((w, sw, _u) -> ReadEvalPrintDialogMessages.staticErrorMessage(w, e, sw));
            }
            catch (Throw e) {
                return this.printer.outputError((w, sw, _u) -> ReadEvalPrintDialogMessages.throwMessage(w, e, sw));
            }
            catch (QuitException q) {
                throw new StopREPLException();
            }
            catch (Throwable e) {
                if (e instanceof ParseError) {
                    throw e;
                }
                return this.printer.outputError((w, sw, _u) -> ReadEvalPrintDialogMessages.throwableMessage(w, e, this.eval.getStackTrace(), sw));
            }
        }
    }

    @Override
    public void cancelRunningCommandRequested() {
        Objects.requireNonNull(this.eval, "Not initialized yet");
        this.eval.interrupt();
        this.eval.endAllJobs();
    }

    public void cleanEnvironment() {
        Objects.requireNonNull(this.eval, "Not initialized yet");
        this.eval.getCurrentModuleEnvironment().reset();
    }

    @Override
    public ICommandOutput stackTraceRequested() {
        Objects.requireNonNull(this.eval, "Not initialized yet");
        StackTrace trace = this.eval.getStackTrace();
        return this.printer.prettyPrinted((w, sw, u) -> {
            w.println("Current stack trace:");
            trace.prettyPrintedString(w, sw);
            w.flush();
        });
    }

    @Override
    public List<String> lookupModules(String modulePrefix) {
        Objects.requireNonNull(this.eval, "Not initialized yet");
        return this.eval.getRascalResolver().listModuleEntries(modulePrefix);
    }

    @Override
    public Map<String, String> completePartialIdentifier(String qualifier, String partial) {
        Objects.requireNonNull(this.eval, "Not initialized yet");
        return this.eval.completePartialIdentifier(qualifier, partial);
    }

    @Override
    public Map<String, String> availableCommandLineOptions() {
        HashMap<String, String> commandLineOptions = new HashMap<String, String>();
        commandLineOptions.put("rascal.generatorProfiling".substring("rascal.".length()), "enable sampling profiler for generator");
        commandLineOptions.put("rascal.profiling".substring("rascal.".length()), "enable sampling profiler");
        commandLineOptions.put("rascal.errors".substring("rascal.".length()), "print raw java errors");
        commandLineOptions.put("rascal.tracing".substring("rascal.".length()), "trace all function calls (warning: a lot of output will be generated)");
        return commandLineOptions;
    }

    @Override
    public void flush() {
        this.eval.getErrorPrinter().flush();
        this.eval.getOutPrinter().flush();
    }
}

