/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.rascal;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.io.StandardTextWriter;
import io.usethesource.vallang.type.Type;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Function;
import org.rascalmpl.interpreter.result.IRascalResult;
import org.rascalmpl.repl.http.REPLContentServer;
import org.rascalmpl.repl.http.REPLContentServerManager;
import org.rascalmpl.repl.output.IAnsiCommandOutput;
import org.rascalmpl.repl.output.ICommandOutput;
import org.rascalmpl.repl.output.IErrorCommandOutput;
import org.rascalmpl.repl.output.IHtmlCommandOutput;
import org.rascalmpl.repl.output.IOutputPrinter;
import org.rascalmpl.repl.output.IWebContentOutput;
import org.rascalmpl.repl.output.impl.AsciiStringOutputPrinter;
import org.rascalmpl.repl.streams.LimitedLineWriter;
import org.rascalmpl.repl.streams.LimitedWriter;
import org.rascalmpl.repl.streams.ReplTextWriter;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public abstract class RascalValuePrinter {
    private static final int LINE_LIMIT = 200;
    private static final int CHAR_LIMIT = 4000;
    private final REPLContentServerManager contentManager = new REPLContentServerManager();
    private static final StandardTextWriter ansiIndentedPrinter = new ReplTextWriter(true);
    private static final StandardTextWriter plainIndentedPrinter = new StandardTextWriter(true);

    protected abstract Function<IValue, IValue> liftProviderFunction(IFunction var1);

    public IErrorCommandOutput outputError(final ThrowingWriter writer) {
        return new IErrorCommandOutput(){

            @Override
            public ICommandOutput getError() {
                return RascalValuePrinter.this.prettyPrinted(writer);
            }

            @Override
            public IOutputPrinter asPlain() {
                return new PrettyPrintedOutput(writer, plainIndentedPrinter, "text/plain");
            }
        };
    }

    public ICommandOutput prettyPrinted(final ThrowingWriter writer) {
        return new IAnsiCommandOutput(){

            @Override
            public IOutputPrinter asAnsi() {
                return new PrettyPrintedOutput(writer, ansiIndentedPrinter, "text/x-ansi");
            }

            @Override
            public IOutputPrinter asPlain() {
                return new PrettyPrintedOutput(writer, plainIndentedPrinter, "text/plain");
            }
        };
    }

    public ICommandOutput outputResult(IRascalResult result) {
        if (result == null || result.getValue() == null) {
            return () -> new AsciiStringOutputPrinter("ok", "text/plain");
        }
        IValue value = result.getValue();
        Type type = result.getStaticType();
        if (type.isSubtypeOf(RascalValueFactory.Content) && !type.isBottom()) {
            return this.serveContent((IConstructor)value);
        }
        ThrowingWriter resultWriter = type.isAbstractData() && type.isStrictSubtypeOf(RascalValueFactory.Tree) && !type.isBottom() ? (w, sw, _u) -> {
            w.write("(" + type.toString() + ") `");
            TreeAdapter.yield((IConstructor)value, sw == ansiIndentedPrinter, w);
            w.write("`");
        } : (type.isString() ? (w, sw, u) -> {
            LimitedWriter wrt2;
            try {
                wrt2 = new LimitedWriter(new LimitedLineWriter(w, 200L), 4000L);
                try {
                    sw.write(value, wrt2);
                }
                finally {
                    ((Writer)wrt2).close();
                }
            }
            catch (RuntimeException wrt2) {
                // empty catch block
            }
            w.println();
            this.printShortLine(w, u);
            try {
                wrt2 = new LimitedWriter(new LimitedLineWriter(w, 200L), 4000L);
                try {
                    ((IString)value).write(wrt2);
                }
                finally {
                    ((Writer)wrt2).close();
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            w.println();
            this.printShortLine(w, u);
        } : (w, sw, _u) -> {
            try (LimitedWriter wrt = new LimitedWriter(new LimitedLineWriter(w, 200L), 4000L);){
                sw.write(value, wrt);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        });
        ThrowingWriter typePrefixed = (w, sw, u) -> {
            w.write(type.toString());
            w.write(": ");
            resultWriter.write(w, sw, u);
            w.println();
        };
        return this.prettyPrinted(typePrefixed);
    }

    private void printShortLine(PrintWriter writer, boolean unicodeSupported) {
        if (unicodeSupported) {
            writer.println("\u2500\u2500\u2500");
        } else {
            writer.println("---");
        }
    }

    private ICommandOutput serveContent(IConstructor provider) {
        Function<IValue, IValue> target;
        String id;
        if (provider.has("id")) {
            id = ((IString)provider.get("id")).getValue();
            target = this.liftProviderFunction((IFunction)provider.get("callback"));
        } else {
            id = "*static content*";
            target = r -> provider.get("response");
        }
        try {
            REPLContentServer server = this.contentManager.addServer(id, target);
            IWithKeywordParameters<? extends IConstructor> kp = provider.asWithKeywordParameters();
            String title = kp.hasParameter("title") ? ((IString)kp.getParameter("title")).getValue() : id;
            int viewColumn = kp.hasParameter("viewColumn") ? ((IInteger)kp.getParameter("viewColumn")).intValue() : 1;
            URI serverUri = new URI("http", null, "localhost", server.getListeningPort(), "/", null, null);
            return new HostedWebContentOutput(id, serverUri, title, viewColumn);
        }
        catch (IOException e) {
            return this.outputError((w, sw, _u) -> {
                w.println("Could not start webserver to render html content: ");
                w.println(e.getMessage());
            });
        }
        catch (URISyntaxException e) {
            return this.outputError((w, sw, _u) -> {
                w.println("Could not start build the uri: ");
                w.println(e.getMessage());
            });
        }
    }

    private static class PrettyPrintedOutput
    implements IOutputPrinter {
        private final ThrowingWriter internalWriter;
        private final StandardTextWriter prettyPrinter;
        private final String mimeType;

        public PrettyPrintedOutput(ThrowingWriter internalWriter, StandardTextWriter prettyPrinter, String mimeType) {
            this.internalWriter = internalWriter;
            this.prettyPrinter = prettyPrinter;
            this.mimeType = mimeType;
        }

        @Override
        public String mimeType() {
            return this.mimeType;
        }

        @Override
        public void write(PrintWriter target, boolean unicodeSupported) {
            try {
                this.internalWriter.write(target, this.prettyPrinter, unicodeSupported);
            }
            catch (IOException e) {
                target.println("Internal failure: printing exception failed with:");
                target.println(e.toString());
                e.printStackTrace(target);
            }
        }
    }

    private static class HostedWebContentOutput
    implements IWebContentOutput,
    IHtmlCommandOutput {
        private final String id;
        private final URI uri;
        private final String title;
        private final int viewColumn;

        HostedWebContentOutput(String id, URI uri, String title, int viewColumn) {
            this.id = id;
            this.uri = uri;
            this.title = title;
            this.viewColumn = viewColumn;
        }

        @Override
        public IOutputPrinter asPlain() {
            return new IOutputPrinter(){

                @Override
                public void write(PrintWriter target, boolean unicodeSupported) {
                    if (unicodeSupported) {
                        target.print("\ud83d\udd17 ");
                    }
                    target.print("Serving '");
                    target.print(id);
                    target.print("' at |");
                    target.print(uri.toASCIIString());
                    target.println("|");
                }

                @Override
                public String mimeType() {
                    return "text/plain";
                }
            };
        }

        @Override
        public IOutputPrinter asHtml() {
            return new IOutputPrinter(){

                @Override
                public void write(PrintWriter target, boolean unicodeSupported) {
                    target.print("<iframe class=\"rascal-content-frame\"");
                    target.print(" style=\"display: block; width: 100%; height: 100%; resize: both\"");
                    target.print(" src=\"");
                    target.print(uri);
                    target.println("\"></iframe>");
                }

                @Override
                public String mimeType() {
                    return "text/html";
                }
            };
        }

        @Override
        public URI webUri() {
            return this.uri;
        }

        @Override
        public String webTitle() {
            return this.title;
        }

        @Override
        public int webviewColumn() {
            return this.viewColumn;
        }
    }

    @FunctionalInterface
    public static interface ThrowingWriter {
        public void write(PrintWriter var1, StandardTextWriter var2, boolean var3) throws IOException;
    }
}

