/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.streams;

import java.io.IOException;
import java.io.Writer;
import org.rascalmpl.interpreter.utils.LimitedResultWriter;
import org.rascalmpl.repl.streams.NonClosingFilterWriter;

public class LimitedWriter
extends NonClosingFilterWriter {
    private static final long FULL_WRITE_GRACE = 128L;
    private final long limit;
    private long written;

    public LimitedWriter(Writer out, long limit) {
        super(out);
        this.limit = limit;
        this.written = 0L;
    }

    @Override
    public void write(int c) throws IOException {
        this.checkAvailableSpace(1);
        this.out.write(c);
        this.updateWrittenChars(1);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        len = this.checkAvailableSpace(len);
        this.out.write(cbuf, off, len);
        this.updateWrittenChars(len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        len = this.checkAvailableSpace(len);
        this.out.write(str, off, len);
        this.updateWrittenChars(len);
    }

    private void updateWrittenChars(int len) throws IOException {
        this.written += (long)len;
        if (this.written >= this.limit) {
            this.out.write("...");
            this.out.flush();
        }
    }

    private int checkAvailableSpace(int len) {
        if (this.written >= this.limit) {
            throw new LimitedResultWriter.IOLimitReachedException();
        }
        if (this.written + (long)len >= this.limit + 128L) {
            return (int)(this.limit + 128L - this.written);
        }
        return len;
    }
}

