/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.runtime.utils;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.type.DefaultTypeVisitor;
import io.usethesource.vallang.type.Type;
import org.rascalmpl.runtime.ATypeFactory;
import org.rascalmpl.runtime.InternalCompilerError;

public class Type2ATypeReifier
extends ATypeFactory {
    protected IString empty;

    public Type2ATypeReifier() {
        this.empty = this.$VF.string("");
    }

    public IConstructor reify2atype(final Type t2, final IString label) {
        return t2.accept(new DefaultTypeVisitor<IConstructor, RuntimeException>(null){

            @Override
            public IConstructor visitVoid(Type type) throws RuntimeException {
                return label.length() == 0 ? Type2ATypeReifier.this.$avoid() : Type2ATypeReifier.this.$avoid(label);
            }

            @Override
            public IConstructor visitBool(Type type) throws RuntimeException {
                return label.length() == 0 ? Type2ATypeReifier.this.$abool() : Type2ATypeReifier.this.$abool(label);
            }

            @Override
            public IConstructor visitInteger(Type type) throws RuntimeException {
                return label.length() == 0 ? Type2ATypeReifier.this.$aint() : Type2ATypeReifier.this.$aint(label);
            }

            @Override
            public IConstructor visitReal(Type type) throws RuntimeException {
                return label.length() == 0 ? Type2ATypeReifier.this.$areal() : Type2ATypeReifier.this.$areal(label);
            }

            @Override
            public IConstructor visitRational(Type type) throws RuntimeException {
                return label.length() == 0 ? Type2ATypeReifier.this.$arat() : Type2ATypeReifier.this.$arat(label);
            }

            @Override
            public IConstructor visitNumber(Type type) throws RuntimeException {
                return label.length() == 0 ? Type2ATypeReifier.this.$anum() : Type2ATypeReifier.this.$anum(label);
            }

            @Override
            public IConstructor visitString(Type type) throws RuntimeException {
                return label.length() == 0 ? Type2ATypeReifier.this.$astr() : Type2ATypeReifier.this.$astr(label);
            }

            @Override
            public IConstructor visitSourceLocation(Type type) throws RuntimeException {
                return label.length() == 0 ? Type2ATypeReifier.this.$aloc() : Type2ATypeReifier.this.$aloc(label);
            }

            @Override
            public IConstructor visitDateTime(Type type) throws RuntimeException {
                return label.length() == 0 ? Type2ATypeReifier.this.$adatetime() : Type2ATypeReifier.this.$adatetime(label);
            }

            @Override
            public IConstructor visitList(Type type) throws RuntimeException {
                IConstructor elmType = Type2ATypeReifier.this.reify2atype(type.getElementType(), Type2ATypeReifier.this.empty);
                return label.length() == 0 ? Type2ATypeReifier.this.$alist(elmType) : Type2ATypeReifier.this.$alist(elmType, label);
            }

            @Override
            public IConstructor visitSet(Type type) throws RuntimeException {
                IConstructor elmType = Type2ATypeReifier.this.reify2atype(type.getElementType(), Type2ATypeReifier.this.empty);
                return label.length() == 0 ? Type2ATypeReifier.this.$aset(elmType) : Type2ATypeReifier.this.$aset(elmType, label);
            }

            @Override
            public IConstructor visitTuple(Type type) throws RuntimeException {
                Type fieldTypes = type.getFieldTypes();
                String[] fieldNames = type.hasFieldNames() ? type.getFieldNames() : null;
                int arity = type.getArity();
                IConstructor[] fieldATypes = new IConstructor[arity];
                for (int i = 0; i < arity; ++i) {
                    fieldATypes[i] = Type2ATypeReifier.this.reify2atype(fieldTypes.getFieldType(i), fieldNames == null ? Type2ATypeReifier.this.empty : Type2ATypeReifier.this.$VF.string(fieldNames[i]));
                }
                return label.length() == 0 ? Type2ATypeReifier.this.$atuple(fieldATypes) : Type2ATypeReifier.this.$atuple(fieldATypes, label);
            }

            @Override
            public IConstructor visitMap(Type type) throws RuntimeException {
                boolean hasNames = type.hasFieldNames();
                String keyLabel = hasNames ? type.getKeyLabel() : "";
                IConstructor keyType = Type2ATypeReifier.this.reify2atype(type.getKeyType(), keyLabel.isEmpty() ? Type2ATypeReifier.this.empty : Type2ATypeReifier.this.$VF.string(keyLabel));
                String valLabel = hasNames ? type.getValueLabel() : "";
                IConstructor valType = Type2ATypeReifier.this.reify2atype(type.getValueType(), valLabel.isEmpty() ? Type2ATypeReifier.this.empty : Type2ATypeReifier.this.$VF.string(valLabel));
                return label.length() == 0 ? Type2ATypeReifier.this.$amap(keyType, valType) : Type2ATypeReifier.this.$amap(keyType, valType, label);
            }

            @Override
            public IConstructor visitParameter(Type type) throws RuntimeException {
                String pname = type.getName();
                IConstructor boundType = Type2ATypeReifier.this.reify2atype(type.getBound(), Type2ATypeReifier.this.empty);
                return Type2ATypeReifier.this.$aparameter(Type2ATypeReifier.this.$VF.string(pname), boundType);
            }

            @Override
            public IConstructor visitNode(Type type) throws RuntimeException {
                return label.length() == 0 ? Type2ATypeReifier.this.$anode() : Type2ATypeReifier.this.$anode(label);
            }

            @Override
            public IConstructor visitAbstractData(Type type) throws RuntimeException {
                String adtName = t2.getName();
                Type parameters = t2.getTypeParameters();
                int arity = parameters.getArity();
                IListWriter w = Type2ATypeReifier.this.$VF.listWriter();
                for (int i = 0; i < arity; ++i) {
                    w.append(Type2ATypeReifier.this.reify2atype(parameters.getFieldType(i), Type2ATypeReifier.this.empty));
                }
                return label.length() == 0 ? Type2ATypeReifier.this.$aadt(Type2ATypeReifier.this.$VF.string(adtName), (IList)w.done(), Type2ATypeReifier.this.dataSyntax) : Type2ATypeReifier.this.$aadt(Type2ATypeReifier.this.$VF.string(adtName), (IList)w.done(), Type2ATypeReifier.this.dataSyntax, label);
            }

            @Override
            public IConstructor visitConstructor(Type type) throws RuntimeException {
                String consName = t2.getName();
                Type adt = t2.getAbstractDataType();
                Type fields = type.getFieldTypes();
                int arity = fields.getArity();
                IListWriter w = Type2ATypeReifier.this.$VF.listWriter();
                for (int i = 0; i < arity; ++i) {
                    w.append(Type2ATypeReifier.this.reify2atype(fields.getFieldType(i), Type2ATypeReifier.this.empty));
                }
                return Type2ATypeReifier.this.$acons(Type2ATypeReifier.this.reify2atype(adt, Type2ATypeReifier.this.empty), (IList)w.done(), (IList)Type2ATypeReifier.this.$VF.listWriter().done(), Type2ATypeReifier.this.$VF.string(consName));
            }

            @Override
            public IConstructor visitValue(Type type) throws RuntimeException {
                return Type2ATypeReifier.this.$avalue();
            }

            @Override
            public IConstructor visitAlias(Type type) throws RuntimeException {
                throw new InternalCompilerError("Alias not implemented: " + type);
            }

            @Override
            public IConstructor visitExternal(Type type) throws RuntimeException {
                throw new InternalCompilerError("External not implemented: " + type);
            }
        });
    }

    public static void main(String[] args) {
        Type2ATypeReifier reifier = new Type2ATypeReifier();
        IInteger one = reifier.$VF.integer(1);
        IInteger two = reifier.$VF.integer(2);
        System.err.println(reifier.reify2atype(one.getType(), reifier.empty));
        System.err.println(reifier.reify2atype(one.getType(), reifier.$VF.string("intLabel")));
        System.err.println(reifier.reify2atype(reifier.$VF.set(one).getType(), reifier.empty));
        System.err.println(reifier.reify2atype(reifier.$VF.set(one).getType(), reifier.$VF.string("set Label")));
        System.err.println(reifier.reify2atype(reifier.$VF.tuple(one, two).getType(), reifier.empty));
        System.err.println(reifier.reify2atype(reifier.$TF.tupleType(reifier.$TF.integerType(), "abc"), reifier.empty));
        System.err.println(reifier.reify2atype(reifier.$VF.list(reifier.$VF.tuple(one, two)).getType(), reifier.empty));
        Type D = reifier.$TF.abstractDataType(reifier.$TS, "D", new Type[0]);
        Type D_d = reifier.$TF.constructor(reifier.$TS, D, "d", new Type[0]);
        System.err.println(reifier.reify2atype(D, reifier.empty));
        System.err.println(reifier.reify2atype(D_d, reifier.empty));
    }
}

