/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import java.net.URI;
import java.net.URISyntaxException;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.LocationLiteral;
import org.rascalmpl.ast.PathPart;
import org.rascalmpl.ast.ProtocolPart;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.uri.URIUtil;

public abstract class LocationLiteral
extends org.rascalmpl.ast.LocationLiteral {
    public LocationLiteral(ISourceLocation __param1, IConstructor tree) {
        super(__param1, tree);
    }

    public static class Default
    extends LocationLiteral.Default {
        public Default(ISourceLocation __param1, IConstructor tree, ProtocolPart __param2, PathPart __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            Result<IValue> protocolPart = this.getProtocolPart().interpret(__eval);
            Result<IValue> pathPart = this.getPathPart().interpret(__eval);
            String uri = ((IString)protocolPart.getValue()).getValue() + "://" + ((IString)pathPart.getValue()).getValue();
            try {
                URI url = URIUtil.createFromEncoded(uri);
                ISourceLocation r = __eval.__getVf().sourceLocation(url);
                return ResultFactory.makeResult(Evaluator.__getTf().sourceLocationType(), r, __eval);
            }
            catch (URISyntaxException e) {
                throw RuntimeExceptionFactory.malformedURI(uri, (AbstractAST)this, __eval.getStackTrace());
            }
            catch (UnsupportedOperationException e) {
                throw RuntimeExceptionFactory.malformedURI(uri + ":" + e.getMessage(), (AbstractAST)this, __eval.getStackTrace());
            }
        }
    }
}

