/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.shell;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.shell.Option;
import org.rascalmpl.shell.OptionBuilder;
import org.rascalmpl.shell.OptionType;
import org.rascalmpl.shell.Options;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;

public class CommandOptions {
    private static final String IGNORES_PATH_CONFIG_OPTION = "ignores";
    private static final String BIN_PATH_CONFIG_OPTION = "bin";
    private static final String LIB_PATH_CONFIG_OPTION = "lib";
    private static final String GENERATED_SOURCES_PATH_CONFIG_OPTION = "generated-sources";
    private static final String PROJECT_PATH_CONFIG_OPTION = "project";
    private static final String SRC_PATH_CONFIG_OPTION = "src";
    protected TypeFactory tf;
    protected IValueFactory vf;
    private boolean inCommandOptions = true;
    private boolean singleModule = true;
    private IList modules;
    private int minModules = 0;
    private int maxModules = 0;
    private String moduleHelp;
    protected Options commandOptions;
    private Options moduleOptions;
    private String commandName;

    public CommandOptions(String commandName) {
        this.commandName = commandName;
        this.tf = TypeFactory.getInstance();
        this.vf = ValueFactoryFactory.getValueFactory();
        this.commandOptions = new Options();
        this.moduleOptions = new Options();
        this.modules = this.vf.list(new IValue[0]);
        this.moduleHelp = "Rascal Module";
    }

    public CommandOptions addOption(Option option) {
        (this.inCommandOptions ? this.commandOptions : this.moduleOptions).add(option);
        return this;
    }

    public OptionBuilder boolOption(String name) {
        return new OptionBuilder(this, OptionType.BOOL, name);
    }

    public boolean getCommandBoolOption(String name) {
        return ((IBool)this.commandOptions.get(OptionType.BOOL, name)).getValue();
    }

    public boolean getModuleBoolOption(String name) {
        return ((IBool)this.moduleOptions.get(OptionType.BOOL, name)).getValue();
    }

    public OptionBuilder strOption(String name) {
        return new OptionBuilder(this, OptionType.STR, name);
    }

    public String getCommandStringOption(String name) {
        return ((IString)this.commandOptions.get(OptionType.STR, name)).getValue();
    }

    public String getModuleStringOption(String name) {
        return ((IString)this.moduleOptions.get(OptionType.STR, name)).getValue();
    }

    public OptionBuilder locOption(String name) {
        return new OptionBuilder(this, OptionType.LOC, name);
    }

    public ISourceLocation getCommandLocOption(String name) {
        return (ISourceLocation)this.commandOptions.get(OptionType.LOC, name);
    }

    public ISourceLocation getModuleLocOption(String name) {
        return (ISourceLocation)this.moduleOptions.get(OptionType.LOC, name);
    }

    public OptionBuilder locsOption(String name) {
        return new OptionBuilder(this, OptionType.LOCS, name);
    }

    public IList getCommandLocsOption(String name) {
        return (IList)this.commandOptions.get(OptionType.LOCS, name);
    }

    public IList getModuleLocsOption(String name) {
        return (IList)this.moduleOptions.get(OptionType.LOCS, name);
    }

    public CommandOptions module(String helpText) {
        return this.modules(helpText, 1, 1);
    }

    public IString getModule() {
        return (IString)this.modules.get(0);
    }

    public CommandOptions modules(String helpText) {
        return this.modules(helpText, 1, 1000000);
    }

    public CommandOptions modules(String helpText, int min2) {
        return this.modules(helpText, min2, 1000000);
    }

    public CommandOptions modules(String helpText, int min2, int max) {
        this.minModules = min2;
        this.maxModules = max;
        this.inCommandOptions = false;
        this.moduleHelp = helpText;
        return this;
    }

    public IList getModules() {
        return this.modules;
    }

    private String getOptionValue(String[] args, int i) {
        if (i >= args.length - 1 || args[i + 1].startsWith("--")) {
            this.printUsageAndExit("Missing value for option " + args[i]);
            return "";
        }
        return args[i + 1];
    }

    public void handleArgs(String[] args) {
        this.vf = ValueFactoryFactory.getValueFactory();
        boolean mainSeen = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("--")) {
                Options currentOptions;
                String option = args[i].substring(2, args[i].length());
                Options options = currentOptions = !mainSeen ? this.commandOptions : this.moduleOptions;
                if (currentOptions.contains(OptionType.BOOL, option)) {
                    currentOptions.set(OptionType.BOOL, option, this.vf.bool(true));
                    ++i;
                    continue;
                }
                if (currentOptions.contains(OptionType.STR, option)) {
                    currentOptions.set(OptionType.STR, option, this.vf.string(this.getOptionValue(args, i)));
                } else if (currentOptions.contains(OptionType.LOCS, option)) {
                    ISourceLocation newLoc = this.convertLoc(this.getOptionValue(args, i));
                    currentOptions.update(OptionType.LOCS, option, current -> current == null ? this.vf.list(newLoc) : ((IList)current).append(newLoc));
                } else if (currentOptions.contains(OptionType.LOC, option)) {
                    currentOptions.set(OptionType.LOC, option, this.convertLoc(this.getOptionValue(args, i)));
                } else {
                    this.printUsageAndExit("Unknown command option " + args[i]);
                    return;
                }
                i += 2;
                continue;
            }
            this.modules = this.modules.append(this.vf.string(args[i]));
            mainSeen = true;
            ++i;
        }
        String ndHelp = this.noDefaultsHelpText();
        if (this.commandOptions.contains(OptionType.BOOL, "noDefaults")) {
            if (!ndHelp.isEmpty()) {
                for (Option option : this.commandOptions) {
                    if (!option.name.equals("noDefaults")) continue;
                    option.helpText = ndHelp;
                }
            }
        } else if (!ndHelp.isEmpty()) {
            this.commandOptions.add(new Option(OptionType.BOOL, "noDefaults", this.vf.bool(false), null, false, ndHelp));
        }
        if (this.commandOptions.hasNonDefaultValue(OptionType.BOOL, "help")) {
            this.help();
            System.exit(0);
        }
        this.checkDefaults();
        if (this.modules.length() == 0 && this.minModules > 0) {
            this.printUsageAndExit("Missing Rascal module" + (this.singleModule ? "" : "s"));
        } else if (this.modules.length() > 0 && this.maxModules == 0) {
            this.printUsageAndExit("No modules expected");
        } else if (this.modules.length() > this.maxModules) {
            this.printUsageAndExit("Too many modules defined: " + this.modules);
        }
    }

    private void checkDefaults() {
        for (Option option : this.commandOptions) {
            option.checkDefault(this);
        }
        for (Option option : this.moduleOptions) {
            option.checkDefault(this);
        }
    }

    private void printUsageAndExit(String msg) {
        System.err.println(this.usage(msg));
        System.exit(-1);
    }

    private String usage(String msg) {
        StringBuffer w = new StringBuffer();
        if (!msg.isEmpty()) {
            w.append(msg).append("\n");
        }
        String prefix = "Usage: " + this.commandName;
        String indent = new String(new char[prefix.length()]).replace('\u0000', ' ');
        w.append(prefix);
        int nopt = 0;
        for (Option option : this.commandOptions) {
            if (++nopt == 10) {
                nopt = 0;
                w.append("\n").append(indent);
            }
            w.append(option.help());
        }
        w.append("\n").append(indent).append(this.singleModule ? " <RascalModule>" : " <RascalModules>");
        nopt = 0;
        for (Option option : this.moduleOptions) {
            if (++nopt == 10) {
                nopt = 0;
                w.append("\n").append(indent);
            }
            w.append(option.help());
        }
        return w.toString();
    }

    private String noDefaultsHelpText() {
        List<String> respectNoDefaults = this.commandOptions.getAllRespectNoDefaults();
        respectNoDefaults.addAll(this.moduleOptions.getAllRespectNoDefaults());
        if (respectNoDefaults.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Forbid use of default values for");
        String sep = " ";
        for (String name : respectNoDefaults) {
            sb.append(sep).append(name);
            sep = ", ";
        }
        return sb.toString();
    }

    private void help() {
        System.err.println(this.usage(""));
        System.err.println();
        for (Option option : this.commandOptions) {
            System.err.printf("%20s  %s\n", option.help(), option.helpText);
        }
        System.err.printf("%20s  %s\n", this.singleModule ? " <RascalModule>" : " <RascalModules>", this.moduleHelp);
        for (Option option : this.moduleOptions) {
            System.err.printf("%20s  %s\n", option.help(), option.helpText);
        }
        System.exit(-1);
    }

    public Map<String, IValue> getModuleOptions() {
        HashMap<String, IValue> mainOptionsMap = new HashMap<String, IValue>();
        for (Option option : this.moduleOptions) {
            mainOptionsMap.put(option.name, option.currentValue);
        }
        return mainOptionsMap;
    }

    public Map<String, IValue> getModuleOptionsAsMap() {
        HashMap<String, IValue> result = new HashMap<String, IValue>();
        for (Option option : this.moduleOptions) {
            result.put(option.name, option.currentValue);
        }
        return result;
    }

    ISourceLocation convertLoc(String loc) {
        if (loc.startsWith("|") && loc.endsWith("|")) {
            TypeStore store = new TypeStore(RascalValueFactory.getStore());
            Type start = TypeFactory.getInstance().sourceLocationType();
            StringReader in = new StringReader(loc);
            try {
                ISourceLocation iSourceLocation = (ISourceLocation)new StandardTextReader().read(this.vf, store, start, in);
                in.close();
                return iSourceLocation;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FactTypeUseException | IOException e) {
                    this.printUsageAndExit(e.getMessage());
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            File file = new File(loc);
            if (file.isAbsolute()) {
                return URIUtil.createFileLocation(file.getAbsolutePath());
            }
            return URIUtil.correctLocation("cwd", "", loc);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public ISourceLocation getDefaultStdLocation() {
        try {
            return this.vf.sourceLocation("std", "", "");
        }
        catch (URISyntaxException e) {
            this.printUsageAndExit("Cannot create default location: " + e.getMessage());
            return null;
        }
    }

    public IList getDefaultStdlocs() {
        return this.vf.list(this.getDefaultStdLocation());
    }

    public IList getDefaultIgnores() {
        return PathConfig.getDefaultIgnoresList();
    }

    public ISourceLocation getDefaultRelocLocation() {
        return URIUtil.correctLocation("noreloc", "", "");
    }

    public ISourceLocation getDefaultProjectLocation() {
        return URIUtil.correctLocation("noproject", "", "");
    }

    public PathConfig getPathConfig(PathConfig.RascalConfigMode mode) throws IOException {
        ISourceLocation project = this.getCommandLocOption(PROJECT_PATH_CONFIG_OPTION);
        if (!project.equals(this.getDefaultProjectLocation())) {
            return PathConfig.fromSourceProjectRascalManifest(project, mode, true);
        }
        return new PathConfig(this.getCommandLocsOption(SRC_PATH_CONFIG_OPTION), this.getCommandLocsOption(LIB_PATH_CONFIG_OPTION), this.getCommandLocOption(BIN_PATH_CONFIG_OPTION), this.getCommandLocsOption(IGNORES_PATH_CONFIG_OPTION));
    }

    public CommandOptions noModuleArgument() {
        return this;
    }

    public CommandOptions pathConfigOptions() {
        this.locOption(PROJECT_PATH_CONFIG_OPTION).locDefault(this.getDefaultProjectLocation()).help("Top level location where a project is located with its META-INF/RASCAL.MF file").locsOption(SRC_PATH_CONFIG_OPTION).locsDefault(this.getDefaultStdlocs().isEmpty() ? this.vf.list(this.getDefaultStdlocs()) : this.getDefaultStdlocs()).help("Add (absolute!) source location, use multiple --src arguments for multiple locations").locOption(BIN_PATH_CONFIG_OPTION).locDefault(v -> {
            System.err.println("WARNING: using cwd:///rascal-bin as default bin target folder for Rascal compiler.");
            return URIUtil.correctLocation("cwd", "", "rascal-bin");
        }).help("Directory for Rascal binaries").locsOption(LIB_PATH_CONFIG_OPTION).locsDefault(co -> this.vf.list(co.getCommandLocOption(BIN_PATH_CONFIG_OPTION))).help("Add new lib location, use multiple --lib arguments for multiple locations").locsOption(IGNORES_PATH_CONFIG_OPTION).locsDefault(PathConfig.getDefaultIgnoresList()).help("Add new ignored locations, use multiple --ignores arguments for multiple locations").locOption(GENERATED_SOURCES_PATH_CONFIG_OPTION).locDefault(PathConfig.getDefaultGeneratedSources()).help("Add new target location for generated sources");
        return this;
    }
}

