/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.shell;

import io.usethesource.vallang.IValue;
import java.util.function.Function;
import org.rascalmpl.shell.CommandOptions;
import org.rascalmpl.shell.OptionType;

class Option {
    final OptionType optionType;
    final String name;
    IValue initialValue;
    IValue currentValue;
    final Object defaultValue;
    final boolean respectsNoDefaults;
    String helpText;

    Option(OptionType optionType, String name, IValue initialValue, Object defaultValue, boolean respectsNoDefaults, String helpText) {
        this.optionType = optionType;
        this.name = name;
        this.initialValue = initialValue;
        this.currentValue = initialValue;
        this.defaultValue = defaultValue;
        this.respectsNoDefaults = respectsNoDefaults;
        this.helpText = helpText;
    }

    public String toString() {
        return this.name + ":" + this.currentValue != null ? this.currentValue.toString() : this.defaultValue.toString();
    }

    public boolean set(OptionType optionType, String name, IValue newValue) {
        if (this.optionType == optionType && this.name.equals(name) && this.currentValue == this.initialValue) {
            this.currentValue = newValue;
            return true;
        }
        return false;
    }

    public boolean update(OptionType optionType, String name, Function<IValue, IValue> updater) {
        if (this.optionType == optionType && this.name.equals(name)) {
            if (this.currentValue == null) {
                this.currentValue = this.initialValue;
            }
            this.currentValue = updater.apply(this.currentValue);
            return true;
        }
        return false;
    }

    public boolean provides(OptionType optionType, String name) {
        return this.optionType == optionType && this.name.equals(name);
    }

    public IValue get(OptionType optionType, String name) {
        if (this.optionType.equals((Object)optionType) && this.name.equals(name)) {
            if (this.currentValue != null) {
                return this.currentValue;
            }
            throw new RuntimeException("Option " + name + " has undefined value");
        }
        return null;
    }

    public boolean checkDefault(CommandOptions commandOptions) {
        boolean noDefaults;
        boolean bl = noDefaults = commandOptions.commandOptions.contains(OptionType.BOOL, "noDefaults") && commandOptions.getCommandBoolOption("noDefaults");
        if (this.currentValue == this.initialValue) {
            if (noDefaults && this.respectsNoDefaults) {
                throw new RuntimeException("Option " + this.name + " requires a value");
            }
            if (this.defaultValue != null) {
                this.currentValue = this.defaultValue instanceof Function ? (IValue)((Function)this.defaultValue).apply(commandOptions) : (IValue)this.defaultValue;
            }
        }
        if (this.currentValue == null) {
            throw new RuntimeException("Option " + this.name + " requires a value");
        }
        return true;
    }

    String help() {
        String res = "--" + this.name;
        switch (this.optionType) {
            case INT: {
                res = res + " <int>";
                break;
            }
            case STR: {
                res = res + " <str>";
                break;
            }
            case LOC: {
                res = res + " <loc>";
                break;
            }
            case LOCS: {
                res = res + " <locs>";
                break;
            }
        }
        return this.defaultValue == null ? " " + res : " [" + res + "]";
    }
}

