/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.tasks;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.tasks.ClassTriple;
import org.rascalmpl.tasks.DepFactPolicy;
import org.rascalmpl.tasks.ITask;
import org.rascalmpl.tasks.ITaskRegistry;
import org.rascalmpl.tasks.ITransaction;
import org.rascalmpl.tasks.RefFactPolicy;

public class TaskRegistry<K, N, V>
implements ITaskRegistry<K, N, V> {
    private static final Map<ClassTriple, TaskRegistry<?, ?, ?>> schedulers = new HashMap();
    protected Map<K, ITask<K, N, V>> producers = new HashMap<K, ITask<K, N, V>>();
    protected Map<K, DepFactPolicy> depPolicies = new HashMap<K, DepFactPolicy>();
    protected Map<K, RefFactPolicy> refPolicies = new HashMap<K, RefFactPolicy>();
    protected Lock lock = new ReentrantLock();

    public static <K, N, V> ITaskRegistry<K, N, V> getScheduler(Class<K> keyType, Class<N> name, Class<V> value) {
        ClassTriple key = new ClassTriple(keyType, name, value);
        TaskRegistry<Object, Object, Object> scheduler = schedulers.get(key);
        if (scheduler == null) {
            scheduler = new TaskRegistry<K, N, V>();
            schedulers.put(key, scheduler);
        }
        return scheduler;
    }

    @Override
    public ITask<K, N, V> getProducer(K key, N name) {
        ITask<K, N, V> producer = this.producers.get(key);
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean produce(IRascalMonitor monitor, ITransaction<K, N, V> tr, K key, N name) {
        ITask<K, N, V> producer = null;
        this.lock.lock();
        try {
            producer = this.getProducer(key, name);
        }
        finally {
            this.lock.unlock();
        }
        if (producer == null) {
            throw new ImplementationError("No registered fact producer for " + key.toString());
        }
        return producer.produce(monitor, tr, key, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProducer(ITask<K, N, V> producer) {
        this.lock.lock();
        try {
            for (K key : producer.getKeys()) {
                this.producers.put(key, producer);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterProducer(ITask<K, N, V> producer) {
        this.lock.lock();
        try {
            for (K key : producer.getKeys()) {
                if (this.producers.get(key) != producer) continue;
                this.producers.remove(key);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setRefPolicy(K key, RefFactPolicy policy) {
        this.lock.lock();
        try {
            this.refPolicies.put(key, policy);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setDepPolicy(K key, DepFactPolicy policy) {
        this.lock.lock();
        try {
            this.depPolicies.put(key, policy);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DepFactPolicy getDepPolicy(K key) {
        this.lock.lock();
        try {
            DepFactPolicy policy = this.depPolicies.get(key);
            if (policy == null) {
                policy = DepFactPolicy.DEFAULT;
            }
            DepFactPolicy depFactPolicy = policy;
            return depFactPolicy;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefFactPolicy getRefPolicy(K key) {
        this.lock.lock();
        try {
            RefFactPolicy policy = this.refPolicies.get(key);
            if (policy == null) {
                policy = RefFactPolicy.DEFAULT;
            }
            RefFactPolicy refFactPolicy = policy;
            return refFactPolicy;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Collection<K> getKeys() {
        this.lock.lock();
        try {
            Set<K> set = this.producers.keySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.producers.clear();
            schedulers.clear();
            this.depPolicies.clear();
            this.refPolicies.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }
}

