/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.rascalmpl.uri.URIResolverRegistry;

public interface ISourceLocationOutput {
    public OutputStream getOutputStream(ISourceLocation var1, boolean var2) throws IOException;

    default public FileChannel getWritableOutputStream(ISourceLocation uri, boolean append) throws IOException {
        throw new UnsupportedOperationException("The " + this.scheme() + " scheme does not support writable output channels.");
    }

    public String scheme();

    public boolean supportsHost();

    default public boolean supportsWritableFileChannel() {
        return false;
    }

    public void mkDirectory(ISourceLocation var1) throws IOException;

    public void remove(ISourceLocation var1) throws IOException;

    default public void rename(ISourceLocation from, ISourceLocation to, boolean overwrite) throws IOException {
        URIResolverRegistry.getInstance().copy(from, to, true, overwrite);
        URIResolverRegistry.getInstance().remove(from, true);
    }

    default public Charset getCharset(ISourceLocation uri) throws IOException {
        return StandardCharsets.UTF_8;
    }

    public void setLastModified(ISourceLocation var1, long var2) throws IOException;
}

