/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.fs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FSEntry {
    final long created;
    volatile long lastModified;

    public FSEntry(long created, long lastModified) {
        this.created = created;
        this.lastModified = lastModified;
    }

    public FSEntry(@Nullable FileTime created, long lastModified) {
        this(created == null ? lastModified : created.toMillis(), lastModified);
    }

    public long getCreated() {
        return this.created;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public static FSEntry forFile(Path file) {
        try {
            BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            return new FSEntry(attr.creationTime().toMillis(), attr.lastModifiedTime().toMillis());
        }
        catch (IOException e) {
            return new FSEntry(0L, 0L);
        }
    }
}

