/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.NotDirectoryException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.apache.commons.io.FileExistsException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.uri.fs.FSEntry;

public class FileSystemTree<T extends FSEntry> {
    private final Directory<T> root;
    protected volatile IOException delayedException;

    public FileSystemTree(T root) {
        this.root = new Directory<T>(root, "");
    }

    void throwDelayed() throws IOException {
        if (this.delayedException != null) {
            throw this.delayedException;
        }
    }

    public void addFile(String path, T entry, BiFunction<Long, Long, T> inferDirectory) throws IOException {
        this.root.add(path, entry, inferDirectory, true);
    }

    public void addDirectory(String path, T entry, BiFunction<Long, Long, T> inferDirectory) throws IOException {
        this.root.add(path, entry, inferDirectory, false);
    }

    public void replaceFile(String path, UnaryOperator<T> replacer) throws IOException {
        this.root.replaceFile(path, replacer);
    }

    public void remove(String path) throws IOException {
        try {
            this.root.remove(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public T getEntry(String path) throws IOException {
        this.throwDelayed();
        Child<T> result = this.root.getEntry(path);
        if (result == null) {
            throw new FileNotFoundException(path + " could not be found");
        }
        if (result.file != null) {
            return result.file;
        }
        return result.directory.self;
    }

    public long lastModified(String path) throws IOException {
        this.throwDelayed();
        return ((FSEntry)this.getEntry((String)path)).lastModified;
    }

    public long created(String path) throws IOException {
        this.throwDelayed();
        return ((FSEntry)this.getEntry((String)path)).created;
    }

    public boolean exists(String path) {
        try {
            return this.root.getEntry(path) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isFile(String path) {
        try {
            Child<T> result = this.root.getEntry(path);
            return result != null && result.file != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isDirectory(String path) {
        try {
            Child<T> result = this.root.getEntry(path);
            return result != null && result.directory != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void touch(String path, long newTimestamp) throws IOException {
        ((FSEntry)this.getEntry((String)path)).lastModified = newTimestamp;
    }

    public boolean isEmpty() {
        return this.root.children.isEmpty();
    }

    public String[] directChildren(String path) throws IOException {
        this.throwDelayed();
        Child<T> entry = this.root.getEntry(path);
        if (entry == null) {
            throw new FileNotFoundException(path);
        }
        if (entry.directory == null) {
            throw new NotDirectoryException(path);
        }
        return (String[])entry.directory.children.keySet().toArray(String[]::new);
    }

    private static class Child<T extends FSEntry> {
        private final @Nullable T file;
        private final @Nullable Directory<T> directory;

        private Child(@Nullable T file, @Nullable Directory<T> directory) {
            this.file = file;
            this.directory = directory;
        }

        public Child(T file) {
            this(file, null);
        }

        public Child(Directory<T> dir) {
            this(null, dir);
        }
    }

    private static class Directory<T extends FSEntry> {
        private final T self;
        private final String prefix;
        private final ConcurrentMap<String, Child<T>> children = new ConcurrentHashMap<String, Child<T>>();

        public Directory(T self, String prefix) {
            this.self = self;
            this.prefix = prefix;
        }

        public void add(String path, T entry, BiFunction<Long, Long, T> inferDirectory, boolean isFile) throws IOException {
            this.add(Directory.parsePath(path), entry, inferDirectory, isFile);
        }

        public void add(Iterator<String> path, T entry, BiFunction<Long, Long, T> inferDirectory, boolean isFile) throws IOException {
            String currentPart = path.next();
            if (path.hasNext() || !isFile) {
                Child child = this.children.computeIfAbsent(currentPart, s2 -> new Child<FSEntry>(new Directory<FSEntry>((FSEntry)inferDirectory.apply(entry.created, entry.created), this.prefix + "/" + s2)));
                if (child.directory == null) {
                    throw new NotDirectoryException(this.prefix + "/" + currentPart);
                }
                if (path.hasNext()) {
                    child.directory.add(path, entry, inferDirectory, isFile);
                }
            } else {
                Child<T> existing = this.children.putIfAbsent(currentPart, new Child<T>(entry));
                if (existing != null) {
                    throw new FileExistsException(this.prefix + "/" + currentPart);
                }
                ((FSEntry)this.self).lastModified = Math.max(((FSEntry)this.self).lastModified, ((FSEntry)entry).lastModified);
            }
        }

        private <R> R execute(String path, ThrowableEntryAction<T, R> operation) throws IOException {
            return this.execute(Directory.parsePath(path), operation);
        }

        private <R> R execute(Iterator<String> path, ThrowableEntryAction<T, R> operation) throws IOException {
            if (!path.hasNext()) {
                return operation.apply(this, "");
            }
            String childPath = path.next();
            if (path.hasNext()) {
                Child result = (Child)this.children.get(childPath);
                if (result == null) {
                    throw new FileNotFoundException(this.prefix + "/" + childPath);
                }
                if (result.directory == null) {
                    throw new NotDirectoryException(this.prefix + "/" + childPath);
                }
                return result.directory.execute(path, operation);
            }
            return operation.apply(this, childPath);
        }

        public @Nullable Child<T> getEntry(String path) throws IOException {
            return this.execute(path, (Directory<T> d, String e) -> e.isEmpty() ? new Child(d) : (Child)d.children.get(e));
        }

        public void replaceFile(String path, UnaryOperator<T> replacer) throws IOException {
            this.execute(path, (Directory<T> d, String e) -> {
                Child result = d.children.computeIfPresent(e, (s2, c) -> {
                    if (c.file == null) {
                        throw new IllegalArgumentException(s2 + " is not a file");
                    }
                    return new Child<FSEntry>((FSEntry)replacer.apply(c.file));
                });
                if (result == null) {
                    throw new FileNotFoundException(path);
                }
                return null;
            });
        }

        public void remove(String path) throws IOException {
            this.execute(path, (Directory<T> d, String e) -> {
                Child removed = d.children.computeIfPresent(e, (n, old) -> {
                    if (old.directory != null && !old.directory.children.isEmpty()) {
                        return old;
                    }
                    return null;
                });
                if (removed != null) {
                    throw new DirectoryNotEmptyException(path);
                }
                ((FSEntry)d.self).lastModified = Math.max(((FSEntry)d.self).lastModified, System.currentTimeMillis());
                return null;
            });
        }

        private static Iterator<String> parsePath(final String path) {
            return new Iterator<String>(){
                String nextString = null;
                int prevIndex = Directory.nextNonSlash(path, 0);

                @Override
                public boolean hasNext() {
                    if (this.nextString == null && this.prevIndex != -1 && this.prevIndex < path.length()) {
                        int nextIndex = path.indexOf(47, this.prevIndex);
                        if (nextIndex == -1) {
                            this.nextString = path.substring(this.prevIndex);
                            this.prevIndex = -1;
                        } else {
                            this.nextString = path.substring(this.prevIndex, nextIndex);
                            this.prevIndex = Directory.nextNonSlash(path, nextIndex + 1);
                        }
                    }
                    return this.nextString != null;
                }

                @Override
                public String next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    String result = this.nextString;
                    this.nextString = null;
                    return result;
                }
            };
        }

        private static int nextNonSlash(String path, int offset) {
            int result;
            for (result = offset; result < path.length() && path.charAt(result) == '/'; ++result) {
            }
            return result;
        }
    }

    @FunctionalInterface
    private static interface ThrowableEntryAction<T extends FSEntry, R> {
        public R apply(Directory<T> var1, String var2) throws IOException;
    }
}

