/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.project;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import org.rascalmpl.uri.ILogicalSourceLocationResolver;
import org.rascalmpl.uri.URIUtil;

public class ProjectURIResolver
implements ILogicalSourceLocationResolver {
    private ISourceLocation root;
    private String name;

    public ProjectURIResolver(ISourceLocation root, String name) {
        this.root = root;
        this.name = name;
    }

    @Override
    public ISourceLocation resolve(ISourceLocation input) throws IOException {
        if (!input.getAuthority().equals(this.name)) {
            return null;
        }
        return URIUtil.getChildLocation(this.root, input.getPath());
    }

    @Override
    public String scheme() {
        return "project";
    }

    @Override
    public String authority() {
        return this.name;
    }
}

