/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.zip;

import java.io.IOException;
import java.util.zip.ZipEntry;
import org.rascalmpl.uri.fs.FileSystemTree;
import org.rascalmpl.uri.zip.EntryEnumerator;
import org.rascalmpl.uri.zip.IndexedFSEntry;

public class CompressedFSTree
extends FileSystemTree<IndexedFSEntry> {
    private final long totalSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompressedFSTree(IndexedFSEntry root, EntryEnumerator openEntries) {
        super(root);
        long totalSize = 0L;
        int pos = 0;
        try (EntryEnumerator.CloseableIterator entries = openEntries.openZip();){
            while (entries.hasNext()) {
                ZipEntry je = entries.next();
                IndexedFSEntry childEntry = new IndexedFSEntry(je, pos);
                String name = je.getName();
                if (je.isDirectory()) {
                    this.addDirectory(je.getName(), childEntry, IndexedFSEntry::new);
                } else {
                    totalSize += (long)(24 + name.length() * 2);
                    this.addFile(name, childEntry, IndexedFSEntry::new);
                }
                ++pos;
            }
        }
        catch (IOException e) {
            this.delayedException = e;
        }
        finally {
            this.totalSize = totalSize;
        }
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public int getPosition(String path) throws IOException {
        return ((IndexedFSEntry)this.getEntry((String)path)).offset;
    }
}

