/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.zip;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipEntry;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.uri.fs.FSEntry;

public class IndexedFSEntry
extends FSEntry {
    final int offset;

    public IndexedFSEntry(long created, long lastModified, int offset) {
        super(created, lastModified);
        this.offset = offset;
    }

    public IndexedFSEntry(@Nullable FileTime created, long lastModified, int offset) {
        this(created == null ? lastModified : created.toMillis(), lastModified, offset);
    }

    public IndexedFSEntry(long created, long lastModified) {
        this(created, lastModified, -1);
    }

    public IndexedFSEntry(FSEntry e) {
        this(e.getCreated(), e.getLastModified());
    }

    public IndexedFSEntry(ZipEntry ze, int offset) {
        this(ze.getCreationTime(), ze.getTime(), offset);
    }

    public static IndexedFSEntry forFile(File file) {
        return IndexedFSEntry.forFile(file.toPath());
    }

    public static IndexedFSEntry forFile(Path file) {
        return new IndexedFSEntry(FSEntry.forFile(file));
    }
}

