---
title: "module Message"
id: Message
slug: /Library//Message
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Provides the `Message` datatype that represents error messages and warnings.
#### Usage

```rascal
import Message;
```

#### Dependencies
```rascal
import IO;
```

#### Description


Messages can be used to communicate information about source texts.
They can be interpreted by IDEs to display type errors and warnings, etc.

`Message`s are, for instance, used as additional keyword fields of
other data types (syntax trees), or collected in sets or lists of errors to 
be published in an IDE. See [IDEServices](..//Library/util/IDEServices.md).


## data Message {#Message-Message}
Symbolic representation of error messages with a source location of the cause.

```rascal
data Message  
     = error(str msg, loc at)
     | error(str msg)
     | warning(str msg, loc at)
     | info(str msg, loc at)
     ;
```

## function write {#Message-write}

Call the standard message pretty-printing and sorting code, writing the result to a string

```rascal
str write(list[Message] messages, list[loc] roots=[])
```

## function mainMessageHandler {#Message-mainMessageHandler}

Reusable message handler for commandline `main` functions

```rascal
int mainMessageHandler(list[Message] messages, list[loc] srcs=[], bool errorsAsWarnings = false, bool warningsAsErrors = false)
```


This function takes care of some typical responsibilities of `main` functions:
* return an `int` to signal failure (!= 0) or success (0).
* print the collected and sorted error messages to stdout.
* implement the errorsAsWarnings feature.
* implement the warningsAsErrors feature.

With `errorsAsWarnings` we do not fail while we are still developing experimental code. The process
of testing and deployment may continue even if (fatal) errors were detected.

With `warningsAsErrors` we can signal a higher level of stability and compliance than the default.
Every new warnings will lead to a failing build, making sure that new issues can not creep in anymore.

#### Benefits


* consistent error handling between different `main` functions
* consistent error printing
* consistent interpretation of errorsAsWarnings and warningsAsErrors

#### Pitfalls


* stdout is used to print the messages; no further processing is possible.
* have to remember to return the result of this function as the return value of `main`

