---
title: "module analysis::diff::edits::TextEdits"
id: TextEdits
slug: /Library/analysis/diff/edits/TextEdits
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Intermediate representation for file creation, removal and changing, including textual (string) rewriting.
#### Usage

```rascal
import analysis::diff::edits::TextEdits;
```



[Document Edit](../../../..//Library/analysis/diff/edits/TextEdits.md#analysis-diff-edits-TextEdits-DocumentEdit)s can be produced by source-to-source transformation tools, and then executed 
via [Execute Document Edits](../../../..//Library/analysis/diff/edits/ExecuteTextEdits.md#analysis-diff-edits-ExecuteTextEdits-executeDocumentEdits) in the REPL or [Apply Documents Edits](../../../..//Library/util/IDEServices.md#util-IDEServices-applyDocumentsEdits) by the IDE.

#### Benefits


* Document edits can be attached to [Code Action](../../../..//Library/util/IDEServices.md#util-IDEServices-CodeAction)s and error [IDEServices-Message](../../../..//Library/util/IDEServices.md#util-IDEServices-Message)s, to achieve interactive 
source code rewriting utilities. 
* Document edits can be tested via [Execute Document Edits](../../../..//Library/analysis/diff/edits/ExecuteTextEdits.md#analysis-diff-edits-ExecuteTextEdits-executeDocumentEdits)
* Document edits can be "high fidelity", avoiding unnecessary damage to a source text.   

#### Pitfalls


* Code edits depend on a specific state of the source file that may be transient while editing. Use the [Code Action](../../../..//Library/util/IDEServices.md#util-IDEServices-CodeAction) interface
to avoid racing for the state of the source file.


## data DocumentEdit {#analysis-diff-edits-TextEdits-DocumentEdit}
File changing operations

```rascal
data DocumentEdit  
     = removed(loc file)
     | created(loc file)
     | renamed(loc from, loc to)
     | changed(loc file, list[TextEdit] edits)
     ;
```

## function changed {#analysis-diff-edits-TextEdits-changed}

Shorthand for file changes.

```rascal
DocumentEdit changed(list[TextEdit] edits:[replace(loc l, str _), *_])
```

## data TextEdit {#analysis-diff-edits-TextEdits-TextEdit}
String rewriting operations

```rascal
data TextEdit  
     = replace(loc range, str replacement)
     ;
```


The core operation is to replace a substring with another.
The replace operator uses a `loc` value to point to a range inside a string,
and a `str` as its replacement.

## function delete {#analysis-diff-edits-TextEdits-delete}

Deletion is replacement with an empty string.

```rascal
TextEdit delete(loc range)
```

## function insertBefore {#analysis-diff-edits-TextEdits-insertBefore}

Inserting before a given range.

```rascal
TextEdit insertBefore(loc range, str insertion, str separator=" ")
```

## function insertAfter {#analysis-diff-edits-TextEdits-insertAfter}

Inserting after a given range.

```rascal
TextEdit insertAfter(loc range, str insertion, str separator=" ")
```

