---
title: "module analysis::formalconcepts::FCA"
id: FCA
slug: /Library/analysis/formalconcepts/FCA
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Library for Formal Concept Analysis
#### Usage

```rascal
import analysis::formalconcepts::FCA;
```

#### Dependencies
```rascal
import Set;
import Map;
import Relation;
import lang::dot::Dot;
```

#### Description


Formal Concept Analysis is a somewhat ubiquitous tool in software analysis projects. 
It can be used to find latent groups of objects that share the same attributes in a dataset. 
Typically, we apply `FCA` to a relation `rel[&O objects, &A attributes]`, which represents
extracted source code artifacts and their attributes.


## alias FormalContext {#analysis-formalconcepts-FCA-FormalContext}

```rascal
rel[&Object, &Attribute]
```

## alias Concept {#analysis-formalconcepts-FCA-Concept}

```rascal
tuple[set[&Object] objects, set[&Attribute] attributes]
```

## alias ConceptLattice {#analysis-formalconcepts-FCA-ConceptLattice}

```rascal
rel[Concept[&Object, &Attribute], Concept[&Object, &Attribute]]
```

## alias Object2Attributes {#analysis-formalconcepts-FCA-Object2Attributes}

```rascal
map[&Object, set[&Attribute]]
```

## alias Attribute2Objects {#analysis-formalconcepts-FCA-Attribute2Objects}

```rascal
map[&Attribute, set[&Object]]
```

## function fca {#analysis-formalconcepts-FCA-fca}

Computes Concept Lattice given the Object Attribute Relation.

```rascal
ConceptLattice[&Object, &Attribute] fca (FormalContext[&Object, &Attribute] fc)
```

## function toDot {#analysis-formalconcepts-FCA-toDot}

Computes Dot Graph from Concept Lattice.

```rascal
DotGraph toDot(ConceptLattice[&Object, &Attribute] cl)

DotGraph toDot(ConceptLattice[&Object, &Attribute] cl, bool lab)
```

## function toDotline {#analysis-formalconcepts-FCA-toDotline}

```rascal
Dotline toDotline(ConceptLattice[&Object, &Attribute] cl)
```

## function toOutline {#analysis-formalconcepts-FCA-toOutline}

```rascal
Outline toOutline(ConceptLattice[&Object, &Attribute] cl)
```

## function toFormalContext {#analysis-formalconcepts-FCA-toFormalContext}

```rascal
FormalContext[&Object, &Attribute] toFormalContext(Object2Attributes[&Object, &Attribute] objects)

FormalContext[&Object, &Attribute] toFormalContext(Attribute2Objects[&Object, &Attribute] attributes)
```

## function intersection {#analysis-formalconcepts-FCA-intersection}

```rascal
set[&T] intersection(set[set[&T]] st)
```

## function union {#analysis-formalconcepts-FCA-union}

```rascal
set[&T] union(set[set[&T]] st)
```

## function isSubset {#analysis-formalconcepts-FCA-isSubset}

```rascal
bool isSubset(set[set[&T]] candidate, set[&T] s )
```

## function sigma {#analysis-formalconcepts-FCA-sigma}

```rascal
set[&Attribute] sigma(FormalContext[&Object, &Attribute] fc, set[&Object] objects)
```

## function tau {#analysis-formalconcepts-FCA-tau}

```rascal
set[&Object] tau(FormalContext[&Object, &Attribute] fc, set[&Attributes] attributes)
```

## function maxincl {#analysis-formalconcepts-FCA-maxincl}

```rascal
set[set[&T]] maxincl(set[set[&T]] c)
```

## function createAttributeLattice {#analysis-formalconcepts-FCA-createAttributeLattice}

```rascal
rel[set[&Attribute], set[&Attribute]] createAttributeLattice(FormalContext[&Object, &Attribute] fc)
```

## function makeNodes {#analysis-formalconcepts-FCA-makeNodes}

```rascal
map[Concept[&Object, &Attribute], int] makeNodes(ConceptLattice[&Object, &Attribute] q)
```

## function addConcept {#analysis-formalconcepts-FCA-addConcept}

```rascal
set[&Attribute] addConcept(ConceptLattice[&Object, &Attribute] q,  Concept[&Object, &Attribute] c)
```

## function compose {#analysis-formalconcepts-FCA-compose}

```rascal
Stm compose(Concept[&Object, &Attribute] c, map[Concept[&Object, &Attribute], int] z, bool lab)
```

## function toDotString {#analysis-formalconcepts-FCA-toDotString}

Write relation in `.dot` format.

```rascal
str toDotString(ConceptLattice[&Object, &Attribute]  q)
```

