---
title: "module analysis::graphs::LabeledGraph"
id: LabeledGraph
slug: /Library/analysis/graphs/LabeledGraph
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

#### Usage

```rascal
import analysis::graphs::LabeledGraph;
```

#### Dependencies
```rascal
import analysis::graphs::Graph;
import Relation;
```


## alias LGraph {#analysis-graphs-LabeledGraph-LGraph}

```rascal
rel[&T from, &L label, &T to]
```

## function bottom {#analysis-graphs-LabeledGraph-bottom}

Return the bottom nodes of a LGraph.

```rascal
set[&T] bottom(LGraph[&T,&L] G)
```

## function predecessors {#analysis-graphs-LabeledGraph-predecessors}

The predecessors of a single node in a LGraph.

```rascal
set[&T] predecessors(LGraph[&T,&L] G, &T From)
```

## function reach {#analysis-graphs-LabeledGraph-reach}

Reachability from a given start set of nodes.

```rascal
set[&T] reach(LGraph[&T,&L] G, set[&T] Start)
```

## function reachR {#analysis-graphs-LabeledGraph-reachR}

Reachability from given start set of nodes with restrictions.

```rascal
set[&T] reachR(LGraph[&T,&L] G, set[&T] Start, set[&T] Restr)
```

## function reachX {#analysis-graphs-LabeledGraph-reachX}

Reachability from given start set of nodes with exclusions.

```rascal
set[&T] reachX(LGraph[&T,&L] G, set[&T] Start, set[&T] Excl)
```

## function successors {#analysis-graphs-LabeledGraph-successors}

The successors of a single node in a LGraph.

```rascal
set[&T] successors(LGraph[&T, &L] G, &T From)
```

## function top {#analysis-graphs-LabeledGraph-top}

Return the top nodes of a LGraph.

```rascal
set[&T] top(LGraph[&T,&L] G)
```

