---
title: "module lang::aterm::\\syntax::ATerm"
id: ATerm
slug: /Library/lang/aterm/syntax/ATerm
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

#### Usage

```rascal
import lang::aterm::\syntax::ATerm;
```



## syntax AFun {#lang-aterm-\syntax-ATerm-AFun}

```rascal
syntax AFun = Quoted: StrCon |
              Unquoted: IdCon
              ;
```

## syntax ATerm {#lang-aterm-\syntax-ATerm-ATerm}

```rascal
syntax ATerm = Int: IntCon |
               Real: RealCon |
               Fun: AFun |
               Appl: AFun "(" {ATerm ","}+ ")" |
               Placeholder: "\<" ATerm "\>" |
               List: "[" {ATerm ","}* "]" |
               Annotated: ATerm Annotation
               ;
```

## syntax Annotation {#lang-aterm-\syntax-ATerm-Annotation}

```rascal
syntax Annotation = Default: "{" {ATerm ","}+ "}"
                    ;
```

## syntax IntCon {#lang-aterm-\syntax-ATerm-IntCon}

```rascal
syntax IntCon = Natural: NatCon |
                Positive: "+" NatCon |
                Negative: "-" NatCon
                ;
```

## syntax RealCon {#lang-aterm-\syntax-ATerm-RealCon}

```rascal
syntax RealCon = RealCon: IntCon "." NatCon OptExp
                 ;
```

## syntax OptExp {#lang-aterm-\syntax-ATerm-OptExp}

```rascal
syntax OptExp = Present: "e" IntCon |
                Absent: 
                ;
```

## syntax NatCon {#lang-aterm-\syntax-ATerm-NatCon}

```rascal
lexical NatCon = Digits: [0-9]+ !>> [0-9];
```

## syntax StrChar {#lang-aterm-\syntax-ATerm-StrChar}

```rascal
lexical StrChar = NewLine: [\\] [n] 
                | Tab: [\\] [t] 
                | Quote: [\\] [\"] 
                |  Backslash: [\\] [\\] 
                |  Decimal: [\\] [0-9] [0-9] [0-9] 
                |  Normal: ![\n\t\"\\] 
                ;
```

## syntax StrCon {#lang-aterm-\syntax-ATerm-StrCon}

```rascal
lexical StrCon = Default: [\"] StrChar* [\"]
                ;
```

## syntax IdCon {#lang-aterm-\syntax-ATerm-IdCon}

```rascal
lexical IdCon = Default: [A-Za-z] [A-Za-z\-0-9]* !>> [A-Za-z\-0-9];
```

