---
title: "module lang::diff::unified::UnifiedDiff"
id: UnifiedDiff
slug: /Library/lang/diff/unified/UnifiedDiff
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Syntax definition for Unified Diff format (see <http://en.wikipedia.org/wiki/Diff_utility#Unified_format>)
#### Usage

```rascal
import lang::diff::unified::UnifiedDiff;
```



## syntax DiffFile {#lang-diff-unified-UnifiedDiff-DiffFile}

```rascal
start syntax DiffFile = Diff;
```

## syntax Diff {#lang-diff-unified-UnifiedDiff-Diff}

```rascal
syntax Diff
  = Header old Header new Chunk* chunks
  ;
```

## syntax Chunk {#lang-diff-unified-UnifiedDiff-Chunk}

```rascal
syntax Chunk
  = ChunkStart Line+
  ;
```

## syntax ChunkStart {#lang-diff-unified-UnifiedDiff-ChunkStart}

```rascal
syntax ChunkStart
  = ^ "@@ -" Range " +" Range " @@" Content
  ;
```

## syntax Header {#lang-diff-unified-UnifiedDiff-Header}

```rascal
syntax Header
  = ^ Indicator " " FileName DateTime?  "\n"
  ;
```

## syntax DateTime {#lang-diff-unified-UnifiedDiff-DateTime}

```rascal
syntax DateTime
  = "\t" Date date " " Time time " " TimeZone timeZone
  ;
```

## syntax FileName {#lang-diff-unified-UnifiedDiff-FileName}

```rascal
lexical FileName
  = ![\t\n]* 
  ;
```

## syntax Indicator {#lang-diff-unified-UnifiedDiff-Indicator}

```rascal
syntax Indicator
  = old: "---" 
  | new: "+++"
  ;
```

## syntax Date {#lang-diff-unified-UnifiedDiff-Date}

```rascal
syntax Date
  = Year year "-" Month month "-" Day day
  ;
```

## syntax Time {#lang-diff-unified-UnifiedDiff-Time}

```rascal
syntax Time
  = Hours hours ":" Minutes minutes ":" Seconds seconds [0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]
  ;
```

## syntax Year {#lang-diff-unified-UnifiedDiff-Year}

```rascal
lexical Year = [0-9][0-9][0-9][0-9];
```

## syntax Month {#lang-diff-unified-UnifiedDiff-Month}

```rascal
lexical Month = [0-1][0-9];
```

## syntax Day {#lang-diff-unified-UnifiedDiff-Day}

```rascal
lexical Day = [0-1][0-9];
```

## syntax Hours {#lang-diff-unified-UnifiedDiff-Hours}

```rascal
lexical Hours = [0-2][0-9];
```

## syntax Minutes {#lang-diff-unified-UnifiedDiff-Minutes}

```rascal
lexical Minutes = [0-6][0-9];
```

## syntax Seconds {#lang-diff-unified-UnifiedDiff-Seconds}

```rascal
lexical Seconds = [0-6][0-9];
```

## syntax TimeZone {#lang-diff-unified-UnifiedDiff-TimeZone}

```rascal
syntax TimeZone
  = Sign sign Hours hours Minutes minutes 
  ;
```

## syntax Sign {#lang-diff-unified-UnifiedDiff-Sign}

```rascal
lexical Sign = [+\-];
```

## syntax Range {#lang-diff-unified-UnifiedDiff-Range}

```rascal
syntax Range
  = Decimal begin // chunksize = 1
  | Decimal begin "," Decimal size
  ;
```

## syntax Decimal {#lang-diff-unified-UnifiedDiff-Decimal}

```rascal
lexical Decimal
  = [0-9]+ !>> [0-9]
  ;
```

## syntax Line {#lang-diff-unified-UnifiedDiff-Line}

```rascal
syntax Line
  = common: ^ " " Content content 
  | onlyOld: ^ "-" Content content
  | onlyNew: ^ "+" Content content
  | noNewLine: ^"\\ No newline at end of file\n"
  ;
```

## syntax Content {#lang-diff-unified-UnifiedDiff-Content}

```rascal
lexical Content
  = ![\n]* [\n]
  ;
```

