---
title: "module lang::sdf2::util::SDF2Grammar"
id: SDF2Grammar
slug: /Library/lang/sdf2/util/SDF2Grammar
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Convert SDF2 grammars to an (unnormalized) Rascal internal grammar representation (Grammar).
#### Usage

```rascal
import lang::sdf2::util::SDF2Grammar;
```

#### Dependencies
```rascal
import IO;
import String;
import Set;
import List;
import Map;
import ParseTree;
import Grammar;
import lang::rascal::grammar::definition::Characters;
import lang::sdf2::\syntax::Sdf2;
```


## function label {#lang-sdf2-util-SDF2Grammar-label}

```rascal
Symbol label(str s, conditional(Symbol t, set[Condition] cs))
```

## function conditional {#lang-sdf2-util-SDF2Grammar-conditional}

```rascal
Symbol conditional(conditional(Symbol s, set[Condition] c1), set[Condition] c2)
```

## function sdf2grammar {#lang-sdf2-util-SDF2Grammar-sdf2grammar}

```rascal
GrammarDefinition sdf2grammar(loc input)

GrammarDefinition sdf2grammar(str main, loc input)

GrammarDefinition sdf2grammar(SDF def)
```

## function injectStarts {#lang-sdf2-util-SDF2Grammar-injectStarts}

```rascal
Grammar::Grammar injectStarts(Grammar::Grammar g)
```

## function sdf2grammar {#lang-sdf2-util-SDF2Grammar-sdf2grammar}

```rascal
GrammarDefinition sdf2grammar(str main, SDF def)
```

## function split {#lang-sdf2-util-SDF2Grammar-split}

```rascal
GrammarDefinition split(GrammarDefinition def)
```

## function removeDirectProductionCycle {#lang-sdf2-util-SDF2Grammar-removeDirectProductionCycle}

```rascal
GrammarDefinition removeDirectProductionCycle(GrammarDefinition def)
```

## function isProductionCycle {#lang-sdf2-util-SDF2Grammar-isProductionCycle}

```rascal
bool isProductionCycle(\prod(_, [sing], _), Production b)

default bool isProductionCycle(Production a, Production b)
```

## function addLexicalChaining {#lang-sdf2-util-SDF2Grammar-addLexicalChaining}

```rascal
GrammarDefinition addLexicalChaining(GrammarDefinition def)
```

## function striprec {#lang-sdf2-util-SDF2Grammar-striprec}

```rascal
Symbol striprec(Symbol s)
```

## function strip {#lang-sdf2-util-SDF2Grammar-strip}

```rascal
Symbol strip(label(str _, Symbol s))

Symbol strip(conditional(Symbol s, set[Condition] _))

default Symbol strip(Symbol s)
```

## function split {#lang-sdf2-util-SDF2Grammar-split}

```rascal
Grammar::Grammar split(Grammar::Grammar g)
```

## data Production {#lang-sdf2-util-SDF2Grammar-Production}

```rascal
data Production  
     = temp()
     ;
```

## function isNotEmpty {#lang-sdf2-util-SDF2Grammar-isNotEmpty}

```rascal
bool isNotEmpty(Production p)
```

## function removeEmptyProductions {#lang-sdf2-util-SDF2Grammar-removeEmptyProductions}

```rascal
Grammar::Grammar removeEmptyProductions(Grammar::Grammar g)
```

## function keep {#lang-sdf2-util-SDF2Grammar-keep}

```rascal
Production keep(Production source, Symbol s)
```

## function getModule {#lang-sdf2-util-SDF2Grammar-getModule}

```rascal
GrammarModule getModule(Module m)
```

## function moduleName {#lang-sdf2-util-SDF2Grammar-moduleName}

```rascal
str moduleName(/<pre:.*>\/<post:.*>/)

str moduleName(/languages::<rest:.*>/)

default str moduleName(str i)
```

## function getImports {#lang-sdf2-util-SDF2Grammar-getImports}

```rascal
set[str] getImports(Module m)
```

## function applyConditions {#lang-sdf2-util-SDF2Grammar-applyConditions}

```rascal
GrammarDefinition applyConditions(GrammarDefinition d,  map[Symbol from,Symbol to] conds)
```

## function illegalPriorities {#lang-sdf2-util-SDF2Grammar-illegalPriorities}

```rascal
Grammar::Grammar illegalPriorities(Grammar::Grammar g)
```

## function dup {#lang-sdf2-util-SDF2Grammar-dup}

```rascal
&T dup(&T g)
```

## function getProductions {#lang-sdf2-util-SDF2Grammar-getProductions}

```rascal
set[Production] getProductions(Module \mod)

set[Production] getProductions(SDF sd)

set[Production] getProductions(Prod* prods, bool isLex)
```

## function fixParameters {#lang-sdf2-util-SDF2Grammar-fixParameters}

```rascal
set[Production] fixParameters(set[Production] input)
```

## function labelName {#lang-sdf2-util-SDF2Grammar-labelName}

```rascal
str labelName("")

default str labelName(str s)
```

## function getProduction {#lang-sdf2-util-SDF2Grammar-getProduction}

```rascal
set[Production] getProduction(Prod P, bool isLex)
```

## function getConditions {#lang-sdf2-util-SDF2Grammar-getConditions}

```rascal
set[Symbol] getConditions(SDF m)
```

## function getRestrictions {#lang-sdf2-util-SDF2Grammar-getRestrictions}

```rascal
set[Symbol] getRestrictions(Restriction* restrictions, bool isLex)
```

## function getRestriction {#lang-sdf2-util-SDF2Grammar-getRestriction}

```rascal
set[Symbol] getRestriction(Restriction restriction, bool isLex)
```

## function getLookaheads {#lang-sdf2-util-SDF2Grammar-getLookaheads}

```rascal
set[Symbol] getLookaheads(Lookaheads ls)
```

## function getPriorities {#lang-sdf2-util-SDF2Grammar-getPriorities}

```rascal
set[Production] getPriorities({Priority ","}* priorities, bool isLex)
```

## function getPriority {#lang-sdf2-util-SDF2Grammar-getPriority}

```rascal
Production getPriority(Group group, bool isLex)

Production getPriority(Priority p, bool isLex)
```

## function definedSymbol {#lang-sdf2-util-SDF2Grammar-definedSymbol}

```rascal
Symbol definedSymbol((&T <: Tree) v, bool isLex)
```

## function getStartSymbols {#lang-sdf2-util-SDF2Grammar-getStartSymbols}

```rascal
set[Symbol] getStartSymbols(Module \mod)
```

## function getSymbols {#lang-sdf2-util-SDF2Grammar-getSymbols}

```rascal
list[Symbol] getSymbols((Syms) `<Sym* ss>`, bool isLex)
```

## function getSymbol {#lang-sdf2-util-SDF2Grammar-getSymbol}

```rascal
Symbol getSymbol(Sym sym, bool isLex)
```

## function alt {#lang-sdf2-util-SDF2Grammar-alt}

```rascal
Symbol alt({alt(set[Symbol] ss), *Symbol rest})
```

## function unescape {#lang-sdf2-util-SDF2Grammar-unescape}

```rascal
str unescape(Sym s)

str unescape(StrCon s)

str unescape(SingleQuotedStrCon s)
```

## function unescapeStr {#lang-sdf2-util-SDF2Grammar-unescapeStr}

```rascal
str unescapeStr(str chars)
```

## function getCharClass {#lang-sdf2-util-SDF2Grammar-getCharClass}

```rascal
Symbol getCharClass(Class cc)
```

## function getCharRange {#lang-sdf2-util-SDF2Grammar-getCharRange}

```rascal
CharRange getCharRange(Range r)
```

## function getCharacter {#lang-sdf2-util-SDF2Grammar-getCharacter}

```rascal
int getCharacter(Character c)
```

## function getAttributes {#lang-sdf2-util-SDF2Grammar-getAttributes}

```rascal
set[Attr] getAttributes(Attrs as)
```

## function getAttribute {#lang-sdf2-util-SDF2Grammar-getAttribute}

```rascal
set[Attr] getAttribute(Attribute m)
```

## function getAssociativity {#lang-sdf2-util-SDF2Grammar-getAssociativity}

```rascal
Associativity getAssociativity(Assoc as)
```

## function separgs2symbols {#lang-sdf2-util-SDF2Grammar-separgs2symbols}

```rascal
list[Symbol] separgs2symbols({Sym ","}+ args, bool isLex)
```

# Tests
## test test1 {#lang-sdf2-util-SDF2Grammar-test1}

```rascal
test bool test1() = sdf2grammar(
        (SDF) `definition  module X exports context-free syntax    "abc" -\> ABC`).modules["X"].grammar.rules[sort("ABC")] ==
         choice(sort("ABC"), {prod(sort("ABC"),[lit("abc")],{})});
```

## test test2 {#lang-sdf2-util-SDF2Grammar-test2}

```rascal
test bool test2() = rs := sdf2grammar(
		(SDF) `definition
		      'module PICOID
          'exports
          'lexical syntax
          '   [a-z] [a-z0-9]* -\> PICO-ID  
          'lexical restrictions
          '  PICO-ID -/- [a-z0-9]`).modules["PICOID"].grammar.rules 
     && prod(lex("PICO-ID"),[\char-class([range(97,122)]),\conditional(\iter-star(\char-class([range(97,122),range(48,57)])),{\not-follow(\char-class([range(97,122),range(48,57)]))})],{}) == rs[lex("PICO-ID")]          
     ;
```

## test test3 {#lang-sdf2-util-SDF2Grammar-test3}

```rascal
test bool test3() = rs := sdf2grammar(
		(SDF) `definition
		      'module StrChar
          'exports
          ' lexical syntax
          '   ~[\\0-\\31\\n\\t\\"\\\\]          -\> StrChar {cons("normal")}`).modules["StrChar"].grammar.rules
     && prod(label("normal",sort("StrChar")),[\char-class([range(26,33),range(35,91),range(93,65535)])],{}) == rs[sort("StrChar")]
     ;
```

## test test4 {#lang-sdf2-util-SDF2Grammar-test4}

```rascal
test bool test4() = getProductions((SDF) `definition module A exports syntax A -\> B`) ==
     {prod(sort("B"),[sort("A")],{})};
```

## test test5 {#lang-sdf2-util-SDF2Grammar-test5}

```rascal
test bool test5() = getProductions((SDF) `definition module A exports lexical syntax A -\> B`) ==
     {prod(lex("B"),[sort("A")],{})};
```

## test test6 {#lang-sdf2-util-SDF2Grammar-test6}

```rascal
test bool test6() = getProductions((SDF) `definition module A exports lexical syntax A -\> B B -\> C`) ==
     {prod(lex("C"),[sort("B")],{}),prod(lex("B"),[sort("A")],{})};
```

## test test7 {#lang-sdf2-util-SDF2Grammar-test7}

```rascal
test bool test7() = getProductions((SDF) `definition module A exports context-free syntax A -\> B`) ==
     {prod(sort("B"),[sort("A")],{})};
```

## test test9 {#lang-sdf2-util-SDF2Grammar-test9}

```rascal
test bool test9() = getProductions((SDF) `definition module A exports priorities A -\> B \> C -\> D`) ==
     {prod(sort("B"),[sort("A")],{}),prod(sort("D"),[sort("C")],{})};
```

## test test9_2 {#lang-sdf2-util-SDF2Grammar-test9_2}

```rascal
test bool test9_2() = getProductions((SDF) `definition module A exports priorities B "*" B -\> B \> B "+" B -\> B`) ==
     {priority(sort("B"),[prod(sort("B"),[sort("B"),lit("*"),sort("B")],{}),prod(sort("B"),[sort("B"),lit("+"),sort("B")],{})])};
```

## test test10 {#lang-sdf2-util-SDF2Grammar-test10}

```rascal
test bool test10() = getProduction((Prod) `PICO-ID ":" TYPE -\> ID-TYPE`, false) == 
     {prod(sort("ID-TYPE"),[sort("PICO-ID"),lit(":"),sort("TYPE")],{})};
```

## test test11 {#lang-sdf2-util-SDF2Grammar-test11}

```rascal
test bool test11() = getProduction((Prod) `PICO-ID ":" TYPE -\> ID-TYPE`, true) == 
     {prod(lex("ID-TYPE"),[sort("PICO-ID"),lit(":"),sort("TYPE")],{})};
```

## test test12 {#lang-sdf2-util-SDF2Grammar-test12}

```rascal
test bool test12() = getProduction((Prod) `PICO-ID ":" TYPE -\> ID-TYPE {cons("decl"), left}`, false) ==
     {prod(sort("ID-TYPE"),[sort("PICO-ID"), lit(":"), sort("TYPE")],{\assoc(left())})};
```

## test test13 {#lang-sdf2-util-SDF2Grammar-test13}

```rascal
test bool test13() = getProduction((Prod) `[\\ \\t\\n\\r]	-\> LAYOUT {cons("whitespace")}`, true) == 
	 {prod(\lex("LAYOUT"),[\char-class([range(32,32),range(9,9),range(10,10),range(13,13)])],{})};
```

## test test14 {#lang-sdf2-util-SDF2Grammar-test14}

```rascal
test bool test14() = getProduction((Prod) `{~[\\n]* [\\n]}* -\> Rest`, true) ==
     {prod(sort("Rest"),[\iter-star-seps(\iter-star(\char-class([range(0,9),range(11,65535)])),[\char-class([range(10,10)])])],{})};
```

## test test18 {#lang-sdf2-util-SDF2Grammar-test18}

```rascal
test bool test18() = getRestriction((Restriction) `-/- [a-z]`, true) == {};
```

## test test19 {#lang-sdf2-util-SDF2Grammar-test19}

```rascal
test bool test19() = getRestriction((Restriction) `ID -/- [a-z]`, true) == 
     {conditional(sort("ID"),{\not-follow(\char-class([range(97,122)]))})};
```

## test test21 {#lang-sdf2-util-SDF2Grammar-test21}

```rascal
test bool test21() = getLookaheads((Lookaheads) `[a-z]`) == 
     {\char-class([range(97,122)])};
```

## test test22 {#lang-sdf2-util-SDF2Grammar-test22}

```rascal
test bool test22() = getLookaheads((Lookaheads) `[a-z] . [0-9]`) ==
     {};
```

## test test23 {#lang-sdf2-util-SDF2Grammar-test23}

```rascal
test bool test23() = getLookaheads((Lookaheads) `[a-z]  | [\\"]`) ==
     {\char-class([range(97,122)]),
      \char-class([range(34,34)])};
```

## test test24 {#lang-sdf2-util-SDF2Grammar-test24}

```rascal
test bool test24() = getPriority((Group) `A -\> B`, false) == 
     prod(sort("B"),[sort("A")],{});
```

## test test25 {#lang-sdf2-util-SDF2Grammar-test25}

```rascal
test bool test25() = getPriority((Group) `A -\> B .`, false) ==  
     prod(sort("B"),[sort("A")],{});
```

## test test26 {#lang-sdf2-util-SDF2Grammar-test26}

```rascal
test bool test26() = getPriority((Group) `A -\> B \<1\>`, false) == 
     prod(sort("B"),[sort("A")],{});
```

## test test27 {#lang-sdf2-util-SDF2Grammar-test27}

```rascal
test bool test27() = getPriority((Group) `{A -\> B C -\> D}`, false) == 
	 choice(sort("B"),{prod(sort("D"),[sort("C")],{}),prod(sort("B"),[sort("A")],{})});
```

## test test28 {#lang-sdf2-util-SDF2Grammar-test28}

```rascal
test bool test28() = getPriority((Group) `{left: A -\> B}`, false) == 
     \associativity(sort("B"),\left(),{prod(sort("B"),[sort("A")],{})});
```

## test test29 {#lang-sdf2-util-SDF2Grammar-test29}

```rascal
test bool test29() = getPriority((Group) `{left: A -\> B B -\> C}`, false) ==
     \associativity(sort("B"),\left(),{prod(sort("C"),[sort("B")],{}),prod(sort("B"),[sort("A")],{})});
```

## test test30 {#lang-sdf2-util-SDF2Grammar-test30}

```rascal
test bool test30() = getPriority((Priority) `A -\> B`, false) == 
     priority(sort("B"),[prod(sort("B"),[sort("A")],{})]);
```

## test test31 {#lang-sdf2-util-SDF2Grammar-test31}

```rascal
test bool test31() = getPriority((Priority) `A -\> B .`, false) == 
     priority(sort("B"),[prod(sort("B"),[sort("A")],{})]);
```

## test test32 {#lang-sdf2-util-SDF2Grammar-test32}

```rascal
test bool test32() = getPriority((Priority) `A -\> B \<1\>`, false) == 
     prod(sort("B"),[sort("A")],{});
```

## test test33 {#lang-sdf2-util-SDF2Grammar-test33}

```rascal
test bool test33() = getPriority((Priority) `{A -\> B C -\> D}`, false) == 
     priority(sort("B"),[choice(sort("B"),{prod(sort("D"),[sort("C")],{}),prod(sort("B"),[sort("A")],{})})]);
```

## test test34 {#lang-sdf2-util-SDF2Grammar-test34}

```rascal
test bool test34() = getPriority((Priority) `A -\> B \> C -\> D`, false) ==
     priority(sort("B"),[prod(sort("B"),[sort("A")],{}),prod(sort("D"),[sort("C")],{})]);
```

## test test35 {#lang-sdf2-util-SDF2Grammar-test35}

```rascal
test bool test35() = getPriority((Priority) `A -\> B \> C -\> D \> E -\> F`, false) ==
     priority(sort("B"),[prod(sort("B"),[sort("A")],{}),prod(sort("D"),[sort("C")],{}),prod(sort("F"),[sort("E")],{})]);
```

## test test36 {#lang-sdf2-util-SDF2Grammar-test36}

```rascal
test bool test36() = getStartSymbols((Module) `module M exports context-free start-symbols A B C`) == 
     {sort("A"), sort("B"), sort("C")};
```

## test test37 {#lang-sdf2-util-SDF2Grammar-test37}

```rascal
test bool test37() = getStartSymbols((Module) `module M exports lexical start-symbols A B C`) == 
     {sort("A"), sort("B"), sort("C")};
```

## test test38 {#lang-sdf2-util-SDF2Grammar-test38}

```rascal
test bool test38() = getStartSymbols((Module) `module M exports start-symbols A B C`) == 
     {sort("A"), sort("B"), sort("C")};
```

## test test39 {#lang-sdf2-util-SDF2Grammar-test39}

```rascal
test bool test39() = getSymbols((Syms) `A B "ab"`, true) == [sort("A"), sort("B"), lit("ab")];
```

## test test40 {#lang-sdf2-util-SDF2Grammar-test40}

```rascal
test bool test40() = getSymbol((Sym) `"abc"`, false) 		== lit("abc");
```

## test test41 {#lang-sdf2-util-SDF2Grammar-test41}

```rascal
test bool test41() = getSymbol((Sym) `"a\\\\c"`, false) 		== lit("a\\c");
```

## test test42 {#lang-sdf2-util-SDF2Grammar-test42}

```rascal
test bool test42() = getSymbol((Sym) `"a\>c"`, false) 		== lit("a\>c");
```

## test test43 {#lang-sdf2-util-SDF2Grammar-test43}

```rascal
test bool test43() = getSymbol((Sym) `ABC`, false) 			== sort("ABC");
```

## test test44 {#lang-sdf2-util-SDF2Grammar-test44}

```rascal
test bool test44() = getSymbol((Sym) `'abc'`, false) 		== cilit("abc");
```

## test test45 {#lang-sdf2-util-SDF2Grammar-test45}

```rascal
test bool test45() = getSymbol((Sym) `abc : ABC`, false) 	== label("abc",sort("ABC"));
```

## test test46 {#lang-sdf2-util-SDF2Grammar-test46}

```rascal
test bool test46() = getSymbol((Sym) `"abc" : ABC`, false) 	== label("abc",sort("ABC"));
```

## test test47 {#lang-sdf2-util-SDF2Grammar-test47}

```rascal
test bool test47() = getSymbol((Sym) `A[[B]]`, false) 		== \parameterized-sort("A", [sort("B")]);
```

## test test48 {#lang-sdf2-util-SDF2Grammar-test48}

```rascal
test bool test48() = getSymbol((Sym) `A?`, false) 			== opt(sort("A"));
```

## test test49 {#lang-sdf2-util-SDF2Grammar-test49}

```rascal
test bool test49() = getSymbol((Sym) `[a]`, false) 			== \char-class([range(97,97)]);
```

## test test50 {#lang-sdf2-util-SDF2Grammar-test50}

```rascal
test bool test50() = getSymbol((Sym) `A*`, false) 			== \iter-star-seps(sort("A"),[\layouts("LAYOUTLIST")]);
```

## test test51 {#lang-sdf2-util-SDF2Grammar-test51}

```rascal
test bool test51() = getSymbol((Sym) `A+`, false) 			== \iter-seps(sort("A"),[\layouts("LAYOUTLIST")]);
```

## test test52 {#lang-sdf2-util-SDF2Grammar-test52}

```rascal
test bool test52() = getSymbol((Sym) `A*?`, false) 			== opt(\iter-star-seps(sort("A"),[\layouts("LAYOUTLIST")]));
```

## test test53 {#lang-sdf2-util-SDF2Grammar-test53}

```rascal
test bool test53() = getSymbol((Sym) `A+?`, false) 			== opt(\iter-seps(sort("A"),[\layouts("LAYOUTLIST")]));
```

## test test54 {#lang-sdf2-util-SDF2Grammar-test54}

```rascal
test bool test54() = getSymbol((Sym) `{A "x"}*`, false) 		== \iter-star-seps(sort("A"),[\layouts("LAYOUTLIST"),lit("x"),\layouts("LAYOUTLIST")]);
```

## test test55 {#lang-sdf2-util-SDF2Grammar-test55}

```rascal
test bool test55() = getSymbol((Sym) `{A "x"}+`, false) 		== \iter-seps(sort("A"),[\layouts("LAYOUTLIST"),lit("x"),\layouts("LAYOUTLIST")]);
```

## test test56 {#lang-sdf2-util-SDF2Grammar-test56}

```rascal
test bool test56() = getSymbol((Sym) `{A "x"}*?`, false) 	== opt(\iter-star-seps(sort("A"),[\layouts("LAYOUTLIST"),lit("x"),\layouts("LAYOUTLIST")]));
```

## test test57 {#lang-sdf2-util-SDF2Grammar-test57}

```rascal
test bool test57() = getSymbol((Sym) `{A "x"}+?`, false) 	== opt(\iter-seps(sort("A"),[\layouts("LAYOUTLIST"),lit("x"),\layouts("LAYOUTLIST")]));
```

## test test58 {#lang-sdf2-util-SDF2Grammar-test58}

```rascal
test bool test58() = getSymbol((Sym) `A*`, true) 			== \iter-star(sort("A"));
```

## test test59 {#lang-sdf2-util-SDF2Grammar-test59}

```rascal
test bool test59() = getSymbol((Sym) `A+`, true) 			== \iter(sort("A"));
```

## test test60 {#lang-sdf2-util-SDF2Grammar-test60}

```rascal
test bool test60() = getSymbol((Sym) `A*?`, true) 			== opt(\iter-star(sort("A")));
```

## test test61 {#lang-sdf2-util-SDF2Grammar-test61}

```rascal
test bool test61() = getSymbol((Sym) `A+?`, true) 			== opt(\iter(sort("A")));
```

## test test62 {#lang-sdf2-util-SDF2Grammar-test62}

```rascal
test bool test62() = getSymbol((Sym) `{A "x"}*`, true) 		== \iter-star-seps(sort("A"),[lit("x")]);
```

## test test63 {#lang-sdf2-util-SDF2Grammar-test63}

```rascal
test bool test63() = getSymbol((Sym) `{A "x"}+`, true) 		== \iter-seps(sort("A"),[lit("x")]);
```

## test test64 {#lang-sdf2-util-SDF2Grammar-test64}

```rascal
test bool test64() = getSymbol((Sym) `{A "x"}*?`, true) 		== opt(\iter-star-seps(sort("A"),[lit("x")]));
```

## test test65 {#lang-sdf2-util-SDF2Grammar-test65}

```rascal
test bool test65() = getSymbol((Sym) `{A "x"}+?`, true) 		== opt(\iter-seps(sort("A"),[lit("x")]));
```

## test testUn1 {#lang-sdf2-util-SDF2Grammar-testUn1}

```rascal
test bool testUn1() = unescape((StrCon) `"abc"`)  	== "abc";
```

## test testUn2 {#lang-sdf2-util-SDF2Grammar-testUn2}

```rascal
test bool testUn2() = unescape((StrCon) `"a\\nc"`) 	== "a\nc";
```

## test testUn3 {#lang-sdf2-util-SDF2Grammar-testUn3}

```rascal
test bool testUn3() = unescape((StrCon) `"a\\"c"`) 	== "a\"c";
```

## test testUn4 {#lang-sdf2-util-SDF2Grammar-testUn4}

```rascal
test bool testUn4() = unescape((StrCon) `"a\\\\c"`) 	== "a\\c";
```

## test testUn5 {#lang-sdf2-util-SDF2Grammar-testUn5}

```rascal
test bool testUn5() = unescape((StrCon) `"a\\\\\\"c"`)	== "a\\\"c";
```

## test testUn6 {#lang-sdf2-util-SDF2Grammar-testUn6}

```rascal
test bool testUn6() = unescape((SingleQuotedStrCon) `'abc'`)  == "abc";
```

## test testUn7 {#lang-sdf2-util-SDF2Grammar-testUn7}

```rascal
test bool testUn7() = unescape((SingleQuotedStrCon) `'a\\nc'`) == "a\nc";
```

## test testUn8 {#lang-sdf2-util-SDF2Grammar-testUn8}

```rascal
test bool testUn8() = unescape((SingleQuotedStrCon) `'a\\'c'`) == "a\'c";
```

## test testUn9 {#lang-sdf2-util-SDF2Grammar-testUn9}

```rascal
test bool testUn9() = unescape((SingleQuotedStrCon) `'a\\\\c'`) == "a\\c";
```

## test un20 {#lang-sdf2-util-SDF2Grammar-un20}

```rascal
test bool un20() =unescapeStr("abc") 	== "abc";
```

## test un21 {#lang-sdf2-util-SDF2Grammar-un21}

```rascal
test bool un21() =unescapeStr("a\nbc") 	== "a\nbc";
```

## test un22 {#lang-sdf2-util-SDF2Grammar-un22}

```rascal
test bool un22() =unescapeStr("a\\\nbc") == "a\\\nbc";
```

## test un23 {#lang-sdf2-util-SDF2Grammar-un23}

```rascal
test bool un23() =unescapeStr("a\"bc") 	== "a\"bc";
```

## test un24 {#lang-sdf2-util-SDF2Grammar-un24}

```rascal
test bool un24() =unescapeStr("a\\\"bc") == "a\"bc";
```

## test un25 {#lang-sdf2-util-SDF2Grammar-un25}

```rascal
test bool un25() =unescapeStr("a\\bc") 	== "a\bc";
```

## test un26 {#lang-sdf2-util-SDF2Grammar-un26}

```rascal
test bool un26() =unescapeStr("a\\\\tc") == "a\\tc";
```

## test un27 {#lang-sdf2-util-SDF2Grammar-un27}

```rascal
test bool un27() =unescapeStr("a\>b")    == "a\>b";
```

## test un28 {#lang-sdf2-util-SDF2Grammar-un28}

```rascal
test bool un28() =unescapeStr("a\<b")    == "a\<b";
```

## test testCC1 {#lang-sdf2-util-SDF2Grammar-testCC1}

```rascal
test bool testCC1() = getCharClass((Class) `[]`)         == \char-class([]);
```

## test testCC2 {#lang-sdf2-util-SDF2Grammar-testCC2}

```rascal
test bool testCC2() = getCharClass((Class) `[a]`)        == \char-class([range(97,97)]);
```

## test testCC3 {#lang-sdf2-util-SDF2Grammar-testCC3}

```rascal
test bool testCC3() = getCharClass((Class) `[a-z]`)      == \char-class([range(97,122)]);
```

## test testCC4 {#lang-sdf2-util-SDF2Grammar-testCC4}

```rascal
test bool testCC4() = getCharClass((Class) `[a-z0-9]`)   == \char-class([range(97,122), range(48,57)]);
```

## test testCC5 {#lang-sdf2-util-SDF2Grammar-testCC5}

```rascal
test bool testCC5() = getCharClass((Class) `([a])`)      == \char-class([range(97,97)]);
```

## test testCC6 {#lang-sdf2-util-SDF2Grammar-testCC6}

```rascal
test bool testCC6() = getCharClass((Class) `~[a]`)       == complement(\char-class([range(97,97)]));
```

## test testCC7 {#lang-sdf2-util-SDF2Grammar-testCC7}

```rascal
test bool testCC7() = getCharClass((Class) `[a] /\\ [b]`) == intersection(\char-class([range(97,97)]), \char-class([range(98,98)]));
```

## test testCC8 {#lang-sdf2-util-SDF2Grammar-testCC8}

```rascal
test bool testCC8() = getCharClass((Class) `[a] \\/ [b]`) == union(\char-class([range(97,97)]), \char-class([range(98,98)]));
```

## test testCC9 {#lang-sdf2-util-SDF2Grammar-testCC9}

```rascal
test bool testCC9() = getCharClass((Class) `[a] / [b]`)  == difference(\char-class([range(97,97)]), \char-class([range(98,98)]));
```

## test testCC10 {#lang-sdf2-util-SDF2Grammar-testCC10}

```rascal
test bool testCC10() = getCharClass((Class) `[\\n]`)       == \char-class([range(10,10)]);
```

## test testCC11 {#lang-sdf2-util-SDF2Grammar-testCC11}

```rascal
test bool testCC11() = getCharClass((Class) `[\\t\\n]`)     == \char-class([range(9,9), range(10,10)]);
```

## test testCC12 {#lang-sdf2-util-SDF2Grammar-testCC12}

```rascal
test bool testCC12() = getCharClass((Class) `~[\\0-\\31\\n\\t\\"\\\\]`) ==
     complement(\char-class([range(0,25),range(10,10),range(9,9),range(34,34),range(92,92)]));
```

## test testCC13 {#lang-sdf2-util-SDF2Grammar-testCC13}

```rascal
test bool testCC13() = getCharClass((Class) `[\\"]`)       == \char-class([range(34,34)]);
```

## test testCR1 {#lang-sdf2-util-SDF2Grammar-testCR1}

```rascal
test bool testCR1() = getCharRange((Range) `a`)   	== range(97,97);
```

## test testCR2 {#lang-sdf2-util-SDF2Grammar-testCR2}

```rascal
test bool testCR2() = getCharRange((Range) `a-z`) 	== range(97,122);
```

## test testCR3 {#lang-sdf2-util-SDF2Grammar-testCR3}

```rascal
test bool testCR3() = getCharRange((Range) `\\n`)  	==  range(10,10);
```

## test testCR4 {#lang-sdf2-util-SDF2Grammar-testCR4}

```rascal
test bool testCR4() = getCharRange((Range) `\\1-\\31`)	==  range(1,25);
```

## test testAs {#lang-sdf2-util-SDF2Grammar-testAs}

```rascal
test bool testAs() = getAttributes((Attrs) `{left, cons("decl")}`) == {\assoc(\left()),\tag("cons"("decl"))};
```

## test testAs2 {#lang-sdf2-util-SDF2Grammar-testAs2}

```rascal
test bool testAs2() = getAttribute((Attribute) `left`)        == {\assoc(\left())};
```

## test testAssoc {#lang-sdf2-util-SDF2Grammar-testAssoc}

```rascal
test bool testAssoc() = getAssociativity((Assoc) `left`) == \left();
```

