---
title: "module lang::sexp::\\syntax::SExp"
id: SExp
slug: /Library/lang/sexp/syntax/SExp
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Syntax definition for S-Expressions, based on http://people.csail.mit.edu/rivest/Sexp.txt
#### Usage

```rascal
import lang::sexp::\syntax::SExp;
```

#### Dependencies
```rascal
import String;
import IO;
```


## syntax SExp {#lang-sexp-\syntax-SExp-SExp}

```rascal
start syntax SExp
  = string: String
  | \list: "(" SExp* ")"
  ;
```

## syntax String {#lang-sexp-\syntax-SExp-String}

```rascal
syntax String
  = simple: SimpleString
  | display: Display SimpleString
  ;
```

## syntax SimpleString {#lang-sexp-\syntax-SExp-SimpleString}

```rascal
syntax SimpleString
  = raw: Raw
  | token: Token
  | base64: Base64
  | hex: HexaDecimal
  | quoted: QuotedString
  ;
```

## syntax Display {#lang-sexp-\syntax-SExp-Display}

```rascal
syntax Display
  = bracket "[" SimpleString "]"
  ;
```

## syntax Raw {#lang-sexp-\syntax-SExp-Raw}

```rascal
syntax Raw
  = raw: Decimal >> [:] ":" !>> [\ \t\n\r] Bytes
  ;
```

## syntax Decimal {#lang-sexp-\syntax-SExp-Decimal}

```rascal
lexical Decimal
  = [1-9][0-9]* !>> [0-9]
  | [0]
  ;
```

## syntax Bytes {#lang-sexp-\syntax-SExp-Bytes}

```rascal
lexical Bytes
  = ![]*;
```

## syntax Token {#lang-sexp-\syntax-SExp-Token}

```rascal
lexical Token
  = TokenChar+ !>> [a-zA-Z0-9\-./_:*+=]
  ;
```

## syntax Base64 {#lang-sexp-\syntax-SExp-Base64}

```rascal
syntax Base64
  = bracket "|" Base64Char* "|" // nb: whitespace allowed
  ;
```

## syntax HexaDecimal {#lang-sexp-\syntax-SExp-HexaDecimal}

```rascal
syntax HexaDecimal
  = bracket "#" HexDigit* "#";
```

## syntax QuotedString {#lang-sexp-\syntax-SExp-QuotedString}

```rascal
lexical QuotedString
  = [\"] QSChar* [\"] 
  ;
```

## syntax QSChar {#lang-sexp-\syntax-SExp-QSChar}

```rascal
lexical QSChar
  = ![\"\'\\\n\r]
  | [\\][btvnfr\"\'\\]
  | [\\][0-7][0-7][0-7]
  | [\\][x] HexDigit HexDigit
  | [\\][\n\r]
  | [\\][\r][\n]
  | [\\][\n][\r]
  ;
```

## syntax Whitespace {#lang-sexp-\syntax-SExp-Whitespace}

```rascal
layout Whitespace
  = WS* !>> [\ \t\n\r]
  ;
```

## syntax WS {#lang-sexp-\syntax-SExp-WS}

```rascal
lexical WS
  = [\ \t\n\r]
  ;
```

## syntax TokenChar {#lang-sexp-\syntax-SExp-TokenChar}

```rascal
lexical TokenChar
  = Alpha
  | DecimalDigit
  | SimplePunc
  ;
```

## syntax Alpha {#lang-sexp-\syntax-SExp-Alpha}

```rascal
lexical Alpha
  = [a-zA-Z]
  ;
```

## syntax DecimalDigit {#lang-sexp-\syntax-SExp-DecimalDigit}

```rascal
lexical DecimalDigit
  = [0-9]
  ;
```

## syntax HexDigit {#lang-sexp-\syntax-SExp-HexDigit}

```rascal
lexical HexDigit
  = [0-9A-Fa-f]
  ;
```

## syntax SimplePunc {#lang-sexp-\syntax-SExp-SimplePunc}

```rascal
lexical SimplePunc
  = [\-./_:*+=]
  ;
```

## syntax Base64Char {#lang-sexp-\syntax-SExp-Base64Char}

```rascal
lexical Base64Char
  = Alpha
  | DecimalDigit
  | [+/=]
  ;
```

## function raw {#lang-sexp-\syntax-SExp-raw}

```rascal
Raw raw(Decimal d, Bytes bs)
```

## function unparse {#lang-sexp-\syntax-SExp-unparse}

```rascal
str unparse(Bytes _)

str unparse(Decimal _)
```

