---
title: "module lang::xml::IO"
id: IO
slug: /Library/lang/xml/IO
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

#### Usage

```rascal
import lang::xml::IO;
```



## function readXML {#lang-xml-IO-readXML}

```rascal
value readXML(loc file, bool fullyQualify=false, bool trackOrigins = false, bool includeEndTags=false, bool ignoreComments=true, bool ignoreWhitespace=true, str charset="UTF-8", bool inferCharset=!(charset?))

value readXML(str contents, loc src = |unknown:///|, bool fullyQualify=false, bool trackOrigins = false, bool includeEndTags=false, bool ignoreComments=true, bool ignoreWhitespace=true)
```

## function writeXMLString {#lang-xml-IO-writeXMLString}

Pretty-print any value as an XML string

```rascal
str writeXMLString(value val, str charset="UTF-8", bool outline=false, bool prettyPrint=true, int indentAmount=4, int maxPaddingWidth=30, bool dropOrigins=true)
```


This function uses [JSoup's](http://www.jsoup.org) DOM functionality to 
yield a syntactically correct XML string.

## function writeXMLFile {#lang-xml-IO-writeXMLFile}

Pretty-print any value to an XML file

```rascal
void writeXMLFile(loc file, value val, str charset="UTF-8", bool outline=false, bool prettyPrint=true, int indentAmount=4, int maxPaddingWidth=30, bool dropOrigins=true)
```


This function uses [JSoup's](http://www.jsoup.org) DOM functionality to 
yield a syntactically correct (X)HTML file.

# Tests
## test nestedElementTest {#lang-xml-IO-nestedElementTest}

```rascal
test bool nestedElementTest() {
  example = "\<aap\>\<noot\>mies\</noot\>\</aap\>";
  
  val = readXML(example);
  
  return val == "aap"("noot"("mies"));
}
```

## test attributeTest {#lang-xml-IO-attributeTest}

```rascal
test bool attributeTest() {
  example = "\<aap age=\"1\"\>\</aap\>";
  
  val = readXML(example);
  
  return val == "aap"(age="1");
}
```

## test namespaceTest {#lang-xml-IO-namespaceTest}

```rascal
test bool namespaceTest() {
  example = "\<aap xmlns:ns=\"http://trivial\" ns:age=\"1\" age=\"2\"\>\</aap\>";
  
  val = readXML(example);
  
  return "aap"(\ns-age="1", age="2") := val;
}
```

