---
title: "module util::FileSystem"
id: FileSystem
slug: /Library/util/FileSystem
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

#### Usage

```rascal
import util::FileSystem;
```

#### Dependencies
```rascal
import IO;
```


## data FileSystem {#util-FileSystem-FileSystem}

```rascal
data FileSystem  
     = directory(loc l, set[FileSystem] children)
     | file(loc l)
     ;
```

## function crawl {#util-FileSystem-crawl}

```rascal
FileSystem crawl(loc l)
```

## function files {#util-FileSystem-files}

Recursively lists locations of all files from the supplied directory.
  If input is a file, its location is returned instead.

```rascal
set[loc] files(loc l)
```

## function find {#util-FileSystem-find}

Recursively lists locations of all files that satisfy the filter criterion `filt`.
  For a file to be included, `filt` must return `true` for it.

```rascal
set[loc] find(loc f, bool (loc) filt)
```

## function find {#util-FileSystem-find}

Recursively lists locations of all files that end in `ext`.

```rascal
set[loc] find(loc f, str ext)
```

## function visibleFiles {#util-FileSystem-visibleFiles}

Lists all files recursively ignored files and directories starting with a dot.

```rascal
set[loc] visibleFiles(loc l)
```

