---
title: "module util::IDEServices"
id: IDEServices
slug: /Library/util/IDEServices
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

#### Usage

```rascal
import util::IDEServices;
```

#### Dependencies
```rascal
extend analysis::diff::edits::TextEdits;
import analysis::diff::edits::ExecuteTextEdits;
extend Content;
extend Message;
```


## function browse {#util-IDEServices-browse}

Open a browser for a given location.

```rascal
void browse(loc uri, str title = "<uri>", int viewColumn=1)
```

## function edit {#util-IDEServices-edit}

Open an editor for file at a given location.

```rascal
void edit(loc uri)
```

## function applyDocumentsEdits {#util-IDEServices-applyDocumentsEdits}

Let the IDE apply a list of document edits.

```rascal
void applyDocumentsEdits(list[DocumentEdit] edits)
```


Asks the IDE to apply document edits as defined in the standard library module
analysis::diff::edits::TextEdits, according to the semantics defined in
analysis::diff::edits::ExecuteTextEdits. However, the IDE can take care of these
changes in order to provide important UI experience features such as "preview"
and "undo". 

Typically a call to this IDE service method is included in the implementation
of refactoring and quick-fix features of the language service protocol.

## function showInteractiveContent {#util-IDEServices-showInteractiveContent}

Asks the IDE to show a "browser window" with the given interactive Content.

```rascal
void showInteractiveContent(Content content, str title=content.title, int viewColumn=content.viewColumn)
```

## function showMessage {#util-IDEServices-showMessage}

```rascal
void showMessage(Message message)
```

## function logMessage {#util-IDEServices-logMessage}

```rascal
void logMessage(Message message)
```

## function registerDiagnostics {#util-IDEServices-registerDiagnostics}

```rascal
void registerDiagnostics(list[Message] messages)
```

## function unregisterDiagnostics {#util-IDEServices-unregisterDiagnostics}

```rascal
void unregisterDiagnostics(list[loc] resources)
```

## data Message {#util-IDEServices-Message}
Fixes are an extension to error messages that allow for interactive code fixes in the IDE.

```rascal
data Message (list[CodeAction] fixes = [])
```


This definition adds lists of [Code Action](../..//Library/util/IDEServices.md#util-IDEServices-CodeAction)s as optional fields to any message. In collaboration
with a language server, these messages then lead to interactive quick fixes in IDEs.

## data CodeAction {#util-IDEServices-CodeAction}
Code actions bundle synchronous text edits and command execution with a title for the menu option.

```rascal
data CodeAction  
     = action(list[DocumentEdit] edits = [], Command command = noop(), str title = command.title)
     ;
```


For any action instance, the IDE will:
* show a menu option with the given title.
* if the title is selected, then the (optional) edits will be executed first
* and then the (optional) command is executed via the `execution` service of the language service protocol.

## data Command {#util-IDEServices-Command}
Commands are an open data-type for describing interactive functions that may be attached to CodeActions.

```rascal
data Command (str title="") 
     = noop()
     ;
```


Commands are simply immutable constructors with parameters. To use a command you can attach it to a [Message](../..//Library/Message.md)
via a [Code Action](../..//Library/util/IDEServices.md#util-IDEServices-CodeAction), and then have it executed by the respective language server.

## function testCodeAction {#util-IDEServices-testCodeAction}

Utility function for testing code actions.

```rascal
value testCodeAction(CodeAction action, value (Command _) evaluator = value (noop()) { return true; })
```


* `action` is the action to execute
* `evaluator` is used to evaluate action.command if it is present.
* the return value is the return value of the evaluated command, or `true` if no command is present.

#### Benefits


* test code actions outside of the IDE context, for example while running unit tests.
* this function is synchronous and blocks until the IO is finished. After running it you
can test for changed file contents without waiting, in most cases (see pitfalls).

#### Pitfalls


* [Code Action](../..//Library/util/IDEServices.md#util-IDEServices-CodeAction)s may use the other features of [IDEServices](../..//Library/util/IDEServices.md), and thus start editors or browsers as side-effects.
* [Code Action](../..//Library/util/IDEServices.md#util-IDEServices-CodeAction)s code actions with [Document Edit](../..//Library/analysis/diff/edits/TextEdits.md#analysis-diff-edits-TextEdits-DocumentEdit)s will write to disk and change the original files.
* [Command](../..//Library/util/IDEServices.md#util-IDEServices-Command)s can only be executed by a parametrized command `evaluator``; if you do not provide it then 
this test function will throw [Call Failed](../..//Library/Exception.md#Exception-CallFailed) exceptions for every unsupported ([Command](../..//Library/util/IDEServices.md#util-IDEServices-Command).
* ([Command](../..//Library/util/IDEServices.md#util-IDEServices-Command)s can start asynchronous effects by calling non-blocking functions that schedule other effects.
An example is the starting and running of web [Content](../..//Library/Content.md) via [Show Interactive Content](../..//Library/util/IDEServices.md#util-IDEServices-showInteractiveContent). Testing properties of the
rendered content will require the use of asynchronous testing frameworks, like Selenium. 
* Never call [Test Code Action](../..//Library/util/IDEServices.md#util-IDEServices-testCodeAction) to execute actions in an interactive context. That must be done by the IDE client
to synchronize the contents of editors and parse trees, etc. This function is only for unit testing code actions.

