---
title: "module util::REPL"
id: REPL
slug: /Library/util/REPL
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

#### Usage

```rascal
import util::REPL;
```

#### Dependencies
```rascal
extend Content;
```


## alias Completion {#util-REPL-Completion}

```rascal
map[str completion, str group]
```

## data REPL {#util-REPL-REPL}

```rascal
data REPL  
     = repl(
     str title = "", 
     str welcome = "", 
     str prompt = "\n\>",
     str quit = "", 
     loc history = |home:///.term-repl-history|, 
     Content (str command) handler = echo,
     Completion(str line, str word) completor = noSuggestions,
     str () stacktrace = str () { return ""; }
   )
     ;
```

## function echo {#util-REPL-echo}

```rascal
Content echo(str line)
```

## function noSuggestions {#util-REPL-noSuggestions}

```rascal
Completion noSuggestions(str _, str _)
```

## alias Terminal {#util-REPL-Terminal}

```rascal
tuple[void() run, void(str) send]
```

## function newREPL {#util-REPL-newREPL}

```rascal
Terminal newREPL(REPL repl, 
  
  // filling in defaults from the repl constructor, for use in the Java code:
  str title = repl.title, 
  str welcome = repl.welcome, 
  str prompt = repl.prompt, 
  str quit = repl.quit,
  loc history = repl.history,
  Content (str ) handler = repl.handler,
  Completion(str , str) completor = repl.completor,
  str () stacktrace = repl.stacktrace)
```

## function startREPL {#util-REPL-startREPL}

```rascal
void startREPL(REPL repl, 
  
  // filling in defaults from the repl constructor, for use in the Java code:
  str title = repl.title, 
  str welcome = repl.welcome, 
  str prompt = repl.prompt, 
  str quit = repl.quit,
  loc history = repl.history,
  Content (str ) handler = repl.handler,
  Completion(str , str) completor = repl.completor,
  str () stacktrace = repl.stacktrace)
```

