---
title: "module util::Test"
id: Test
slug: /Library/util/Test
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Provides occasionally useful access to Rascal's testing framework
#### Usage

```rascal
import util::Test;
```



Rascal's test framework can normally be accessed via UI and commandline interfaces:

  * Running as JUnit tests in IDEs
  * Running as JUnit tests from Maven
  * Executing the `:test` command in a Rascal REPL
  
This module provides a programmatic interface, and reports the test results
as values. It can be handy to construct more UI components which interact
with tests, but also to query larger volumes of failing tests.


## data TestResult {#util-Test-TestResult}

```rascal
data TestResult  
     = \testResult(str name, bool success, loc src, str message = "", list[value] exceptions = [])
     ;
```

## function runTests {#util-Test-runTests}

Run all tests for the given module name

```rascal
list[TestResult] runTests(str moduleName)
```


This function works under the assumption that the named module is available in the current execution environment.

# Tests
## test testTest {#util-Test-testTest}

```rascal
private test bool testTest() = true;
```

