---
title: "module util::Webserver"
id: Webserver
slug: /Library/util/Webserver
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

#### Usage

```rascal
import util::Webserver;
```

#### Dependencies
```rascal
extend Content;
```


## function serve {#util-Webserver-serve}

```rascal
void serve(loc server, Response (Request) callback, bool asDaemon = true)
```

## function shutdown {#util-Webserver-shutdown}

```rascal
void shutdown(loc server)
```

# Tests
## test testWebServer {#util-Webserver-testWebServer}

```rascal
test bool testWebServer() {
   loc testLoc = |http://localhost:10001|;
   
   // simple get
   // Response testServer(get("/hello")) = response("hello world!");
   Response testServer(p:post("/upload8", value (type[value] _) stuff)) = response("uploaded: <p.parameters["firstname"]> <stuff(#value)>");   
   
   try {
      serve(testLoc, testServer);
      return true;
   }
   catch value exception:
     throw exception;
   finally {
     shutdown(testLoc);
   }
}
```

