/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.fields;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableMap;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public abstract class AbstractDefaultWithKeywordParameters<T extends IValue>
implements IWithKeywordParameters<T> {
    protected final T content;
    protected final Map.Immutable<String, IValue> parameters;

    public AbstractDefaultWithKeywordParameters(T content, Map.Immutable<String, IValue> parameters) {
        this.content = content;
        this.parameters = parameters;
    }

    protected abstract T wrap(T var1, Map.Immutable<String, IValue> var2);

    public String toString() {
        return this.content.toString();
    }

    @Override
    public @Nullable IValue getParameter(String label) {
        return (IValue)this.parameters.get(label);
    }

    @Override
    public T setParameter(String label, IValue newValue) {
        return this.wrap(this.content, this.parameters.__put(label, newValue));
    }

    @Override
    public T unsetParameter(String label) {
        Map.Immutable<String, IValue> removed = this.parameters.__remove(label);
        if (removed.isEmpty()) {
            return this.content;
        }
        return this.wrap(this.content, removed);
    }

    @Override
    public T unsetAll() {
        return this.content;
    }

    @Override
    @Pure
    public boolean hasParameter(String label) {
        return this.parameters.containsKey(label);
    }

    @Override
    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    @Override
    @Pure
    public Set<String> getParameterNames() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }

    @Override
    public Map<String, IValue> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public int hashCode() {
        return 91 + this.content.hashCode() * 13 + 101 * this.parameters.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AbstractDefaultWithKeywordParameters o = (AbstractDefaultWithKeywordParameters)other;
        if (!this.content.equals(o.content)) {
            return false;
        }
        if (this.parameters.size() != o.parameters.size()) {
            return false;
        }
        for (String key : this.parameters.keySet()) {
            if (((IValue)this.parameters.get(key)).equals(o.getParameter(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public <U extends IWithKeywordParameters<? extends IValue>> boolean equalParameters(U other) {
        if (!(other instanceof AbstractDefaultWithKeywordParameters)) {
            return false;
        }
        AbstractDefaultWithKeywordParameters o = (AbstractDefaultWithKeywordParameters)other;
        if (this.parameters.size() != o.parameters.size()) {
            return false;
        }
        for (String key : this.parameters.keySet()) {
            IValue parameter = this.getParameter(key);
            if (parameter == null && o.getParameter(key) != null) {
                return false;
            }
            if (parameter == null || parameter.equals(o.getParameter(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public T setParameters(Map<String, IValue> params) {
        if (params.isEmpty()) {
            return this.content;
        }
        return this.wrap(this.content, AbstractSpecialisedImmutableMap.mapOf(params));
    }

    public Map.Immutable<String, IValue> internalGetParameters() {
        return this.parameters;
    }
}

