/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableMap;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.impl.fields.AbstractDefaultWithKeywordParameters;
import io.usethesource.vallang.impl.fields.ConstructorWithKeywordParametersFacade;
import io.usethesource.vallang.impl.persistent.Node;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

class Constructor {
    private static final LoadingCache<Type, IConstructor> EMPTY_CONSTRUCTOR_SINGLETONS = Caffeine.newBuilder().build(Constructor0::new);

    Constructor() {
    }

    static IConstructor newConstructor(Type constructorType, IValue[] children) {
        assert (IConstructor.assertTypeCorrectConstructorApplication(constructorType, children));
        if (constructorType.isParameterized()) {
            return new TypeParameterizedConstructorN(constructorType, children);
        }
        switch (children.length) {
            case 0: {
                return Constructor.nonNull(EMPTY_CONSTRUCTOR_SINGLETONS.get(constructorType));
            }
            case 1: {
                return new Constructor1(constructorType, children[0]);
            }
            case 2: {
                return new Constructor2(constructorType, children[0], children[1]);
            }
            case 3: {
                return new Constructor3(constructorType, children[0], children[1], children[2]);
            }
            case 4: {
                return new Constructor4(constructorType, children[0], children[1], children[2], children[3]);
            }
            case 5: {
                return new Constructor5(constructorType, children[0], children[1], children[2], children[3], children[4]);
            }
            case 6: {
                return new Constructor6(constructorType, children[0], children[1], children[2], children[3], children[4], children[5]);
            }
            case 7: {
                return new Constructor7(constructorType, children[0], children[1], children[2], children[3], children[4], children[5], children[6]);
            }
        }
        return new ConstructorN(constructorType, children);
    }

    private static <T> T nonNull(@Nullable T value) {
        if (value == null) {
            throw new RuntimeException("Unexpected null value");
        }
        return value;
    }

    static IConstructor newConstructor(Type constructorType, IValue[] children, Map<String, IValue> kwParams) {
        IConstructor r = Constructor.newConstructor(constructorType, children);
        if (kwParams != null && !kwParams.isEmpty()) {
            return r.asWithKeywordParameters().setParameters(kwParams);
        }
        return r;
    }

    private static class TypeParameterizedConstructorN
    extends ConstructorN {
        private final Type uninstantiatedConstructorType;

        public TypeParameterizedConstructorN(Type constructorType, IValue[] children) {
            super(TypeParameterizedConstructorN.instantiate(constructorType, children), children);
            assert (constructorType.isParameterized());
            this.uninstantiatedConstructorType = constructorType;
        }

        private static Type instantiate(Type constructorType, IValue[] children) {
            Type[] actualTypes = new Type[constructorType.getArity()];
            int i = 0;
            for (IValue child : children) {
                actualTypes[i++] = child.getType();
            }
            HashMap<Type, Type> bindings = new HashMap<Type, Type>();
            constructorType.getFieldTypes().match(TypeFactory.getInstance().tupleType(actualTypes), bindings);
            for (Type field : constructorType.getAbstractDataType().getTypeParameters()) {
                if (bindings.containsKey(field)) continue;
                bindings.put(field, TypeFactory.getInstance().voidType());
            }
            return constructorType.instantiate(bindings);
        }

        @Override
        public Type getUninstantiatedConstructorType() {
            return this.uninstantiatedConstructorType;
        }
    }

    private static class ConstructorN
    extends AbstractConstructor {
        protected final IValue[] children;

        public ConstructorN(Type constructorType, IValue[] children) {
            super(constructorType);
            this.children = children;
        }

        @Override
        public int arity() {
            return this.children.length;
        }

        @Override
        public Iterator<IValue> iterator() {
            return Arrays.stream(this.children).iterator();
        }

        @Override
        public IValue get(int i) {
            return this.children[i];
        }

        @Override
        public IConstructor set(int index, IValue newArg) {
            IValue[] newChildren = new IValue[this.children.length];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            newChildren[index] = newArg;
            return new ConstructorN(this.constructorType, newChildren);
        }
    }

    private static class Constructor7
    extends AbstractConstructor {
        private final IValue arg1;
        private final IValue arg2;
        private final IValue arg3;
        private final IValue arg4;
        private final IValue arg5;
        private final IValue arg6;
        private final IValue arg7;

        public Constructor7(Type constructorType, IValue arg1, IValue arg2, IValue arg3, IValue arg4, IValue arg5, IValue arg6, IValue arg7) {
            super(constructorType);
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
            this.arg5 = arg5;
            this.arg6 = arg6;
            this.arg7 = arg7;
        }

        @Override
        public int arity() {
            return 7;
        }

        @Override
        public IValue get(int index) {
            switch (index) {
                case 0: {
                    return this.arg1;
                }
                case 1: {
                    return this.arg2;
                }
                case 2: {
                    return this.arg3;
                }
                case 3: {
                    return this.arg4;
                }
                case 4: {
                    return this.arg5;
                }
                case 5: {
                    return this.arg6;
                }
                case 6: {
                    return this.arg7;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public IConstructor set(int index, IValue newArg) {
            switch (index) {
                case 0: {
                    return new Constructor7(this.constructorType, newArg, this.arg2, this.arg3, this.arg4, this.arg5, this.arg6, this.arg7);
                }
                case 1: {
                    return new Constructor7(this.constructorType, this.arg1, newArg, this.arg3, this.arg4, this.arg5, this.arg6, this.arg7);
                }
                case 2: {
                    return new Constructor7(this.constructorType, this.arg1, this.arg2, newArg, this.arg4, this.arg5, this.arg6, this.arg7);
                }
                case 3: {
                    return new Constructor7(this.constructorType, this.arg1, this.arg2, this.arg3, newArg, this.arg5, this.arg6, this.arg7);
                }
                case 4: {
                    return new Constructor7(this.constructorType, this.arg1, this.arg2, this.arg3, this.arg4, newArg, this.arg6, this.arg7);
                }
                case 5: {
                    return new Constructor7(this.constructorType, this.arg1, this.arg2, this.arg3, this.arg4, this.arg5, newArg, this.arg7);
                }
                case 6: {
                    return new Constructor7(this.constructorType, this.arg1, this.arg2, this.arg3, this.arg4, this.arg5, this.arg6, newArg);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Constructor7 otherTree = (Constructor7)o;
            if (this.constructorType != otherTree.constructorType) {
                return false;
            }
            return Objects.equals(this.arg1, otherTree.arg1) && Objects.equals(this.arg2, otherTree.arg2) && Objects.equals(this.arg3, otherTree.arg3) && Objects.equals(this.arg4, otherTree.arg4) && Objects.equals(this.arg5, otherTree.arg5) && Objects.equals(this.arg6, otherTree.arg6) && Objects.equals(this.arg7, otherTree.arg7);
        }
    }

    private static class Constructor6
    extends AbstractConstructor {
        private final IValue arg1;
        private final IValue arg2;
        private final IValue arg3;
        private final IValue arg4;
        private final IValue arg5;
        private final IValue arg6;

        public Constructor6(Type constructorType, IValue arg1, IValue arg2, IValue arg3, IValue arg4, IValue arg5, IValue arg6) {
            super(constructorType);
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
            this.arg5 = arg5;
            this.arg6 = arg6;
        }

        @Override
        public int arity() {
            return 6;
        }

        @Override
        public IValue get(int index) {
            switch (index) {
                case 0: {
                    return this.arg1;
                }
                case 1: {
                    return this.arg2;
                }
                case 2: {
                    return this.arg3;
                }
                case 3: {
                    return this.arg4;
                }
                case 4: {
                    return this.arg5;
                }
                case 5: {
                    return this.arg6;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public IConstructor set(int index, IValue newArg) {
            switch (index) {
                case 0: {
                    return new Constructor6(this.constructorType, newArg, this.arg2, this.arg3, this.arg4, this.arg5, this.arg6);
                }
                case 1: {
                    return new Constructor6(this.constructorType, this.arg1, newArg, this.arg3, this.arg4, this.arg5, this.arg6);
                }
                case 2: {
                    return new Constructor6(this.constructorType, this.arg1, this.arg2, newArg, this.arg4, this.arg5, this.arg6);
                }
                case 3: {
                    return new Constructor6(this.constructorType, this.arg1, this.arg2, this.arg3, newArg, this.arg5, this.arg6);
                }
                case 4: {
                    return new Constructor6(this.constructorType, this.arg1, this.arg2, this.arg3, this.arg4, newArg, this.arg6);
                }
                case 5: {
                    return new Constructor6(this.constructorType, this.arg1, this.arg2, this.arg3, this.arg4, this.arg5, newArg);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Constructor6 otherTree = (Constructor6)o;
            if (this.constructorType != otherTree.constructorType) {
                return false;
            }
            return Objects.equals(this.arg1, otherTree.arg1) && Objects.equals(this.arg2, otherTree.arg2) && Objects.equals(this.arg3, otherTree.arg3) && Objects.equals(this.arg4, otherTree.arg4) && Objects.equals(this.arg5, otherTree.arg5) && Objects.equals(this.arg6, otherTree.arg6);
        }
    }

    private static class Constructor5
    extends AbstractConstructor {
        private final IValue arg1;
        private final IValue arg2;
        private final IValue arg3;
        private final IValue arg4;
        private final IValue arg5;

        public Constructor5(Type constructorType, IValue arg1, IValue arg2, IValue arg3, IValue arg4, IValue arg5) {
            super(constructorType);
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
            this.arg5 = arg5;
        }

        @Override
        public int arity() {
            return 5;
        }

        @Override
        public IValue get(int index) {
            switch (index) {
                case 0: {
                    return this.arg1;
                }
                case 1: {
                    return this.arg2;
                }
                case 2: {
                    return this.arg3;
                }
                case 3: {
                    return this.arg4;
                }
                case 4: {
                    return this.arg5;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public IConstructor set(int index, IValue newArg) {
            switch (index) {
                case 0: {
                    return new Constructor5(this.constructorType, newArg, this.arg2, this.arg3, this.arg4, this.arg5);
                }
                case 1: {
                    return new Constructor5(this.constructorType, this.arg1, newArg, this.arg3, this.arg4, this.arg5);
                }
                case 2: {
                    return new Constructor5(this.constructorType, this.arg1, this.arg2, newArg, this.arg4, this.arg5);
                }
                case 3: {
                    return new Constructor5(this.constructorType, this.arg1, this.arg2, this.arg3, newArg, this.arg5);
                }
                case 4: {
                    return new Constructor5(this.constructorType, this.arg1, this.arg2, this.arg3, this.arg4, newArg);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Constructor5 otherTree = (Constructor5)o;
            if (this.constructorType != otherTree.constructorType) {
                return false;
            }
            return Objects.equals(this.arg1, otherTree.arg1) && Objects.equals(this.arg2, otherTree.arg2) && Objects.equals(this.arg3, otherTree.arg3) && Objects.equals(this.arg4, otherTree.arg4) && Objects.equals(this.arg5, otherTree.arg5);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class Constructor4
    extends AbstractConstructor {
        private final IValue arg1;
        private final IValue arg2;
        private final IValue arg3;
        private final IValue arg4;

        public Constructor4(Type constructorType, IValue arg1, IValue arg2, IValue arg3, IValue arg4) {
            super(constructorType);
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
        }

        @Override
        public int arity() {
            return 4;
        }

        @Override
        public IValue get(int index) {
            switch (index) {
                case 0: {
                    return this.arg1;
                }
                case 1: {
                    return this.arg2;
                }
                case 2: {
                    return this.arg3;
                }
                case 3: {
                    return this.arg4;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public IConstructor set(int index, IValue newArg) {
            switch (index) {
                case 0: {
                    return new Constructor4(this.constructorType, newArg, this.arg2, this.arg3, this.arg4);
                }
                case 1: {
                    return new Constructor4(this.constructorType, this.arg1, newArg, this.arg3, this.arg4);
                }
                case 2: {
                    return new Constructor4(this.constructorType, this.arg1, this.arg2, newArg, this.arg4);
                }
                case 3: {
                    return new Constructor4(this.constructorType, this.arg1, this.arg2, this.arg3, newArg);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Constructor4 otherTree = (Constructor4)o;
            if (this.constructorType != otherTree.constructorType) {
                return false;
            }
            return Objects.equals(this.arg1, otherTree.arg1) && Objects.equals(this.arg2, otherTree.arg2) && Objects.equals(this.arg3, otherTree.arg3) && Objects.equals(this.arg4, otherTree.arg4);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class Constructor3
    extends AbstractConstructor {
        private final IValue arg1;
        private final IValue arg2;
        private final IValue arg3;

        public Constructor3(Type constructorType, IValue arg1, IValue arg2, IValue arg3) {
            super(constructorType);
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }

        @Override
        public int arity() {
            return 3;
        }

        @Override
        public IValue get(int index) {
            switch (index) {
                case 0: {
                    return this.arg1;
                }
                case 1: {
                    return this.arg2;
                }
                case 2: {
                    return this.arg3;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public IConstructor set(int index, IValue newArg) {
            switch (index) {
                case 0: {
                    return new Constructor3(this.constructorType, newArg, this.arg2, this.arg3);
                }
                case 1: {
                    return new Constructor3(this.constructorType, this.arg1, newArg, this.arg3);
                }
                case 2: {
                    return new Constructor3(this.constructorType, this.arg1, this.arg2, newArg);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Constructor3 otherTree = (Constructor3)o;
            if (this.constructorType != otherTree.constructorType) {
                return false;
            }
            return Objects.equals(this.arg1, otherTree.arg1) && Objects.equals(this.arg2, otherTree.arg2) && Objects.equals(this.arg3, otherTree.arg3);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class Constructor2
    extends AbstractConstructor {
        private final IValue arg1;
        private final IValue arg2;

        public Constructor2(Type constructorType, IValue arg1, IValue arg2) {
            super(constructorType);
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        @Override
        public int arity() {
            return 2;
        }

        @Override
        public IValue get(int index) {
            switch (index) {
                case 0: {
                    return this.arg1;
                }
                case 1: {
                    return this.arg2;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public IConstructor set(int index, IValue newArg) {
            switch (index) {
                case 0: {
                    return new Constructor2(this.constructorType, newArg, this.arg2);
                }
                case 1: {
                    return new Constructor2(this.constructorType, this.arg1, newArg);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Constructor2 otherTree = (Constructor2)o;
            if (this.constructorType != otherTree.constructorType) {
                return false;
            }
            return Objects.equals(this.arg1, otherTree.arg1) && Objects.equals(this.arg2, otherTree.arg2);
        }
    }

    private static class Constructor1
    extends AbstractConstructor {
        private final IValue arg1;

        public Constructor1(Type constructorType, IValue arg1) {
            super(constructorType);
            this.arg1 = arg1;
        }

        @Override
        public int arity() {
            return 1;
        }

        @Override
        public IValue get(int index) {
            switch (index) {
                case 0: {
                    return this.arg1;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public IConstructor set(int index, IValue newArg) {
            switch (index) {
                case 0: {
                    return new Constructor1(this.constructorType, newArg);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Constructor1 otherTree = (Constructor1)o;
            if (this.constructorType != otherTree.constructorType) {
                return false;
            }
            return Objects.equals(this.arg1, otherTree.arg1);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class Constructor0
    extends AbstractConstructor {
        public Constructor0(Type constructorType) {
            super(constructorType);
        }

        @Override
        public int arity() {
            return 0;
        }

        @Override
        public Iterator<IValue> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public int hashCode() {
            return this.constructorType.hashCode();
        }

        @Override
        public IValue get(int arg0) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public IConstructor set(int arg0, IValue arg1) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public IConstructor set(String arg0, IValue arg1) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean equals(@Nullable Object o) {
            return o == this;
        }

        @Override
        public boolean match(IValue value) {
            return value == this || value instanceof IConstructor && ((IConstructor)value).arity() == 0 && ((IConstructor)value).getConstructorType() == this.constructorType;
        }
    }

    private static abstract class AbstractConstructor
    implements IConstructor {
        protected final Type constructorType;
        private int hashCode;

        public AbstractConstructor(Type constructorType) {
            this.constructorType = constructorType;
        }

        @Override
        public INode setChildren(IValue[] childArray) {
            return new Node(this.constructorType.getName(), childArray);
        }

        @Override
        public IConstructor set(String label, IValue arg) {
            return this.set(this.constructorType.getFieldIndex(label), arg);
        }

        @Override
        public Iterable<IValue> getChildren() {
            return this;
        }

        @Override
        public IConstructor replace(int first, int second, int end, IList repl) {
            throw new UnsupportedOperationException("Replace not supported on constructor.");
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.constructorType.hashCode();
                for (int i = this.arity() - 1; i >= 0; --i) {
                    this.hashCode = (this.hashCode << 23) + (this.hashCode >> 5);
                    this.hashCode ^= this.get(i).hashCode();
                }
            }
            return this.hashCode;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() == this.getClass()) {
                AbstractConstructor otherTree = (AbstractConstructor)o;
                if (this.constructorType != otherTree.constructorType) {
                    return false;
                }
                Iterator<IValue> children = this.iterator();
                Iterator<IValue> other = otherTree.iterator();
                while (children.hasNext() && other.hasNext()) {
                    if (children.next().equals(other.next())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return this.defaultToString();
        }

        @Override
        public boolean has(String label) {
            return this.getConstructorType().hasField(label);
        }

        public IWithKeywordParameters<IConstructor> asWithKeywordParameters() {
            return new AbstractDefaultWithKeywordParameters<IConstructor>((IConstructor)this, AbstractSpecialisedImmutableMap.mapOf()){

                @Override
                protected IConstructor wrap(IConstructor content, Map.Immutable<String, IValue> parameters) {
                    return new ConstructorWithKeywordParametersFacade(content, parameters);
                }

                @Override
                public boolean hasParameters() {
                    return false;
                }

                @Override
                public Set<String> getParameterNames() {
                    return Collections.emptySet();
                }

                @Override
                public Map<String, IValue> getParameters() {
                    return Collections.unmodifiableMap(this.parameters);
                }
            };
        }

        @Override
        public IValue get(String label) {
            return this.get(this.constructorType.getFieldIndex(label));
        }

        @Override
        public String getName() {
            return this.constructorType.getName();
        }

        @Override
        public Type getUninstantiatedConstructorType() {
            return this.constructorType;
        }

        @Override
        public Type getType() {
            return this.getConstructorType().getAbstractDataType();
        }

        @Override
        public Iterator<IValue> iterator() {
            return new Iterator<IValue>(){
                private final int max;
                private int cur;
                {
                    this.max = this.arity();
                    this.cur = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.cur != this.max;
                }

                @Override
                public IValue next() {
                    IValue res = this.get(this.cur);
                    ++this.cur;
                    return res;
                }
            };
        }

        @Override
        public Type getConstructorType() {
            return this.constructorType;
        }

        @Override
        public Type getChildrenTypes() {
            return this.constructorType.getFieldTypes();
        }

        @Override
        public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
            return v.visitConstructor(this);
        }
    }
}

