/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.capsule.Map;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.impl.persistent.PersistentHashMap;
import io.usethesource.vallang.impl.persistent.ValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.util.AbstractTypeBag;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class MapWriter
implements IMapWriter {
    private AbstractTypeBag keyTypeBag = AbstractTypeBag.of(new Type[0]);
    private AbstractTypeBag valTypeBag = AbstractTypeBag.of(new Type[0]);
    private final Map.Transient<IValue, IValue> mapContent = Map.Transient.of();
    private @MonotonicNonNull IMap constructedMap;

    MapWriter() {
    }

    @Override
    public void put(IValue key, IValue value) {
        this.checkMutation();
        Type keyType = key.getType();
        Type valType = value.getType();
        int oldSize = this.mapContent.size();
        IValue replaced = this.mapContent.__put(key, value);
        if (oldSize != this.mapContent.size() || replaced != null) {
            if (replaced != null) {
                this.valTypeBag = this.valTypeBag.decrease(replaced.getType()).increase(valType);
            } else {
                this.keyTypeBag = this.keyTypeBag.increase(keyType);
                this.valTypeBag = this.valTypeBag.increase(valType);
            }
        }
        assert (this.mapContent.size() == this.keyTypeBag.sum());
    }

    @Override
    public void putAll(IMap map) {
        this.putAll(map.entryIterator());
    }

    @Override
    public void putAll(Map<IValue, IValue> map) {
        this.putAll(map.entrySet().iterator());
    }

    private void putAll(Iterator<Map.Entry<IValue, IValue>> entryIterator) {
        this.checkMutation();
        while (entryIterator.hasNext()) {
            Map.Entry<IValue, IValue> entry = entryIterator.next();
            IValue key = entry.getKey();
            IValue value = entry.getValue();
            this.put(key, value);
        }
    }

    @Override
    public void insert(IValue ... values) {
        this.insertAll(Arrays.asList(values));
    }

    @Override
    public void insertAll(Iterable<? extends IValue> collection) {
        this.checkMutation();
        for (IValue iValue : collection) {
            if (!(iValue instanceof ITuple)) {
                throw new IllegalArgumentException("Argument must be of ITuple type.");
            }
            ITuple tuple = (ITuple)iValue;
            if (tuple.arity() != 2) {
                throw new IllegalArgumentException("Tuple must have an arity of 2.");
            }
            this.put(tuple.get(0), tuple.get(1));
        }
    }

    protected void checkMutation() {
        if (this.constructedMap != null) {
            throw new UnsupportedOperationException("Mutation of a finalized map is not supported.");
        }
    }

    @Override
    public IMap done() {
        if (this.constructedMap == null) {
            this.constructedMap = new PersistentHashMap(this.keyTypeBag, this.valTypeBag, this.mapContent.freeze());
        }
        return this.constructedMap;
    }

    @Override
    public void insertTuple(IValue ... fields) {
        this.insert(ValueFactory.getInstance().tuple(fields));
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.mapContent.keyIterator();
    }

    @Override
    public IValue get(IValue key) {
        return (IValue)this.mapContent.get(key);
    }

    @Override
    public Supplier<IWriter<IMap>> supplier() {
        return () -> ValueFactory.getInstance().mapWriter();
    }
}

