/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.primitive;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.impl.primitive.AbstractNumberValue;
import io.usethesource.vallang.impl.primitive.BoolValue;
import io.usethesource.vallang.impl.primitive.IntegerValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

class RationalValue
extends AbstractNumberValue
implements IRational {
    public static final Type RATIONAL_TYPE = TypeFactory.getInstance().rationalType();
    protected final IInteger num;
    protected final IInteger denom;

    static IRational newRational(IInteger a, IInteger b) {
        return new RationalValue(a, b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RationalValue(IInteger num, IInteger denom) {
        if (denom.signum() < 0) {
            num = num.negate();
            denom = denom.negate();
        }
        if (denom.signum() == 0) {
            if (num.signum() > 0) {
                num = RationalValue.intOne();
            } else {
                if (num.signum() >= 0) throw new ArithmeticException("Illegal fraction 0/0");
                num = RationalValue.intOne().negate();
            }
        } else if (num.signum() == 0) {
            denom = RationalValue.intOne();
        } else {
            IInteger gcd = RationalValue.gcd(num, denom);
            while (gcd.compare(RationalValue.intOne()) != 0) {
                num = num.divide(gcd);
                denom = denom.divide(gcd);
                gcd = RationalValue.gcd(num, denom);
            }
        }
        this.num = num;
        this.denom = denom;
    }

    @Override
    public IRational add(IRational other) {
        return this.toRational(this.num.multiply(other.denominator()).add(this.denom.multiply(other.numerator())), this.denom.multiply(other.denominator()));
    }

    @Override
    public IReal add(IReal other) {
        return this.toReal(other.precision()).add(other);
    }

    @Override
    public INumber add(IInteger other) {
        return this.toRational(this.num.add(other.multiply(this.denom)), this.denom);
    }

    @Override
    public IRational subtract(IRational other) {
        return this.toRational(this.num.multiply(other.denominator()).subtract(this.denom.multiply(other.numerator())), this.denom.multiply(other.denominator()));
    }

    @Override
    public INumber subtract(IReal other) {
        return this.toReal(other.precision()).subtract(other);
    }

    @Override
    public INumber subtract(IInteger other) {
        return this.toRational(this.num.subtract(other.multiply(this.denom)), this.denom);
    }

    @Override
    public IRational multiply(IRational other) {
        return this.toRational(this.num.multiply(other.numerator()), this.denom.multiply(other.denominator()));
    }

    @Override
    public IReal multiply(IReal other) {
        return this.toReal(other.precision()).multiply(other);
    }

    @Override
    public INumber multiply(IInteger other) {
        return this.toRational(this.num.multiply(other), this.denom);
    }

    @Override
    public IRational divide(IRational other) {
        return this.toRational(this.num.multiply(other.denominator()), this.denom.multiply(other.numerator()));
    }

    @Override
    public IReal divide(IReal other, int precision) {
        return this.toReal(precision).divide(other, precision);
    }

    @Override
    public IRational divide(IInteger other, int precision) {
        return this.divide(other);
    }

    @Override
    public IRational divide(IInteger other) {
        if (other.equals(IntegerValue.INTEGER_ZERO)) {
            throw new ArithmeticException("/ by zero");
        }
        return this.toRational(this.num, this.denom.multiply(other));
    }

    @Override
    public INumber divide(IRational other, int precision) {
        return this.toRational(this.num.multiply(other.denominator()), this.denom.multiply(other.numerator()));
    }

    @Override
    public IBool less(IRational other) {
        return BoolValue.getBoolValue(this.compare(other) < 0);
    }

    @Override
    public IBool less(IReal other) {
        return other.greater(this);
    }

    @Override
    public IBool less(IInteger other) {
        return this.less(other.toRational());
    }

    @Override
    public IBool greater(IRational other) {
        return BoolValue.getBoolValue(this.compare(other) > 0);
    }

    @Override
    public IBool greater(IReal other) {
        return other.less(this);
    }

    @Override
    public IBool greater(IInteger other) {
        return this.greater(other.toRational());
    }

    @Override
    public IBool equal(IRational other) {
        return BoolValue.getBoolValue(this.compare(other) == 0);
    }

    @Override
    public IBool equal(IReal other) {
        return other.equal(this);
    }

    @Override
    public IBool equal(IInteger other) {
        return this.equal(other.toRational());
    }

    @Override
    public IBool lessEqual(IRational other) {
        return BoolValue.getBoolValue(this.compare(other) <= 0);
    }

    @Override
    public IBool lessEqual(IReal other) {
        return other.greaterEqual(this);
    }

    @Override
    public IBool lessEqual(IInteger other) {
        return this.lessEqual(other.toRational());
    }

    @Override
    public IBool greaterEqual(IRational other) {
        return BoolValue.getBoolValue(this.compare(other) >= 0);
    }

    @Override
    public IBool greaterEqual(IReal other) {
        return other.lessEqual(this);
    }

    @Override
    public IBool greaterEqual(IInteger other) {
        return this.greaterEqual(other.toRational());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() == this.getClass()) {
            RationalValue other = (RationalValue)o;
            return this.num.equals(other.num) && this.denom.equals(other.denom);
        }
        return false;
    }

    @Override
    public int compare(INumber other) {
        if (this.isIntegerType(other)) {
            IInteger div = this.num.divide(this.denom);
            IInteger rem = this.num.remainder(this.denom);
            if (div.compare(other) != 0) {
                return div.compare(other);
            }
            return rem.signum();
        }
        if (this.isRationalType(other)) {
            IRational diff = this.subtract((IRational)other);
            return diff.signum();
        }
        assert (other instanceof IReal);
        return this.toReal(((IReal)other).precision()).compare(other);
    }

    @Override
    public Type getType() {
        return RATIONAL_TYPE;
    }

    @Override
    public IRational negate() {
        return this.toRational(this.num.negate(), this.denom);
    }

    @Override
    public IReal toReal(int precision) {
        IReal r1 = this.num.toReal(precision);
        IReal r2 = this.denom.toReal(precision);
        r1 = r1.divide(r2, precision);
        return r1;
    }

    @Override
    public IInteger toInteger() {
        return this.num.divide(this.denom);
    }

    @Override
    public String getStringRepresentation() {
        return this.num.getStringRepresentation() + "r" + (this.denom.equals(RationalValue.intOne()) ? "" : this.denom.getStringRepresentation());
    }

    @Override
    public int compare(IRational other) {
        IRational diff = this.subtract(other);
        return diff.signum();
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public IRational abs() {
        return this.toRational(this.num.abs(), this.denom);
    }

    @Override
    public IInteger floor() {
        return this.num.divide(this.denom);
    }

    @Override
    public IInteger round() {
        return this.toReal(2).round().toInteger();
    }

    @Override
    public IRational toRational() {
        return this;
    }

    public IRational toRational(IInteger n, IInteger d) {
        return RationalValue.newRational(n, d);
    }

    @Override
    public IRational remainder(IRational other) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        if (this.denom.equals(RationalValue.intOne())) {
            return this.num.hashCode();
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.num.hashCode();
        result = 31 * result + this.denom.hashCode();
        return result;
    }

    @Override
    public IInteger numerator() {
        return this.num;
    }

    @Override
    public IInteger denominator() {
        return this.denom;
    }

    @Override
    public IInteger remainder() {
        return this.num.remainder(this.denom);
    }

    protected static IInteger gcd(IInteger n, IInteger d) {
        n = n.abs();
        d = d.abs();
        while (d.signum() > 0) {
            IInteger tmp = d;
            d = n.mod(d);
            n = tmp;
        }
        return n;
    }

    protected static IInteger intOne() {
        return IntegerValue.INTEGER_ONE;
    }

    @Override
    public double doubleValue() {
        return this.num.doubleValue() / this.denom.doubleValue();
    }
}

