/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.message;

import io.usethesource.capsule.Map;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.io.binary.util.TrackLastRead;
import io.usethesource.vallang.io.binary.util.WindowCacheFactory;
import io.usethesource.vallang.io.binary.wire.IWireInputStream;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class IValueReader {
    private static final TypeFactory tf = TypeFactory.getInstance();
    private static final Type VOID_TYPE = tf.voidType();
    private final Supplier<TypeStore> typeStoreSupplier;
    private final IValueFactory vf;
    private final TypeStore store;
    private final TrackLastRead<Type> typeWindow;
    private final TrackLastRead<IValue> valueWindow;
    private final TrackLastRead<ISourceLocation> uriWindow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IValue readValue(IWireInputStream reader, IValueFactory vf, Supplier<TypeStore> typeStoreSupplier) throws IOException {
        int typeWindowSize = 0;
        int valueWindowSize = 0;
        int uriWindowSize = 0;
        if (reader.next() != 0 || reader.message() != 4242) {
            throw new IOException("Missing header at start of stream");
        }
        block9: while (reader.next() != 2) {
            switch (reader.field()) {
                case 1: {
                    valueWindowSize = reader.getInteger();
                    continue block9;
                }
                case 2: {
                    typeWindowSize = reader.getInteger();
                    continue block9;
                }
                case 3: {
                    uriWindowSize = reader.getInteger();
                    continue block9;
                }
                case 4: {
                    IValueReader valueReader = new IValueReader(vf, typeStoreSupplier, typeWindowSize, valueWindowSize, uriWindowSize);
                    try {
                        IValue result = valueReader.readValue(reader);
                        reader.skipMessage();
                        IValue iValue = result;
                        return iValue;
                    }
                    finally {
                        valueReader.done();
                    }
                }
            }
            reader.skipNestedField();
        }
        throw new IOException("Missing Value in the stream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type readType(IWireInputStream reader, IValueFactory vf, Supplier<TypeStore> typeStoreSupplier) throws IOException {
        int typeWindowSize = 0;
        int valueWindowSize = 0;
        int uriWindowSize = 0;
        if (reader.next() != 0 || reader.message() != 4242) {
            throw new IOException("Missing header at start of stream");
        }
        block9: while (reader.next() != 2) {
            switch (reader.field()) {
                case 1: {
                    valueWindowSize = reader.getInteger();
                    continue block9;
                }
                case 2: {
                    typeWindowSize = reader.getInteger();
                    continue block9;
                }
                case 3: {
                    uriWindowSize = reader.getInteger();
                    continue block9;
                }
                case 5: {
                    IValueReader valueReader = new IValueReader(vf, typeStoreSupplier, typeWindowSize, valueWindowSize, uriWindowSize);
                    try {
                        Type result = valueReader.readType(reader);
                        reader.skipMessage();
                        Type type = result;
                        return type;
                    }
                    finally {
                        valueReader.done();
                    }
                }
            }
            reader.skipNestedField();
        }
        throw new IOException("Missing Type in the stream");
    }

    private IValueReader(IValueFactory vf, Supplier<TypeStore> typeStoreSupplier, int typeWindowSize, int valueWindowSize, int uriWindowSize) {
        WindowCacheFactory windowFactory = WindowCacheFactory.getInstance();
        this.typeWindow = windowFactory.getTrackLastRead(typeWindowSize);
        this.valueWindow = windowFactory.getTrackLastRead(valueWindowSize);
        this.uriWindow = windowFactory.getTrackLastRead(uriWindowSize);
        this.typeStoreSupplier = typeStoreSupplier;
        this.vf = vf;
        this.store = typeStoreSupplier.get();
    }

    private void done() {
        WindowCacheFactory windowFactory = WindowCacheFactory.getInstance();
        windowFactory.returnTrackLastRead(this.typeWindow);
        windowFactory.returnTrackLastRead(this.valueWindow);
        windowFactory.returnTrackLastRead(this.uriWindow);
    }

    private Type readType(IWireInputStream reader) throws IOException {
        reader.next();
        switch (reader.message()) {
            case 102: {
                reader.skipMessage();
                return tf.boolType();
            }
            case 104: {
                reader.skipMessage();
                return tf.dateTimeType();
            }
            case 105: {
                reader.skipMessage();
                return tf.integerType();
            }
            case 112: {
                reader.skipMessage();
                return tf.nodeType();
            }
            case 106: {
                reader.skipMessage();
                return tf.numberType();
            }
            case 107: {
                reader.skipMessage();
                return tf.rationalType();
            }
            case 108: {
                reader.skipMessage();
                return tf.realType();
            }
            case 103: {
                reader.skipMessage();
                return tf.sourceLocationType();
            }
            case 109: {
                reader.skipMessage();
                return tf.stringType();
            }
            case 110: {
                reader.skipMessage();
                return tf.valueType();
            }
            case 111: {
                reader.skipMessage();
                return tf.voidType();
            }
            case 113: {
                String name = "";
                boolean backReference = false;
                Type typeParam = VOID_TYPE;
                block70: while (reader.next() != 2) {
                    switch (reader.field()) {
                        case 31: {
                            backReference = true;
                            continue block70;
                        }
                        case 1: {
                            name = reader.getString();
                            continue block70;
                        }
                        case 2: {
                            typeParam = this.readType(reader);
                            continue block70;
                        }
                    }
                    reader.skipNestedField();
                }
                assert (!name.isEmpty());
                return IValueReader.returnAndStore(backReference, this.typeWindow, tf.abstractDataTypeFromTuple(this.store, name, typeParam));
            }
            case 121: {
                String name = "";
                boolean backReference = false;
                Type typeParameters = VOID_TYPE;
                Type aliasedType = VOID_TYPE;
                block71: while (reader.next() != 2) {
                    switch (reader.field()) {
                        case 31: {
                            backReference = true;
                            continue block71;
                        }
                        case 1: {
                            name = reader.getString();
                            continue block71;
                        }
                        case 2: {
                            aliasedType = this.readType(reader);
                            continue block71;
                        }
                        case 3: {
                            typeParameters = this.readType(reader);
                            continue block71;
                        }
                    }
                    reader.skipNestedField();
                }
                assert (!name.isEmpty() && aliasedType != VOID_TYPE);
                return IValueReader.returnAndStore(backReference, this.typeWindow, tf.aliasTypeFromTuple(this.store, name, aliasedType, typeParameters));
            }
            case 114: {
                String name = "";
                boolean backReference = false;
                Type fieldTypes = VOID_TYPE;
                Type adtType = VOID_TYPE;
                while (reader.next() != 2) {
                    switch (reader.field()) {
                        case 31: {
                            backReference = true;
                            break;
                        }
                        case 1: {
                            name = reader.getString();
                            break;
                        }
                        case 2: {
                            adtType = this.readType(reader);
                            break;
                        }
                        case 3: {
                            fieldTypes = this.readType(reader);
                        }
                    }
                }
                assert (!name.isEmpty() && fieldTypes != VOID_TYPE && adtType != VOID_TYPE);
                return IValueReader.returnAndStore(backReference, this.typeWindow, tf.constructorFromTuple(this.store, adtType, name, fieldTypes));
            }
            case 115: {
                boolean backReference = false;
                @MonotonicNonNull IConstructor symbol = null;
                while (reader.next() != 2) {
                    switch (reader.field()) {
                        case 31: {
                            backReference = true;
                            break;
                        }
                        case 1: {
                            symbol = (IConstructor)this.readValue(reader);
                        }
                    }
                }
                if (symbol == null) {
                    throw new IOException("ExternalType is missing the SYMBOL field");
                }
                return IValueReader.returnAndStore(backReference, this.typeWindow, tf.fromSymbol(symbol, this.typeStoreSupplier.get(), p -> Collections.emptySet()));
            }
            case 117: {
                boolean backReference = false;
                Type elemType = VOID_TYPE;
                while (reader.next() != 2) {
                    switch (reader.field()) {
                        case 31: {
                            backReference = true;
                            break;
                        }
                        case 1: {
                            elemType = this.readType(reader);
                        }
                    }
                }
                return IValueReader.returnAndStore(backReference, this.typeWindow, tf.listType(elemType));
            }
            case 118: {
                boolean backReference = false;
                Type valType = VOID_TYPE;
                Type keyType = VOID_TYPE;
                while (reader.next() != 2) {
                    switch (reader.field()) {
                        case 31: {
                            backReference = true;
                            break;
                        }
                        case 1: {
                            keyType = this.readType(reader);
                            break;
                        }
                        case 2: {
                            valType = this.readType(reader);
                        }
                    }
                }
                return IValueReader.returnAndStore(backReference, this.typeWindow, tf.mapType(keyType, valType));
            }
            case 120: {
                String name = "";
                boolean backReference = false;
                Type bound = VOID_TYPE;
                while (reader.next() != 2) {
                    switch (reader.field()) {
                        case 1: {
                            name = reader.getString();
                            break;
                        }
                        case 31: {
                            backReference = true;
                            break;
                        }
                        case 2: {
                            bound = this.readType(reader);
                        }
                    }
                }
                assert (!name.isEmpty());
                return IValueReader.returnAndStore(backReference, this.typeWindow, tf.parameterType(name, bound));
            }
            case 119: {
                boolean backReference = false;
                Type elemType = VOID_TYPE;
                while (reader.next() != 2) {
                    switch (reader.field()) {
                        case 31: {
                            backReference = true;
                            break;
                        }
                        case 1: {
                            elemType = this.readType(reader);
                        }
                    }
                }
                return IValueReader.returnAndStore(backReference, this.typeWindow, tf.setType(elemType));
            }
            case 116: {
                boolean backReference = false;
                String[] fieldNames = new String[]{};
                Type[] elemTypes = new Type[]{};
                block78: while (reader.next() != 2) {
                    switch (reader.field()) {
                        case 1: {
                            fieldNames = reader.getStrings();
                            break;
                        }
                        case 2: {
                            elemTypes = new Type[reader.getRepeatedLength()];
                            for (int i = 0; i < elemTypes.length; ++i) {
                                elemTypes[i] = this.readType(reader);
                            }
                            continue block78;
                        }
                        case 31: {
                            backReference = true;
                        }
                    }
                }
                if (fieldNames.length != 0) {
                    assert (fieldNames.length == elemTypes.length);
                    return IValueReader.returnAndStore(backReference, this.typeWindow, tf.tupleType(elemTypes, fieldNames));
                }
                return IValueReader.returnAndStore(backReference, this.typeWindow, tf.tupleType(elemTypes));
            }
            case 101: {
                int n = -1;
                block80: while (reader.next() != 2) {
                    switch (reader.field()) {
                        case 1: {
                            n = reader.getInteger();
                            continue block80;
                        }
                    }
                    reader.skipNestedField();
                }
                if (n == -1) {
                    throw new IOException("Missing HOW_LONG_AGO field in PreviousType");
                }
                return this.typeWindow.lookBack(n);
            }
        }
        throw new IOException("Unexpected new message: " + reader.message());
    }

    private static <T> T returnAndStore(boolean backReferenced, TrackLastRead<T> window, T value) {
        if (backReferenced) {
            window.read(value);
        }
        return value;
    }

    private IValue readValue(IWireInputStream reader) throws IOException {
        reader.next();
        assert (reader.current() == 0);
        switch (reader.message()) {
            case 2: {
                return this.readBoolean(reader);
            }
            case 7: {
                return this.readConstructor(reader);
            }
            case 32: {
                return this.readDateTime(reader);
            }
            case 3: {
                return this.readInteger(reader);
            }
            case 10: {
                return this.readList(reader);
            }
            case 5: {
                return this.readSourceLocation(reader);
            }
            case 11: {
                return this.readMap(reader);
            }
            case 8: {
                return this.readNode(reader);
            }
            case 33: {
                return this.readRational(reader);
            }
            case 4: {
                return this.readReal(reader);
            }
            case 12: {
                return this.readSet(reader);
            }
            case 6: {
                return this.readString(reader);
            }
            case 9: {
                return this.readTuple(reader);
            }
            case 1: {
                return this.readPreviousValue(reader);
            }
        }
        throw new IllegalArgumentException("readValue: " + reader.message());
    }

    private IValue readPreviousValue(IWireInputStream reader) throws IOException {
        int n = -1;
        while (reader.next() != 2) {
            if (reader.field() != 1) continue;
            n = reader.getInteger();
            reader.skipMessage();
            break;
        }
        if (n == -1) {
            throw new IOException("Missing or incorrect HOW_FAR_BACK field");
        }
        return this.valueWindow.lookBack(n);
    }

    private IValue readTuple(IWireInputStream reader) throws IOException {
        boolean backReference = false;
        IValue[] children = new IValue[]{};
        block8: while (reader.next() != 2) {
            switch (reader.field()) {
                case 31: {
                    backReference = true;
                    continue block8;
                }
                case 1: {
                    int size = reader.getRepeatedLength();
                    children = new IValue[size];
                    switch (size) {
                        case 1: {
                            children[0] = this.readValue(reader);
                            continue block8;
                        }
                        case 2: {
                            children[0] = this.readValue(reader);
                            children[1] = this.readValue(reader);
                            continue block8;
                        }
                    }
                    for (int i = 0; i < children.length; ++i) {
                        children[i] = this.readValue(reader);
                    }
                    continue block8;
                }
            }
            reader.skipNestedField();
        }
        return IValueReader.returnAndStore(backReference, this.valueWindow, this.vf.tuple(children));
    }

    private IValue readSet(IWireInputStream reader) throws IOException {
        ISet result = this.vf.set(new IValue[0]);
        boolean backReference = false;
        while (reader.next() != 2) {
            block0 : switch (reader.field()) {
                case 31: {
                    backReference = true;
                    break;
                }
                case 1: {
                    int size = reader.getRepeatedLength();
                    switch (size) {
                        case 0: {
                            result = this.vf.set(new IValue[0]);
                            break block0;
                        }
                        case 1: {
                            result = this.vf.set(this.readValue(reader));
                            break block0;
                        }
                        case 2: {
                            result = this.vf.set(this.readValue(reader), this.readValue(reader));
                            break block0;
                        }
                    }
                    ISetWriter writer = this.vf.setWriter();
                    for (int i = 0; i < size; ++i) {
                        writer.insert(this.readValue(reader));
                    }
                    result = (ISet)writer.done();
                }
            }
        }
        return IValueReader.returnAndStore(backReference, this.valueWindow, result);
    }

    private IValue readList(IWireInputStream reader) throws IOException {
        IList result = this.vf.list(new IValue[0]);
        boolean backReference = false;
        while (reader.next() != 2) {
            block0 : switch (reader.field()) {
                case 31: {
                    backReference = true;
                    break;
                }
                case 1: {
                    int size = reader.getRepeatedLength();
                    switch (size) {
                        case 0: {
                            result = this.vf.list(new IValue[0]);
                            break block0;
                        }
                        case 1: {
                            result = this.vf.list(this.readValue(reader));
                            break block0;
                        }
                        case 2: {
                            IValue first = this.readValue(reader);
                            IValue second = this.readValue(reader);
                            result = this.vf.list(first, second);
                            break block0;
                        }
                    }
                    IListWriter writer = this.vf.listWriter();
                    for (int i = 0; i < size; ++i) {
                        writer.append(this.readValue(reader));
                    }
                    result = (IList)writer.done();
                }
            }
        }
        return IValueReader.returnAndStore(backReference, this.valueWindow, result);
    }

    private IValue readMap(IWireInputStream reader) throws IOException {
        IMapWriter result = this.vf.mapWriter();
        boolean backReference = false;
        while (reader.next() != 2) {
            switch (reader.field()) {
                case 31: {
                    backReference = true;
                    break;
                }
                case 1: {
                    int size = reader.getRepeatedLength();
                    for (int i = 0; i < size; i += 2) {
                        IValue key = this.readValue(reader);
                        IValue value = this.readValue(reader);
                        result.put(key, value);
                    }
                    break;
                }
            }
        }
        return IValueReader.returnAndStore(backReference, this.valueWindow, result.done());
    }

    private IValue readNode(IWireInputStream reader) throws IOException {
        String name = "";
        IValue[] children = new IValue[]{};
        Map.Immutable<Object, Object> kwParams = Map.Immutable.of();
        Map.Immutable<Object, Object> annos = Map.Immutable.of();
        boolean backReference = false;
        block7: while (reader.next() != 2) {
            switch (reader.field()) {
                case 31: {
                    backReference = true;
                    break;
                }
                case 1: {
                    name = reader.getString();
                    break;
                }
                case 2: {
                    children = new IValue[reader.getRepeatedLength()];
                    for (int i = 0; i < children.length; ++i) {
                        children[i] = this.readValue(reader);
                    }
                    continue block7;
                }
                case 3: {
                    kwParams = this.readNamedValues(reader);
                    break;
                }
                case 4: {
                    annos = this.readNamedValues(reader);
                }
            }
        }
        INode node = this.vf.node(name, children);
        if (!annos.isEmpty()) {
            kwParams = this.simulateAnnotationsWithKeywordParameters(tf.nodeType(), kwParams, annos);
        }
        if (!kwParams.isEmpty()) {
            node = node.asWithKeywordParameters().setParameters(kwParams);
        }
        return IValueReader.returnAndStore(backReference, this.valueWindow, node);
    }

    private IValue readConstructor(IWireInputStream reader) throws IOException {
        Type type = VOID_TYPE;
        IValue[] children = new IValue[]{};
        Map.Immutable<Object, Object> annos = Map.Immutable.of();
        Map.Immutable<Object, Object> kwParams = Map.Immutable.of();
        boolean backReference = false;
        while (reader.next() != 2) {
            switch (reader.field()) {
                case 31: {
                    backReference = true;
                    break;
                }
                case 4: {
                    type = this.readType(reader);
                    break;
                }
                case 1: {
                    children = new IValue[reader.getRepeatedLength()];
                    switch (children.length) {
                        case 1: {
                            children[0] = this.readValue(reader);
                            break;
                        }
                        case 2: {
                            children[0] = this.readValue(reader);
                            children[1] = this.readValue(reader);
                            break;
                        }
                        case 3: {
                            children[0] = this.readValue(reader);
                            children[1] = this.readValue(reader);
                            children[2] = this.readValue(reader);
                            break;
                        }
                        default: {
                            for (int i = 0; i < children.length; ++i) {
                                children[i] = this.readValue(reader);
                            }
                        }
                    }
                    assert (this.paramsAreCorrectType(children, type));
                    break;
                }
                case 2: {
                    kwParams = this.readNamedValues(reader);
                    break;
                }
                case 3: {
                    annos = this.readNamedValues(reader);
                }
            }
        }
        if (type == VOID_TYPE) {
            throw new IOException("Constructor was missing type");
        }
        IConstructor constr = this.vf.constructor(type, children);
        if (!annos.isEmpty()) {
            kwParams = this.simulateAnnotationsWithKeywordParameters(constr.getType(), kwParams, annos);
        }
        if (!kwParams.isEmpty()) {
            constr = constr.asWithKeywordParameters().setParameters(kwParams);
        }
        return IValueReader.returnAndStore(backReference, this.valueWindow, constr);
    }

    @Deprecated
    private Map.Immutable<String, IValue> simulateAnnotationsWithKeywordParameters(Type receiver, Map.Immutable<String, IValue> kwParams, Map.Immutable<String, IValue> annos) {
        for (Map.Entry entry : () -> annos.entryIterator()) {
            String key = (String)entry.getKey();
            IValue value = (IValue)entry.getValue();
            kwParams = kwParams.__put(this.isLegacyParseTreeLocAnnotation(key, receiver) ? "src" : key, value);
        }
        return kwParams;
    }

    private boolean isLegacyParseTreeLocAnnotation(String key, Type receiver) {
        return key.equals("loc") && receiver.isAbstractData() && receiver.getName().equals("Tree");
    }

    private boolean paramsAreCorrectType(IValue[] children, Type type) {
        assert (children.length == type.getArity());
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getType().isSubtypeOf(type.getFieldType(i))) continue;
            return false;
        }
        return true;
    }

    private Map.Immutable<String, IValue> readNamedValues(IWireInputStream reader) throws IOException {
        Map.Transient<String, IValue> result = Map.Transient.of();
        String[] names = new String[]{};
        reader.next();
        while (reader.next() != 2) {
            switch (reader.field()) {
                case 1: {
                    names = reader.getStrings();
                    break;
                }
                case 2: {
                    assert (names.length == reader.getRepeatedLength());
                    for (String name : names) {
                        result.__put(name, this.readValue(reader));
                    }
                    break;
                }
            }
        }
        return result.freeze();
    }

    private IValue readString(IWireInputStream reader) throws IOException {
        String str = "";
        boolean backReference = false;
        block4: while (reader.next() != 2) {
            switch (reader.field()) {
                case 31: {
                    backReference = true;
                    continue block4;
                }
                case 1: {
                    str = reader.getString();
                    continue block4;
                }
            }
            reader.skipNestedField();
        }
        return IValueReader.returnAndStore(backReference, this.valueWindow, this.vf.string(str));
    }

    private IValue readReal(IWireInputStream reader) throws IOException {
        byte[] bytes = new byte[]{};
        int scale = 0;
        boolean backReference = false;
        block5: while (reader.next() != 2) {
            switch (reader.field()) {
                case 31: {
                    backReference = true;
                    continue block5;
                }
                case 2: {
                    scale = reader.getInteger();
                    continue block5;
                }
                case 1: {
                    bytes = reader.getBytes();
                    continue block5;
                }
            }
            reader.skipNestedField();
        }
        return IValueReader.returnAndStore(backReference, this.valueWindow, this.vf.real(new BigDecimal(new BigInteger(bytes), scale).toString()));
    }

    private IValue readRational(IWireInputStream reader) throws IOException {
        boolean backReference = false;
        IInteger denominator = this.vf.integer(0);
        IInteger numerator = this.vf.integer(0);
        block5: while (reader.next() != 2) {
            switch (reader.field()) {
                case 31: {
                    backReference = true;
                    continue block5;
                }
                case 2: {
                    denominator = (IInteger)this.readValue(reader);
                    continue block5;
                }
                case 1: {
                    numerator = (IInteger)this.readValue(reader);
                    continue block5;
                }
            }
            reader.skipNestedField();
        }
        return IValueReader.returnAndStore(backReference, this.valueWindow, this.vf.rational(numerator, denominator));
    }

    private IValue readSourceLocation(IWireInputStream reader) throws IOException {
        ISourceLocation loc;
        String scheme = "";
        String authority = "";
        String path = "";
        String query = null;
        String fragment = null;
        int previousURI = -1;
        int offset = -1;
        int length = -1;
        int beginLine = -1;
        int endLine = -1;
        int beginColumn = -1;
        int endColumn = -1;
        while (reader.next() != 2) {
            switch (reader.field()) {
                case 1: {
                    previousURI = reader.getInteger();
                    break;
                }
                case 8: {
                    scheme = reader.getString();
                    break;
                }
                case 9: {
                    authority = reader.getString();
                    break;
                }
                case 10: {
                    path = reader.getString();
                    break;
                }
                case 11: {
                    query = reader.getString();
                    break;
                }
                case 12: {
                    fragment = reader.getString();
                    break;
                }
                case 2: {
                    offset = reader.getInteger();
                    break;
                }
                case 3: {
                    length = reader.getInteger();
                    break;
                }
                case 4: {
                    beginLine = reader.getInteger();
                    break;
                }
                case 5: {
                    endLine = reader.getInteger();
                    break;
                }
                case 6: {
                    beginColumn = reader.getInteger();
                    break;
                }
                case 7: {
                    endColumn = reader.getInteger();
                }
            }
        }
        if (previousURI != -1) {
            loc = this.uriWindow.lookBack(previousURI);
        } else {
            try {
                loc = this.vf.sourceLocation(scheme, authority, path, query, fragment);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            this.uriWindow.read(loc);
        }
        if (beginLine >= 0) {
            assert (offset >= 0 && length >= 0 && endLine >= 0 && beginColumn >= 0 && endColumn >= 0);
            loc = this.vf.sourceLocation(loc, offset, length, beginLine, endLine, beginColumn, endColumn);
        } else if (offset >= 0) {
            assert (length >= 0);
            loc = this.vf.sourceLocation(loc, offset, length);
        }
        return loc;
    }

    private IValue readInteger(IWireInputStream reader) throws IOException {
        @MonotonicNonNull Integer small = null;
        byte @MonotonicNonNull [] big = null;
        while (reader.next() != 2) {
            switch (reader.field()) {
                case 1: {
                    small = reader.getInteger();
                    break;
                }
                case 2: {
                    big = reader.getBytes();
                }
            }
        }
        if (small != null) {
            return this.vf.integer(small);
        }
        if (big != null) {
            return this.vf.integer(big);
        }
        throw new RuntimeException("Missing field in INT_VALUE");
    }

    private IValue readDateTime(IWireInputStream reader) throws IOException {
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int minute = -1;
        int second = -1;
        int millisecond = -1;
        int timeZoneHourOffset = Integer.MAX_VALUE;
        int timeZoneMinuteOffset = Integer.MAX_VALUE;
        while (reader.next() != 2) {
            switch (reader.field()) {
                case 1: {
                    year = reader.getInteger();
                    break;
                }
                case 2: {
                    month = reader.getInteger();
                    break;
                }
                case 3: {
                    day = reader.getInteger();
                    break;
                }
                case 4: {
                    hour = reader.getInteger();
                    break;
                }
                case 5: {
                    minute = reader.getInteger();
                    break;
                }
                case 6: {
                    second = reader.getInteger();
                    break;
                }
                case 7: {
                    millisecond = reader.getInteger();
                    break;
                }
                case 8: {
                    timeZoneHourOffset = reader.getInteger();
                    break;
                }
                case 9: {
                    timeZoneMinuteOffset = reader.getInteger();
                }
            }
        }
        if (hour != -1 && year != -1) {
            return this.vf.datetime(year, month, day, hour, minute, second, millisecond, timeZoneHourOffset, timeZoneMinuteOffset);
        }
        if (hour != -1) {
            return this.vf.time(hour, minute, second, millisecond, timeZoneHourOffset, timeZoneMinuteOffset);
        }
        assert (year != -1);
        return this.vf.date(year, month, day);
    }

    private IValue readBoolean(IWireInputStream reader) throws IOException {
        boolean value = false;
        while (reader.next() != 2) {
            if (reader.field() == 1) {
                value = true;
                continue;
            }
            reader.skipNestedField();
        }
        return this.vf.bool(value);
    }
}

