/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.UndeclaredAbstractDataTypeException;
import io.usethesource.vallang.random.util.RandomUtil;
import io.usethesource.vallang.type.ConstructorType;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.NodeType;
import io.usethesource.vallang.type.ParameterType;
import io.usethesource.vallang.type.TupleType;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

class AbstractDataType
extends NodeType {
    private final String fName;
    private final Type fParameters;

    protected AbstractDataType(String name, Type parameters) {
        this.fName = name;
        this.fParameters = parameters;
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfAbstractData(this);
    }

    @Override
    public boolean isOpen() {
        return this.getTypeParameters().isOpen();
    }

    @Override
    public Type lub(Type other) {
        return other.lubWithAbstractData(this);
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithAbstractData(this);
    }

    @Override
    public boolean intersects(Type other) {
        return other.intersectsWithAbstractData(this);
    }

    @Override
    protected boolean intersectsWithAbstractData(Type type) {
        if (!this.isParameterized()) {
            return type == this;
        }
        if (type.getName().equals(this.getName())) {
            return this.getTypeParameters().intersects(type.getTypeParameters());
        }
        return false;
    }

    @Override
    protected boolean isSubtypeOfNode(Type type) {
        return true;
    }

    @Override
    protected boolean isSubtypeOfAbstractData(Type type) {
        if (this == type) {
            return true;
        }
        if (this.getName().equals(type.getName())) {
            return this.getTypeParameters().isSubtypeOf(type.getTypeParameters());
        }
        return false;
    }

    @Override
    protected Type lubWithAbstractData(Type type) {
        if (this == type) {
            return this;
        }
        if (this.fName.equals(type.getName())) {
            return TF.abstractDataTypeFromTuple(new TypeStore(new TypeStore[0]), this.fName, this.getTypeParameters().lub(type.getTypeParameters()));
        }
        return TF.nodeType();
    }

    @Override
    protected Type lubWithConstructor(Type type) {
        return this.lubWithAbstractData(type.getAbstractDataType());
    }

    @Override
    protected Type glbWithNode(Type type) {
        return this;
    }

    @Override
    protected Type glbWithAbstractData(Type type) {
        if (this == type) {
            return this;
        }
        if (this.fName.equals(type.getName())) {
            return TF.abstractDataTypeFromTuple(new TypeStore(new TypeStore[0]), this.fName, this.getTypeParameters().glb(type.getTypeParameters()));
        }
        return TF.voidType();
    }

    @Override
    protected Type glbWithConstructor(Type type) {
        if (type.isSubtypeOf(this)) {
            return type;
        }
        return TF.voidType();
    }

    @Override
    public boolean isParameterized() {
        return !this.fParameters.isBottom();
    }

    @Override
    public boolean hasField(String fieldName, TypeStore store) {
        Type parameterizedADT = store.lookupAbstractDataType(this.getName());
        if (parameterizedADT == null) {
            throw new UndeclaredAbstractDataTypeException(this);
        }
        for (Type alt : store.lookupAlternatives(parameterizedADT)) {
            if (!alt.hasField(fieldName, store)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasKeywordField(String fieldName, TypeStore store) {
        Type parameterizedADT = store.lookupAbstractDataType(this.getName());
        if (parameterizedADT == null) {
            throw new UndeclaredAbstractDataTypeException(this);
        }
        if (store.getKeywordParameterType(this, fieldName) != null) {
            return true;
        }
        for (Type alt : store.lookupAlternatives(parameterizedADT)) {
            if (!alt.hasKeywordField(fieldName, store)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fName);
        if (this.isParameterized()) {
            sb.append("[");
            int idx = 0;
            for (Type elemType : this.fParameters) {
                if (idx++ > 0) {
                    sb.append(",");
                }
                sb.append(elemType.toString());
            }
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return 49991 + 49831 * this.fName.hashCode() + 49991 + this.fParameters.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(this.getClass())) {
            AbstractDataType other = (AbstractDataType)o;
            return this.fName.equals(other.fName) && this.fParameters == other.fParameters;
        }
        return false;
    }

    @Override
    public Type instantiate(Map<Type, Type> bindings) {
        if (bindings.isEmpty() || !this.isParameterized()) {
            return this;
        }
        TypeStore store = new TypeStore(new TypeStore[0]);
        Type params = this.instantiateTuple((TupleType)this.fParameters, bindings);
        return TypeFactory.getInstance().abstractDataTypeFromTuple(store, this.fName, params);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Type getTypeParameters() {
        return this.fParameters;
    }

    @Override
    public Type getAbstractDataType() {
        return this;
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitAbstractData(this);
    }

    @Override
    public boolean match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        if (!super.match(matched, bindings)) {
            return false;
        }
        if (matched.isAbstractData() || matched.isAliased() && matched.getAliased().isAbstractData() || matched.isBottom()) {
            return this.getTypeParameters().match(matched.getTypeParameters(), bindings);
        }
        return true;
    }

    @Override
    public IValue randomValue(Random random, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxWidth) {
        IValue done = RandomUtil.randomADT(this, random, vf, store, typeParameters, maxDepth, maxWidth);
        this.match(done.getType(), typeParameters);
        return done;
    }

    @Override
    public boolean isAbstractData() {
        return true;
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            return this.symbols().typeSymbolConstructor("adt", Type.TF.stringType(), "name", Type.TF.listType(this.symbols().symbolADT()), "parameters");
        }

        @Override
        public IConstructor toSymbol(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            IConstructor res = this.simpleToSymbol(type, vf, store, grammar, done);
            if (!done.contains(res)) {
                Type adt;
                done.add(res);
                if (type.getTypeParameters().getArity() != 0 && (adt = store.lookupAbstractDataType(type.getName())) != null) {
                    type = adt;
                }
                this.asProductions(type, vf, store, grammar, done);
            }
            return res;
        }

        private IConstructor simpleToSymbol(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            IListWriter w = vf.listWriter();
            Type params = type.getTypeParameters();
            if (params.getArity() > 0) {
                for (Type param : params) {
                    w.append(param.asSymbol(vf, store, grammar, done));
                }
            }
            return vf.constructor(this.getSymbolConstructorType(), new IValue[]{vf.string(type.getName()), w.done()});
        }

        @Override
        public void asProductions(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            store.lookupAlternatives(type).stream().forEach(x -> x.asProductions(vf, store, grammar, done));
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            String name = ((IString)symbol.get("name")).getValue();
            Type adt = store.lookupAbstractDataType(name);
            if (adt != null) {
                return adt;
            }
            Type params = this.symbols().fromSymbols((IList)symbol.get("parameters"), store, grammar);
            adt = params.isBottom() || params.getArity() == 0 ? Type.TF.abstractDataType(store, name, new Type[0]) : Type.TF.abstractDataTypeFromTuple(store, name, params);
            for (IConstructor t2 : grammar.apply(symbol)) {
                ((ConstructorType.Info)t2.getConstructorType().getTypeReifier(this.symbols())).fromProduction(t2, store, grammar);
            }
            return adt;
        }

        @Override
        public boolean isRecursive() {
            return true;
        }

        @Override
        public Type randomInstance(Supplier<Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            Type adt;
            String adtName;
            Type[] adts;
            if (!rnd.isWithRandomAbstractDatatypes()) {
                return next.get();
            }
            if (rnd.nextBoolean() && (adts = store.getAbstractDataTypes().toArray(new Type[0])).length > 0) {
                return adts[rnd.nextInt(adts.length)];
            }
            while (store.lookupAbstractDataType(adtName = this.randomLabel(rnd)) != null) {
            }
            if (rnd.nextBoolean()) {
                Type param1 = new ParameterType.Info(this.symbols()).randomInstance(next, store, rnd.withTypeParameters());
                if (rnd.nextBoolean()) {
                    adt = this.tf().abstractDataTypeFromTuple(store, adtName, this.tf().tupleType(param1));
                } else {
                    Type param2 = new ParameterType.Info(this.symbols()).randomInstance(next, store, rnd.withTypeParameters());
                    adt = this.tf().abstractDataTypeFromTuple(store, adtName, this.tf().tupleType(param1, param2));
                }
            } else {
                adt = this.tf().abstractDataType(store, adtName, new Type[0]);
            }
            this.tf().constructor(store, adt, this.randomLabel(rnd), new Type[0]);
            if (rnd.nextBoolean()) {
                this.tf().constructorFromTuple(store, this.randomInstance(next, store, rnd), this.randomLabel(rnd), this.randomTuple(next, store, rnd));
            }
            return adt;
        }
    }
}

