/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.random.util.RandomUtil;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.NumberType;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

final class IntegerType
extends NumberType {
    IntegerType() {
    }

    public static IntegerType getInstance() {
        return InstanceKeeper.sInstance;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return obj == IntegerType.getInstance();
    }

    @Override
    public int hashCode() {
        return 74843;
    }

    @Override
    public String toString() {
        return "int";
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitInteger(this);
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfInteger(this);
    }

    @Override
    public Type lub(Type other) {
        return other.lubWithInteger(this);
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithInteger(this);
    }

    @Override
    protected boolean isSubtypeOfInteger(Type type) {
        return true;
    }

    @Override
    protected Type lubWithInteger(Type type) {
        return this;
    }

    @Override
    public boolean intersects(Type other) {
        return other.intersectsWithInteger(this);
    }

    @Override
    protected boolean intersectsWithInteger(Type type) {
        return true;
    }

    @Override
    protected boolean intersectsWithRational(Type type) {
        return false;
    }

    @Override
    protected boolean intersectsWithReal(Type type) {
        return false;
    }

    @Override
    protected Type glbWithReal(Type type) {
        return TF.voidType();
    }

    @Override
    protected Type glbWithRational(Type type) {
        return TF.voidType();
    }

    @Override
    protected Type glbWithNumber(Type type) {
        return this;
    }

    @Override
    public IValue randomValue(Random random, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxBreadth) {
        if (RandomUtil.oneEvery(random, 5) && maxDepth > 1) {
            return vf.integer(random.nextInt());
        }
        if (RandomUtil.oneEvery(random, 5)) {
            return vf.integer(random.nextInt(10));
        }
        if (RandomUtil.oneEvery(random, 5)) {
            return vf.integer(-random.nextInt(10));
        }
        if (RandomUtil.oneEvery(random, 20) && maxDepth > 1) {
            IInteger result = vf.integer(random.nextLong());
            do {
                result = result.multiply(vf.integer(random.nextLong()));
            } while ((double)random.nextFloat() > 0.4);
            return result.add(vf.integer(random.nextInt()));
        }
        return vf.integer(0);
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            return this.symbols().typeSymbolConstructor("int", new Object[0]);
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            return IntegerType.getInstance();
        }

        @Override
        public Type randomInstance(Supplier<Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return this.tf().integerType();
        }
    }

    private static final class InstanceKeeper {
        public static final IntegerType sInstance = new IntegerType();

        private InstanceKeeper() {
        }
    }
}

